/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.ux.localize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.localization.SystemLocalizationProvider;
import org.teamapps.application.server.ux.UiUtils;
import org.teamapps.application.server.ux.form.FormWindow;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationKeyFormat;
import org.teamapps.model.controlcenter.LocalizationKeyQuery;
import org.teamapps.model.controlcenter.LocalizationKeyType;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.model.controlcenter.MachineTranslationState;
import org.teamapps.model.controlcenter.TranslationState;
import org.teamapps.model.controlcenter.TranslationVerificationState;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.Fields;
import org.teamapps.ux.component.field.TextField;

public class LocalizationKeyWindow {
    public final Event<String> onNewKey = new Event();
    private final ApplicationInstanceData applicationInstanceData;
    private final SystemLocalizationProvider systemLocalizationProvider;
    private final List<Language> rankedLanguages;
    private final Application application;
    private FormWindow formWindow;
    private String newLocalizationKey;

    public static LocalizationKeyWindow createSystemKey(SystemLocalizationProvider systemLocalizationProvider, ApplicationInstanceData applicationInstanceData) {
        return new LocalizationKeyWindow(applicationInstanceData, null, systemLocalizationProvider);
    }

    public static LocalizationKeyWindow createApplicationKey(Application application, ApplicationInstanceData applicationInstanceData) {
        return new LocalizationKeyWindow(applicationInstanceData, application, null);
    }

    private LocalizationKeyWindow(ApplicationInstanceData applicationInstanceData, Application application, SystemLocalizationProvider systemLocalizationProvider) {
        this.applicationInstanceData = applicationInstanceData;
        this.systemLocalizationProvider = systemLocalizationProvider;
        this.rankedLanguages = applicationInstanceData.getUser().getRankedLanguages().stream().map(Language::getLanguageByIsoCode).filter(Objects::nonNull).collect(Collectors.toList());
        this.application = application;
        this.createUi();
    }

    private void createUi() {
        this.formWindow = new FormWindow(ApplicationIcons.ADDRESS_BOOK, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.translationKey", new Object[0]), this.applicationInstanceData);
        this.formWindow.setWindowSize(600, 450);
        this.formWindow.addSaveButton();
        this.formWindow.addCancelButton();
        this.formWindow.addSection();
        TextField keyField = new TextField();
        this.formWindow.addField(ApplicationIcons.KEY, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.translationKey", new Object[0]), (Component)keyField);
        HashMap<Language, TextField> valueFieldByLanguage = new HashMap<Language, TextField>();
        for (Language language : this.rankedLanguages) {
            TextField valueField = new TextField();
            valueFieldByLanguage.put(language, valueField);
            this.formWindow.addField((Icon)language.getIcon(), language.getLanguageLocalized(this.applicationInstanceData), (Component)valueField);
        }
        keyField.setRequired(true);
        keyField.addValidator(s -> {
            LocalizationKeyQuery keyQuery = LocalizationKey.filter();
            if (this.application != null) {
                keyQuery.key(TextFilter.textEqualsIgnoreCaseFilter((String)s)).application(NumericFilter.equalsFilter((Number)this.application.getId()));
            } else {
                keyQuery.key(TextFilter.textEqualsIgnoreCaseFilter((String)("org.teamapps.systemKey." + s))).localizationKeyType(EnumFilterType.EQUALS, LocalizationKeyType.SYSTEM_KEY);
            }
            LocalizationKey key = keyQuery.executeExpectSingleton();
            if (key != null || s == null || s.length() < 3 || s.contains(" ")) {
                return Collections.singletonList(new FieldMessage(FieldMessage.Severity.ERROR, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.errorTranslationKeyAlreadyExists", new Object[0])));
            }
            return null;
        });
        this.formWindow.getSaveButton().onClick.addListener(() -> {
            boolean success = false;
            if (Fields.validateAll((AbstractField[])new AbstractField[]{keyField})) {
                LocalizationKey localizationKey = LocalizationKey.create().setKey((String)keyField.getValue()).setUsed(true).setLocalizationKeyFormat(LocalizationKeyFormat.SINGLE_LINE);
                if (this.application != null) {
                    localizationKey.setApplication(this.application).setLocalizationKeyType(LocalizationKeyType.REPORTING_KEY);
                } else {
                    localizationKey.setKey("org.teamapps.systemKey." + (String)keyField.getValue()).setLocalizationKeyType(LocalizationKeyType.SYSTEM_KEY);
                }
                ArrayList<LocalizationValue> values = new ArrayList<LocalizationValue>();
                for (Language language : this.rankedLanguages) {
                    TextField field = (TextField)valueFieldByLanguage.get(language);
                    String value = (String)field.getValue();
                    if (value == null || value.isBlank()) continue;
                    LocalizationValue localizationValue = LocalizationValue.create().setLanguage(language.getIsoCode()).setOriginal(value).setCurrentDisplayValue(value).setMachineTranslationState(MachineTranslationState.NOT_NECESSARY).setTranslationState(TranslationState.NOT_NECESSARY).setTranslationVerificationState(TranslationVerificationState.NOT_NECESSARY);
                    values.add(localizationValue);
                }
                if (!values.isEmpty()) {
                    localizationKey.setLocalizationValues(values).save();
                    success = true;
                    this.newLocalizationKey = localizationKey.getKey();
                    this.formWindow.close();
                    if (this.application == null) {
                        this.systemLocalizationProvider.reload();
                    }
                    this.onNewKey.fire((Object)this.newLocalizationKey);
                }
            }
            UiUtils.showSaveNotification(success, this.applicationInstanceData);
        });
    }

    public void show() {
        this.formWindow.show();
    }

    public String getNewLocalizationKey() {
        return this.newLocalizationKey;
    }
}

