/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.ux.localize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.server.ux.localize.TranslatableFieldEntry;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.model.ComboBoxModel;
import org.teamapps.ux.model.ListTreeModel;

public class TranslatableField
extends ComboBox<TranslatableText> {
    private final ApplicationInstanceData applicationInstanceData;
    private List<Language> rankedLanguages;
    private TranslatableText originalText;
    private ListTreeModel<TranslatableText> model;
    private TranslatableFieldEntry selectedEntry;

    public TranslatableField(ApplicationInstanceData applicationInstanceData) {
        this.applicationInstanceData = applicationInstanceData;
        this.init();
        this.setValue(null);
    }

    private void init() {
        this.setTemplate((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        this.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_TWO_LINES);
        this.rankedLanguages = this.applicationInstanceData.getUser().getRankedLanguages().stream().filter(iso -> Language.getLanguageByIsoCode((String)iso) != null).map(Language::getLanguageByIsoCode).collect(Collectors.toList());
        this.setPropertyProvider(this.createPropertyProvider());
        this.model = new ListTreeModel(Collections.emptyList(), (translatableText, s) -> false);
        this.setModel((ComboBoxModel)this.model);
        this.setShowDropDownAfterResultsArrive(true);
        this.setAllowFreeText(true);
        this.setRecordToStringFunction(translatableText -> this.convert((TranslatableText)translatableText).getValue());
        this.setShowDropDownAfterResultsArrive(true);
        this.setFreeTextRecordFactory(s -> {
            TranslatableFieldEntry entry = this.selectedEntry;
            entry.setValue((String)s);
            return entry;
        });
        this.onValueChanged.addListener(value -> {
            TranslatableFieldEntry entry;
            this.selectedEntry = entry = this.convert((TranslatableText)value);
            super.setValue((Object)entry);
        });
    }

    private PropertyProvider<TranslatableText> createPropertyProvider() {
        return (translatableText, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            TranslatableFieldEntry entry = this.convert((TranslatableText)translatableText);
            map.put("icon", entry.getLanguage().getIcon());
            map.put("caption", entry.getValue());
            map.put("description", entry.getLanguage().getIsoCode() + " - " + entry.getLanguage().getLanguageLocalized(this.applicationInstanceData));
            return map;
        };
    }

    private TranslatableFieldEntry convert(TranslatableText translatableText) {
        return (TranslatableFieldEntry)translatableText;
    }

    public void setValue(TranslatableText translatableText) {
        this.originalText = translatableText;
        ArrayList<TranslatableFieldEntry> modelValues = new ArrayList<TranslatableFieldEntry>();
        if (translatableText == null) {
            for (Language language : this.rankedLanguages) {
                modelValues.add(new TranslatableFieldEntry(null, language, null));
            }
        } else {
            Map translationMap = translatableText.getTranslationMap();
            HashSet<Language> availableLanguages = new HashSet<Language>();
            for (Map.Entry mapEntry : translationMap.entrySet()) {
                Language language = Language.getLanguageByIsoCode((String)((String)mapEntry.getKey()));
                if (language == null) continue;
                availableLanguages.add(language);
                modelValues.add(new TranslatableFieldEntry((String)mapEntry.getValue(), language, translatableText));
            }
            for (Language language : this.rankedLanguages) {
                if (availableLanguages.contains(language)) continue;
                modelValues.add(new TranslatableFieldEntry(null, language, translatableText));
            }
        }
        TranslatableText record = (TranslatableText)modelValues.get(0);
        this.selectedEntry = this.convert(record);
        this.model.setRecords(modelValues);
        super.setValue((Object)record);
    }

    public TranslatableText getValue() {
        List entries = this.model.getRecords().stream().map(this::convert).collect(Collectors.toList());
        if (this.originalText != null) {
            for (TranslatableFieldEntry entry : entries) {
                this.originalText.setTranslation(entry.getValue(), entry.getLanguage().getIsoCode());
            }
            return this.originalText;
        }
        TranslatableText text = null;
        for (TranslatableFieldEntry entry : entries) {
            if (entry.getValue() == null) continue;
            if (text == null) {
                text = TranslatableText.create((String)entry.getValue(), (String)entry.getLanguage().getIsoCode());
                continue;
            }
            text.setTranslation(entry.getValue(), entry.getLanguage().getIsoCode());
        }
        return text;
    }
}

