/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPerspective;
import org.teamapps.model.controlcenter.ApplicationPrivilegeGroup;
import org.teamapps.model.controlcenter.ApplicationVersion;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;
import org.teamapps.universaldb.transaction.TransactionRecordValue;

public class UdbApplication
extends AbstractUdbEntity<Application>
implements Application {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static TextIndex name;
    protected static TextIndex icon;
    protected static TextIndex titleKey;
    protected static TextIndex descriptionKey;
    protected static BooleanIndex unmanagedApplication;
    protected static TextIndex config;
    protected static MultiReferenceIndex perspectives;
    protected static MultiReferenceIndex privilegeGroups;
    protected static MultiReferenceIndex versions;
    protected static SingleReferenceIndex installedVersion;
    protected static MultiReferenceIndex installedAsMainApplication;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        name = (TextIndex)tableIndex.getColumnIndex("name");
        icon = (TextIndex)tableIndex.getColumnIndex("icon");
        titleKey = (TextIndex)tableIndex.getColumnIndex("titleKey");
        descriptionKey = (TextIndex)tableIndex.getColumnIndex("descriptionKey");
        unmanagedApplication = (BooleanIndex)tableIndex.getColumnIndex("unmanagedApplication");
        config = (TextIndex)tableIndex.getColumnIndex("config");
        perspectives = (MultiReferenceIndex)tableIndex.getColumnIndex("perspectives");
        privilegeGroups = (MultiReferenceIndex)tableIndex.getColumnIndex("privilegeGroups");
        versions = (MultiReferenceIndex)tableIndex.getColumnIndex("versions");
        installedVersion = (SingleReferenceIndex)tableIndex.getColumnIndex("installedVersion");
        installedAsMainApplication = (MultiReferenceIndex)tableIndex.getColumnIndex("installedAsMainApplication");
    }

    public static List<Application> getAll() {
        return new EntityBitSetList(Application.getBuilder(), table.getRecordBitSet());
    }

    public static List<Application> sort(List<Application> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbApplication.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static List<Application> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return UdbApplication.sort((TableIndex)table, Application.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbApplication() {
        super(table);
    }

    public UdbApplication(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public Application build() {
        return new UdbApplication();
    }

    public Application build(int id) {
        return new UdbApplication(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public Application setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public Application setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public Application setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public Application setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public Application setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public Application setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public Application setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public Application setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public Application setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public Application setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public Application setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public Application setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public String getName() {
        return this.getTextValue(name);
    }

    @Override
    public Application setName(String value) {
        this.setTextValue(value, name);
        return this;
    }

    @Override
    public String getIcon() {
        return this.getTextValue(icon);
    }

    @Override
    public Application setIcon(String value) {
        this.setTextValue(value, icon);
        return this;
    }

    @Override
    public String getTitleKey() {
        return this.getTextValue(titleKey);
    }

    @Override
    public Application setTitleKey(String value) {
        this.setTextValue(value, titleKey);
        return this;
    }

    @Override
    public String getDescriptionKey() {
        return this.getTextValue(descriptionKey);
    }

    @Override
    public Application setDescriptionKey(String value) {
        this.setTextValue(value, descriptionKey);
        return this;
    }

    @Override
    public boolean getUnmanagedApplication() {
        return this.getBooleanValue(unmanagedApplication);
    }

    @Override
    public Application setUnmanagedApplication(boolean value) {
        this.setBooleanValue(value, unmanagedApplication);
        return this;
    }

    @Override
    public String getConfig() {
        return this.getTextValue(config);
    }

    @Override
    public Application setConfig(String value) {
        this.setTextValue(value, config);
        return this;
    }

    @Override
    public List<ApplicationPerspective> getPerspectives() {
        return this.getMultiReferenceValue(perspectives, ApplicationPerspective.getBuilder());
    }

    @Override
    public Application setPerspectives(List<ApplicationPerspective> value) {
        this.setMultiReferenceValue(value, perspectives);
        return this;
    }

    @Override
    public int getPerspectivesCount() {
        return this.getMultiReferenceValueCount(perspectives, ApplicationPerspective.getBuilder());
    }

    @Override
    public Application setPerspectives(ApplicationPerspective ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), perspectives);
        return this;
    }

    @Override
    public BitSet getPerspectivesAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(perspectives, ApplicationPerspective.getBuilder());
    }

    @Override
    public Application addPerspectives(List<ApplicationPerspective> value) {
        this.addMultiReferenceValue(value, perspectives);
        return this;
    }

    @Override
    public Application addPerspectives(ApplicationPerspective ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), perspectives);
        return this;
    }

    @Override
    public Application removePerspectives(List<ApplicationPerspective> value) {
        this.removeMultiReferenceValue(value, perspectives);
        return this;
    }

    @Override
    public Application removePerspectives(ApplicationPerspective ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), perspectives);
        return this;
    }

    @Override
    public Application removeAllPerspectives() {
        this.removeAllMultiReferenceValue(perspectives);
        return this;
    }

    @Override
    public List<ApplicationPrivilegeGroup> getPrivilegeGroups() {
        return this.getMultiReferenceValue(privilegeGroups, ApplicationPrivilegeGroup.getBuilder());
    }

    @Override
    public Application setPrivilegeGroups(List<ApplicationPrivilegeGroup> value) {
        this.setMultiReferenceValue(value, privilegeGroups);
        return this;
    }

    @Override
    public int getPrivilegeGroupsCount() {
        return this.getMultiReferenceValueCount(privilegeGroups, ApplicationPrivilegeGroup.getBuilder());
    }

    @Override
    public Application setPrivilegeGroups(ApplicationPrivilegeGroup ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), privilegeGroups);
        return this;
    }

    @Override
    public BitSet getPrivilegeGroupsAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(privilegeGroups, ApplicationPrivilegeGroup.getBuilder());
    }

    @Override
    public Application addPrivilegeGroups(List<ApplicationPrivilegeGroup> value) {
        this.addMultiReferenceValue(value, privilegeGroups);
        return this;
    }

    @Override
    public Application addPrivilegeGroups(ApplicationPrivilegeGroup ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), privilegeGroups);
        return this;
    }

    @Override
    public Application removePrivilegeGroups(List<ApplicationPrivilegeGroup> value) {
        this.removeMultiReferenceValue(value, privilegeGroups);
        return this;
    }

    @Override
    public Application removePrivilegeGroups(ApplicationPrivilegeGroup ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), privilegeGroups);
        return this;
    }

    @Override
    public Application removeAllPrivilegeGroups() {
        this.removeAllMultiReferenceValue(privilegeGroups);
        return this;
    }

    @Override
    public List<ApplicationVersion> getVersions() {
        return this.getMultiReferenceValue(versions, ApplicationVersion.getBuilder());
    }

    @Override
    public Application setVersions(List<ApplicationVersion> value) {
        this.setMultiReferenceValue(value, versions);
        return this;
    }

    @Override
    public int getVersionsCount() {
        return this.getMultiReferenceValueCount(versions, ApplicationVersion.getBuilder());
    }

    @Override
    public Application setVersions(ApplicationVersion ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), versions);
        return this;
    }

    @Override
    public BitSet getVersionsAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(versions, ApplicationVersion.getBuilder());
    }

    @Override
    public Application addVersions(List<ApplicationVersion> value) {
        this.addMultiReferenceValue(value, versions);
        return this;
    }

    @Override
    public Application addVersions(ApplicationVersion ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), versions);
        return this;
    }

    @Override
    public Application removeVersions(List<ApplicationVersion> value) {
        this.removeMultiReferenceValue(value, versions);
        return this;
    }

    @Override
    public Application removeVersions(ApplicationVersion ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), versions);
        return this;
    }

    @Override
    public Application removeAllVersions() {
        this.removeAllMultiReferenceValue(versions);
        return this;
    }

    @Override
    public ApplicationVersion getInstalledVersion() {
        if (this.isChanged((ColumnIndex)installedVersion)) {
            return (ApplicationVersion)this.getReferenceChangeValue((ColumnIndex)installedVersion);
        }
        int id = installedVersion.getValue(this.getId());
        if (id > 0) {
            return ApplicationVersion.getById(id);
        }
        return null;
    }

    @Override
    public Application setInstalledVersion(ApplicationVersion value) {
        this.setSingleReferenceValue((ColumnIndex)installedVersion, value, table);
        return this;
    }

    @Override
    public List<ManagedApplication> getInstalledAsMainApplication() {
        return this.getMultiReferenceValue(installedAsMainApplication, ManagedApplication.getBuilder());
    }

    @Override
    public Application setInstalledAsMainApplication(List<ManagedApplication> value) {
        this.setMultiReferenceValue(value, installedAsMainApplication);
        return this;
    }

    @Override
    public int getInstalledAsMainApplicationCount() {
        return this.getMultiReferenceValueCount(installedAsMainApplication, ManagedApplication.getBuilder());
    }

    @Override
    public Application setInstalledAsMainApplication(ManagedApplication ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), installedAsMainApplication);
        return this;
    }

    @Override
    public BitSet getInstalledAsMainApplicationAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(installedAsMainApplication, ManagedApplication.getBuilder());
    }

    @Override
    public Application addInstalledAsMainApplication(List<ManagedApplication> value) {
        this.addMultiReferenceValue(value, installedAsMainApplication);
        return this;
    }

    @Override
    public Application addInstalledAsMainApplication(ManagedApplication ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), installedAsMainApplication);
        return this;
    }

    @Override
    public Application removeInstalledAsMainApplication(List<ManagedApplication> value) {
        this.removeMultiReferenceValue(value, installedAsMainApplication);
        return this;
    }

    @Override
    public Application removeInstalledAsMainApplication(ManagedApplication ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), installedAsMainApplication);
        return this;
    }

    @Override
    public Application removeAllInstalledAsMainApplication() {
        this.removeAllMultiReferenceValue(installedAsMainApplication);
        return this;
    }

    public UdbApplication save(Transaction transaction, boolean strictChangeVerification) {
        this.save(transaction, table, strictChangeVerification);
        return this;
    }

    public UdbApplication saveTransactional(boolean strictChangeVerification) {
        this.save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    public UdbApplication save() {
        this.save(table);
        return this;
    }

    public void delete(Transaction transaction) {
        this.delete(transaction, table);
    }

    public void delete() {
        this.delete(table);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(table.getName()).append(": ").append(this.getId()).append("\n");
        for (ColumnIndex column : table.getColumnIndices()) {
            sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(this.getId()));
            if (this.isChanged(column)) {
                TransactionRecordValue changeValue = this.getChangeValue(column);
                sb.append(" -> ").append(changeValue.getValue());
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

