/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.io.File;
import java.time.Instant;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationVersion;
import org.teamapps.model.controlcenter.ApplicationVersionData;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileIndex;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;
import org.teamapps.universaldb.transaction.TransactionRecordValue;

public class UdbApplicationVersion
extends AbstractUdbEntity<ApplicationVersion>
implements ApplicationVersion {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static SingleReferenceIndex application;
    protected static FileIndex binary;
    protected static TextIndex binaryHash;
    protected static TextIndex version;
    protected static TextIndex releaseNotes;
    protected static SingleReferenceIndex dataModelData;
    protected static SingleReferenceIndex localizationData;
    protected static SingleReferenceIndex privilegeData;
    protected static SingleReferenceIndex perspectiveData;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        application = (SingleReferenceIndex)tableIndex.getColumnIndex("application");
        binary = (FileIndex)tableIndex.getColumnIndex("binary");
        binaryHash = (TextIndex)tableIndex.getColumnIndex("binaryHash");
        version = (TextIndex)tableIndex.getColumnIndex("version");
        releaseNotes = (TextIndex)tableIndex.getColumnIndex("releaseNotes");
        dataModelData = (SingleReferenceIndex)tableIndex.getColumnIndex("dataModelData");
        localizationData = (SingleReferenceIndex)tableIndex.getColumnIndex("localizationData");
        privilegeData = (SingleReferenceIndex)tableIndex.getColumnIndex("privilegeData");
        perspectiveData = (SingleReferenceIndex)tableIndex.getColumnIndex("perspectiveData");
    }

    public static List<ApplicationVersion> getAll() {
        return new EntityBitSetList(ApplicationVersion.getBuilder(), table.getRecordBitSet());
    }

    public static List<ApplicationVersion> sort(List<ApplicationVersion> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbApplicationVersion.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static List<ApplicationVersion> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return UdbApplicationVersion.sort((TableIndex)table, ApplicationVersion.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbApplicationVersion() {
        super(table);
    }

    public UdbApplicationVersion(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public ApplicationVersion build() {
        return new UdbApplicationVersion();
    }

    public ApplicationVersion build(int id) {
        return new UdbApplicationVersion(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public ApplicationVersion setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public ApplicationVersion setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public ApplicationVersion setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public ApplicationVersion setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public ApplicationVersion setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public ApplicationVersion setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public ApplicationVersion setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public ApplicationVersion setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public ApplicationVersion setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public ApplicationVersion setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public ApplicationVersion setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public ApplicationVersion setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public Application getApplication() {
        if (this.isChanged((ColumnIndex)application)) {
            return (Application)this.getReferenceChangeValue((ColumnIndex)application);
        }
        int id = application.getValue(this.getId());
        if (id > 0) {
            return Application.getById(id);
        }
        return null;
    }

    @Override
    public ApplicationVersion setApplication(Application value) {
        this.setSingleReferenceValue((ColumnIndex)application, value, table);
        return this;
    }

    @Override
    public FileValue getBinary() {
        if (this.isChanged((ColumnIndex)binary)) {
            return (FileValue)this.getChangedValue((ColumnIndex)binary);
        }
        return binary.getValue(this.getId());
    }

    @Override
    public ApplicationVersion setBinary(File value) {
        FileValue storeFile = binary.storeFile(value);
        this.setChangeValue((ColumnIndex)binary, storeFile, table);
        return this;
    }

    @Override
    public ApplicationVersion setBinary(File value, String fileName) {
        FileValue storeFile = binary.storeFile(value, fileName);
        this.setChangeValue((ColumnIndex)binary, storeFile, table);
        return this;
    }

    @Override
    public String getBinaryHash() {
        return this.getTextValue(binaryHash);
    }

    @Override
    public ApplicationVersion setBinaryHash(String value) {
        this.setTextValue(value, binaryHash);
        return this;
    }

    @Override
    public String getVersion() {
        return this.getTextValue(version);
    }

    @Override
    public ApplicationVersion setVersion(String value) {
        this.setTextValue(value, version);
        return this;
    }

    @Override
    public String getReleaseNotes() {
        return this.getTextValue(releaseNotes);
    }

    @Override
    public ApplicationVersion setReleaseNotes(String value) {
        this.setTextValue(value, releaseNotes);
        return this;
    }

    @Override
    public ApplicationVersionData getDataModelData() {
        if (this.isChanged((ColumnIndex)dataModelData)) {
            return (ApplicationVersionData)this.getReferenceChangeValue((ColumnIndex)dataModelData);
        }
        int id = dataModelData.getValue(this.getId());
        if (id > 0) {
            return ApplicationVersionData.getById(id);
        }
        return null;
    }

    @Override
    public ApplicationVersion setDataModelData(ApplicationVersionData value) {
        this.setSingleReferenceValue((ColumnIndex)dataModelData, value, table);
        return this;
    }

    @Override
    public ApplicationVersionData getLocalizationData() {
        if (this.isChanged((ColumnIndex)localizationData)) {
            return (ApplicationVersionData)this.getReferenceChangeValue((ColumnIndex)localizationData);
        }
        int id = localizationData.getValue(this.getId());
        if (id > 0) {
            return ApplicationVersionData.getById(id);
        }
        return null;
    }

    @Override
    public ApplicationVersion setLocalizationData(ApplicationVersionData value) {
        this.setSingleReferenceValue((ColumnIndex)localizationData, value, table);
        return this;
    }

    @Override
    public ApplicationVersionData getPrivilegeData() {
        if (this.isChanged((ColumnIndex)privilegeData)) {
            return (ApplicationVersionData)this.getReferenceChangeValue((ColumnIndex)privilegeData);
        }
        int id = privilegeData.getValue(this.getId());
        if (id > 0) {
            return ApplicationVersionData.getById(id);
        }
        return null;
    }

    @Override
    public ApplicationVersion setPrivilegeData(ApplicationVersionData value) {
        this.setSingleReferenceValue((ColumnIndex)privilegeData, value, table);
        return this;
    }

    @Override
    public ApplicationVersionData getPerspectiveData() {
        if (this.isChanged((ColumnIndex)perspectiveData)) {
            return (ApplicationVersionData)this.getReferenceChangeValue((ColumnIndex)perspectiveData);
        }
        int id = perspectiveData.getValue(this.getId());
        if (id > 0) {
            return ApplicationVersionData.getById(id);
        }
        return null;
    }

    @Override
    public ApplicationVersion setPerspectiveData(ApplicationVersionData value) {
        this.setSingleReferenceValue((ColumnIndex)perspectiveData, value, table);
        return this;
    }

    public UdbApplicationVersion save(Transaction transaction, boolean strictChangeVerification) {
        this.save(transaction, table, strictChangeVerification);
        return this;
    }

    public UdbApplicationVersion saveTransactional(boolean strictChangeVerification) {
        this.save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    public UdbApplicationVersion save() {
        this.save(table);
        return this;
    }

    public void delete(Transaction transaction) {
        this.delete(transaction, table);
    }

    public void delete() {
        this.delete(table);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(table.getName()).append(": ").append(this.getId()).append("\n");
        for (ColumnIndex column : table.getColumnIndices()) {
            sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(this.getId()));
            if (this.isChanged(column)) {
                TransactionRecordValue changeValue = this.getChangeValue(column);
                sb.append(" -> ").append(changeValue.getValue());
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

