/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.SystemSettings;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;
import org.teamapps.universaldb.transaction.TransactionRecordValue;

public class UdbSystemSettings
extends AbstractUdbEntity<SystemSettings>
implements SystemSettings {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static TextIndex allowedBaseLanguages;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        allowedBaseLanguages = (TextIndex)tableIndex.getColumnIndex("allowedBaseLanguages");
    }

    public static List<SystemSettings> getAll() {
        return new EntityBitSetList(SystemSettings.getBuilder(), table.getRecordBitSet());
    }

    public static List<SystemSettings> sort(List<SystemSettings> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbSystemSettings.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static List<SystemSettings> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return UdbSystemSettings.sort((TableIndex)table, SystemSettings.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbSystemSettings() {
        super(table);
    }

    public UdbSystemSettings(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public SystemSettings build() {
        return new UdbSystemSettings();
    }

    public SystemSettings build(int id) {
        return new UdbSystemSettings(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public SystemSettings setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public SystemSettings setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public SystemSettings setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public SystemSettings setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public SystemSettings setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public SystemSettings setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public SystemSettings setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public SystemSettings setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public SystemSettings setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public SystemSettings setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public SystemSettings setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public SystemSettings setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public String getAllowedBaseLanguages() {
        return this.getTextValue(allowedBaseLanguages);
    }

    @Override
    public SystemSettings setAllowedBaseLanguages(String value) {
        this.setTextValue(value, allowedBaseLanguages);
        return this;
    }

    public UdbSystemSettings save(Transaction transaction, boolean strictChangeVerification) {
        this.save(transaction, table, strictChangeVerification);
        return this;
    }

    public UdbSystemSettings saveTransactional(boolean strictChangeVerification) {
        this.save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    public UdbSystemSettings save() {
        this.save(table);
        return this;
    }

    public void delete(Transaction transaction) {
        this.delete(transaction, table);
    }

    public void delete() {
        this.delete(table);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(table.getName()).append(": ").append(this.getId()).append("\n");
        for (ColumnIndex column : table.getColumnIndices()) {
            sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(this.getId()));
            if (this.isChanged(column)) {
                TransactionRecordValue changeValue = this.getChangeValue(column);
                sb.append(" -> ").append(changeValue.getValue());
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

