package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface NewsBoardMessage extends Entity<NewsBoardMessage> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_PUBLISHED = "published";
	final static String FIELD_HTML_MESSAGE = "htmlMessage";
	final static String FIELD_LANGUAGE = "language";
	final static String FIELD_IMAGES = "images";
	final static String FIELD_TRANSLATIONS = "translations";
	final static String FIELD_ORGANIZATION_FIELD = "organizationField";
	final static String FIELD_ORGANIZATION_UNIT = "organizationUnit";

    static NewsBoardMessage create() {
        return new UdbNewsBoardMessage();
    }

    static NewsBoardMessage create(int id) {
        return new UdbNewsBoardMessage(id, true);
    }

    static NewsBoardMessage getById(int id) {
        return new UdbNewsBoardMessage(id, false);
    }

    static EntityBuilder<NewsBoardMessage> getBuilder() {
        return new UdbNewsBoardMessage(0, false);
    }

    Instant getMetaCreationDate();

    NewsBoardMessage setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    NewsBoardMessage setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    NewsBoardMessage setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    NewsBoardMessage setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    NewsBoardMessage setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    NewsBoardMessage setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    NewsBoardMessage setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    NewsBoardMessage setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    NewsBoardMessage setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    NewsBoardMessage setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    NewsBoardMessage setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    NewsBoardMessage setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    NewsBoardMessage setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    NewsBoardMessage setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    NewsBoardMessage setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    NewsBoardMessage setMetaRestoredBy(int value);

    boolean getPublished();

    NewsBoardMessage setPublished(boolean value);

    boolean isPublished();

    String getHtmlMessage();

    NewsBoardMessage setHtmlMessage(String value);

    String getLanguage();

    NewsBoardMessage setLanguage(String value);

    List<NewsBoardMessageImage> getImages();

    NewsBoardMessage setImages(List<NewsBoardMessageImage> value);

    int getImagesCount();

    NewsBoardMessage setImages(NewsBoardMessageImage ... value);

    BitSet getImagesAsBitSet();

    NewsBoardMessage addImages(List<NewsBoardMessageImage> value);

    NewsBoardMessage addImages(NewsBoardMessageImage ... value);

    NewsBoardMessage removeImages(List<NewsBoardMessageImage> value);

    NewsBoardMessage removeImages(NewsBoardMessageImage ... value);

    NewsBoardMessage removeAllImages();

    List<NewsBoardMessageTranslation> getTranslations();

    NewsBoardMessage setTranslations(List<NewsBoardMessageTranslation> value);

    int getTranslationsCount();

    NewsBoardMessage setTranslations(NewsBoardMessageTranslation ... value);

    BitSet getTranslationsAsBitSet();

    NewsBoardMessage addTranslations(List<NewsBoardMessageTranslation> value);

    NewsBoardMessage addTranslations(NewsBoardMessageTranslation ... value);

    NewsBoardMessage removeTranslations(List<NewsBoardMessageTranslation> value);

    NewsBoardMessage removeTranslations(NewsBoardMessageTranslation ... value);

    NewsBoardMessage removeAllTranslations();

    OrganizationField getOrganizationField();

    NewsBoardMessage setOrganizationField(OrganizationField value);

    OrganizationUnit getOrganizationUnit();

    NewsBoardMessage setOrganizationUnit(OrganizationUnit value);


    static List<NewsBoardMessage> getAll() {
        return UdbNewsBoardMessage.getAll();
    }

    static List<NewsBoardMessage> getDeletedRecords() {
        return UdbNewsBoardMessage.getDeletedRecords();
    }

    static List<NewsBoardMessage> sort(List<NewsBoardMessage> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbNewsBoardMessage.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbNewsBoardMessage.getCount();
    }

    static NewsBoardMessageQuery filter() {
        return new UdbNewsBoardMessageQuery();
    }
}

