package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbLogin extends AbstractUdbEntity<Login> implements Login {
	protected static TableIndex table;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static SingleReferenceIndex user;
	protected static TextIndex ip;
	protected static TextIndex userAgent;
	protected static BooleanIndex mobileDevice;
	protected static TextIndex screenSize;
	protected static IntegerIndex dateLogin;
	protected static IntegerIndex dateLogout;
	protected static IntegerIndex activityCount;
	protected static IntegerIndex applicationOpenCount;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		user = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_USER);
		ip = (TextIndex) tableIndex.getColumnIndex(FIELD_IP);
		userAgent = (TextIndex) tableIndex.getColumnIndex(FIELD_USER_AGENT);
		mobileDevice = (BooleanIndex) tableIndex.getColumnIndex(FIELD_MOBILE_DEVICE);
		screenSize = (TextIndex) tableIndex.getColumnIndex(FIELD_SCREEN_SIZE);
		dateLogin = (IntegerIndex) tableIndex.getColumnIndex(FIELD_DATE_LOGIN);
		dateLogout = (IntegerIndex) tableIndex.getColumnIndex(FIELD_DATE_LOGOUT);
		activityCount = (IntegerIndex) tableIndex.getColumnIndex(FIELD_ACTIVITY_COUNT);
		applicationOpenCount = (IntegerIndex) tableIndex.getColumnIndex(FIELD_APPLICATION_OPEN_COUNT);
    }

    public static List<Login> getAll() {
        return new EntityBitSetList<>(Login.getBuilder(), table.getRecordBitSet());
    }

    public static List<Login> getDeletedRecords() {
        return new EntityBitSetList<>(Login.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<Login> sort(List<Login> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<Login> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, Login.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbLogin() {
        super(table);
    }

    public UdbLogin(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public Login build() {
        return new UdbLogin();
    }

    @Override
    public Login build(int id) {
        return new UdbLogin(id, false);
    }

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public Login setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public Login setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public Login setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public Login setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public Login setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public Login setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public Login setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public Login setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public User getUser() {
		if (isChanged(user)) {
			return (User) getReferenceChangeValue(user);
		} else {
			int id = user.getValue(getId());
			if (id > 0) {
				return User.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Login setUser(User value) {
		setSingleReferenceValue(user, value, table);
		return this;
	}

	@Override
	public String getIp() {
        return getTextValue(ip);
	}

	@Override
	public Login setIp(String value) {
	    setTextValue(value, this.ip);
		return this;
	}

	@Override
	public String getUserAgent() {
        return getTextValue(userAgent);
	}

	@Override
	public Login setUserAgent(String value) {
	    setTextValue(value, this.userAgent);
		return this;
	}

	@Override
	public boolean getMobileDevice() {
	    return getBooleanValue(mobileDevice);
	}

	@Override
	public Login setMobileDevice(boolean value) {
	    setBooleanValue(value, this.mobileDevice);
		return this;
	}

	@Override
	public boolean isMobileDevice() {
	    return getBooleanValue(mobileDevice);
	}

	@Override
	public String getScreenSize() {
        return getTextValue(screenSize);
	}

	@Override
	public Login setScreenSize(String value) {
	    setTextValue(value, this.screenSize);
		return this;
	}

	@Override
	public Instant getDateLogin() {
	    return getTimestampValue(dateLogin);
	}

	@Override
	public Login setDateLogin(Instant value) {
	    setTimestampValue(value, this.dateLogin);
		return this;
	}

	@Override
	public int getDateLoginAsEpochSecond() {
	    return getTimestampAsEpochSecond(dateLogin);
	}

	@Override
	public Login setDateLoginAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.dateLogin);
		return this;
	}

	@Override
	public long getDateLoginAsEpochMilli() {
	    return getTimestampAsEpochMilli(dateLogin);
	}

	@Override
	public Login setDateLoginAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.dateLogin);
		return this;
	}

	@Override
	public Instant getDateLogout() {
	    return getTimestampValue(dateLogout);
	}

	@Override
	public Login setDateLogout(Instant value) {
	    setTimestampValue(value, this.dateLogout);
		return this;
	}

	@Override
	public int getDateLogoutAsEpochSecond() {
	    return getTimestampAsEpochSecond(dateLogout);
	}

	@Override
	public Login setDateLogoutAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.dateLogout);
		return this;
	}

	@Override
	public long getDateLogoutAsEpochMilli() {
	    return getTimestampAsEpochMilli(dateLogout);
	}

	@Override
	public Login setDateLogoutAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.dateLogout);
		return this;
	}

	@Override
	public int getActivityCount() {
        return getIntValue(activityCount);
	}

	@Override
	public Login setActivityCount(int value) {
	    setIntValue(value, this.activityCount);
		return this;
	}

	@Override
	public int getApplicationOpenCount() {
        return getIntValue(applicationOpenCount);
	}

	@Override
	public Login setApplicationOpenCount(int value) {
	    setIntValue(value, this.applicationOpenCount);
		return this;
	}



    @Override
    public UdbLogin save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



