/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.applications;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.perspective.ApplicationPerspective;
import org.teamapps.application.api.application.perspective.PerspectiveBuilder;
import org.teamapps.application.api.application.perspective.PerspectiveMenuPanel;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.api.ui.FormMetaFields;
import org.teamapps.application.server.controlcenter.applications.ApplicationGroupsPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applications.ApplicationProvisioningPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applications.ApplicationUpdatesPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applications.ApplicationsPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applications.ApplicationsPerspectiveComponents;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.bootstrap.ApplicationInfoDataElement;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.tools.EntityListModelBuilder;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class ApplicationsPerspective
extends AbstractManagedApplicationPerspective {
    private final PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
    private final UserSessionData userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
    private final ApplicationsPerspectiveComponents perspectiveComponents;

    public ApplicationsPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.perspectiveComponents = new ApplicationsPerspectiveComponents(this.getApplicationInstanceData(), perspectiveInfoBadgeValue);
        this.createUI();
        this.createMenu();
    }

    private void createMenu() {
        ApplicationsPerspectiveBuilder applicationsPerspectiveBuilder = new ApplicationsPerspectiveBuilder();
        PerspectiveMenuPanel menuPanel = PerspectiveMenuPanel.createMenuPanel((ApplicationInstanceData)this.getApplicationInstanceData(), (PerspectiveBuilder[])new PerspectiveBuilder[]{applicationsPerspectiveBuilder, new ApplicationProvisioningPerspectiveBuilder(), new ApplicationGroupsPerspectiveBuilder(), new ApplicationUpdatesPerspectiveBuilder()});
        menuPanel.addInstantiatedPerspective((PerspectiveBuilder)applicationsPerspectiveBuilder, (ApplicationPerspective)this);
        this.setPerspectiveMenuPanel(menuPanel.getComponent(), (Component)menuPanel.getButtonMenu());
    }

    public void createUI() {
        View applicationsView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.BOX_SOFTWARE, (String)this.getLocalized("org.teamapps.dictionary.applications"), null));
        View applicationVersionsView = this.getPerspective().addView(View.createView((String)"center-bottom", (Icon)ApplicationIcons.BOX_SOFTWARE, (String)this.getLocalized("applications.versions"), null));
        View applicationDetailsView = this.getPerspective().addView(View.createView((String)"right", (Icon)ApplicationIcons.BOX_SOFTWARE, (String)this.getLocalized("applications.application"), null));
        applicationDetailsView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        EntityModelBuilder applicationModelBuilder = new EntityModelBuilder(Application::filter, this.getApplicationInstanceData());
        Table applicationsTable = applicationModelBuilder.createTemplateFieldTableList((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES, PropertyProviders.createApplicationPropertyProvider(this.userSessionData), 60);
        applicationModelBuilder.attachSearchField(applicationsView);
        applicationModelBuilder.attachViewCountHandler(applicationsView, () -> this.getLocalized("org.teamapps.dictionary.applications"));
        applicationModelBuilder.updateModels();
        applicationsView.setComponent((Component)applicationsTable);
        applicationModelBuilder.getOnSelectionEvent().addListener(app -> this.perspectiveComponents.getSelectedApplication().set(app));
        EntityListModelBuilder applicationVersionModelBuilder = new EntityListModelBuilder(this.getApplicationInstanceData());
        Table applicationVersinTable = applicationVersionModelBuilder.createTemplateFieldTableList((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, PropertyProviders.createApplicationVersionPropertyProvider(this.userSessionData), 36);
        applicationVersionModelBuilder.attachSearchField(applicationVersionsView);
        applicationVersionModelBuilder.attachViewCountHandler(applicationVersionsView, () -> this.getLocalized("applications.versions"));
        applicationVersionModelBuilder.updateModels();
        applicationVersionsView.setComponent((Component)applicationVersinTable);
        ResponsiveForm applicationForm = new ResponsiveForm(100, 0, 0);
        ResponsiveFormLayout formLayout = applicationForm.addResponsiveFormLayout(400);
        TextField appNameField = new TextField();
        TextField appTitleField = new TextField();
        TextField appDescriptionField = new TextField();
        TemplateField appTypeField = UiUtils.createBooleanTemplateField((Icon)ApplicationIcons.ERROR, (String)this.getLocalized("applications.unmanagedApplication"), (Icon)ApplicationIcons.OK, (String)this.getLocalized("applications.managedApplication"));
        TextField installedAppVersionField = new TextField();
        TagComboBox appPerspectivesCombo = new TagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        appPerspectivesCombo.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        appPerspectivesCombo.setPropertyProvider(PropertyProviders.createApplicationPerspectivePropertyProvider(this.userSessionData));
        TagComboBox asMainAppCombo = UiUtils.createTagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPropertyProvider(this.userSessionData));
        TagComboBox usedInCombo = UiUtils.createTagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPropertyProvider(this.userSessionData));
        TextField appVersionField = new TextField();
        DisplayField releaseField = new DisplayField(false, false);
        TemplateField dataModelChangesField = UiUtils.createIconFixedIconTemplateField((Icon)ApplicationIcons.DATA_CLOUD);
        TemplateField localizationChangesField = UiUtils.createIconFixedIconTemplateField((Icon)ApplicationIcons.EARTH);
        TemplateField privilegeChangesField = UiUtils.createIconFixedIconTemplateField((Icon)ApplicationIcons.KEYS);
        TemplateField perspectiveChangesField = UiUtils.createIconFixedIconTemplateField((Icon)ApplicationIcons.WINDOWS);
        DisplayField dataModelChangesDisplayField = new DisplayField(true, true);
        DisplayField localizationChangesDisplayField = new DisplayField(true, true);
        DisplayField privilegeChangesDisplayField = new DisplayField(true, true);
        DisplayField perspectiveChangesDisplayField = new DisplayField(true, true);
        List<AbstractField> fields = Arrays.asList(appNameField, appTitleField, appDescriptionField, appTypeField, installedAppVersionField, appPerspectivesCombo, asMainAppCombo, usedInCombo, appVersionField);
        fields.forEach(field -> field.setEditingMode(FieldEditingMode.READONLY));
        formLayout.addSection(ApplicationIcons.BOX_SOFTWARE, this.getLocalized("applications.application")).setDrawHeaderLine(false);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.appName"), (Component)appNameField);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.appTitle"), (Component)appTitleField);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.appDescription"), (Component)appDescriptionField);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.appType"), (Component)appTypeField);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.installedVersion"), (Component)installedAppVersionField);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.perspectives"), (Component)appPerspectivesCombo);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.installedAsMainApp"), (Component)asMainAppCombo);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.usdInApplications"), (Component)usedInCombo);
        formLayout.addSection(ApplicationIcons.BOX_SOFTWARE, this.getLocalized("applications.appVersion")).setDrawHeaderLine(true);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.appVersion"), (Component)appVersionField);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.releaseNotes"), (Component)releaseField);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.dataModelChanges"), (Component)dataModelChangesField);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.localizationDataChanges"), (Component)localizationChangesField);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.privilegesDataChanges"), (Component)privilegeChangesField);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.perspectivesDataChanges"), (Component)perspectiveChangesField);
        formLayout.addSection(ApplicationIcons.DATA_CLOUD, this.getLocalized("applications.dataModelChanges")).setDrawHeaderLine(true).setCollapsed(true);
        formLayout.addLabelAndComponent((Component)dataModelChangesDisplayField);
        formLayout.addSection(ApplicationIcons.EARTH, this.getLocalized("applications.localizationDataChanges")).setDrawHeaderLine(true).setCollapsed(true);
        formLayout.addLabelAndComponent((Component)localizationChangesDisplayField);
        formLayout.addSection(ApplicationIcons.KEYS, this.getLocalized("applications.privilegesDataChanges")).setDrawHeaderLine(true).setCollapsed(true);
        formLayout.addLabelAndComponent((Component)privilegeChangesDisplayField);
        formLayout.addSection(ApplicationIcons.WINDOWS, this.getLocalized("applications.perspectivesDataChanges")).setDrawHeaderLine(true).setCollapsed(true);
        formLayout.addLabelAndComponent((Component)perspectiveChangesDisplayField);
        FormMetaFields formMetaFields = this.getApplicationInstanceData().getComponentFactory().createFormMetaFields();
        formMetaFields.addMetaFields(formLayout, false);
        applicationModelBuilder.getOnSelectionEvent().addListener(arg_0 -> ((FormMetaFields)formMetaFields).updateEntity(arg_0));
        applicationVersionModelBuilder.getOnSelectionEvent().addListener(version -> {
            dataModelChangesField.setValue((Object)ApplicationInfoDataElement.getChangeString(version.getDataModelData()));
            localizationChangesField.setValue((Object)ApplicationInfoDataElement.getChangeString(version.getLocalizationData()));
            privilegeChangesField.setValue((Object)ApplicationInfoDataElement.getChangeString(version.getPrivilegeData()));
            perspectiveChangesField.setValue((Object)ApplicationInfoDataElement.getChangeString(version.getPerspectiveData()));
            dataModelChangesDisplayField.setValue((Object)ApplicationInfoDataElement.getMultiLineChangeHtml(version.getDataModelData(), this.getLocalized("applications.addedData"), this.getLocalized("applications.removedData")));
            localizationChangesDisplayField.setValue((Object)ApplicationInfoDataElement.getMultiLineChangeHtml(version.getLocalizationData(), this.getLocalized("applications.addedData"), this.getLocalized("applications.removedData")));
            privilegeChangesDisplayField.setValue((Object)ApplicationInfoDataElement.getMultiLineChangeHtml(version.getPrivilegeData(), this.getLocalized("applications.addedData"), this.getLocalized("applications.removedData")));
            perspectiveChangesDisplayField.setValue((Object)ApplicationInfoDataElement.getMultiLineChangeHtml(version.getPerspectiveData(), this.getLocalized("applications.addedData"), this.getLocalized("applications.removedData")));
        });
        applicationModelBuilder.getOnSelectionEvent().addListener(app -> {
            applicationVersionModelBuilder.setRecords(app.getVersions());
            appNameField.setValue((Object)app.getName());
            appTitleField.setValue((Object)this.getLocalized(app.getTitleKey()));
            appDescriptionField.setValue((Object)this.getLocalized(app.getDescriptionKey()));
            appTypeField.setValue((Object)app.getUnmanagedApplication());
            installedAppVersionField.setValue((Object)app.getInstalledVersion().getVersion());
            appPerspectivesCombo.setValue(app.getPerspectives());
            asMainAppCombo.setValue(app.getInstalledAsMainApplication());
            usedInCombo.setValue(app.getPerspectives().stream().flatMap(p -> p.getManagedPerspectives().stream()).map(ManagedApplicationPerspective::getManagedApplication).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
            applicationDetailsView.getPanel().setIcon(IconUtils.decodeIcon((String)app.getIcon()));
            applicationDetailsView.getPanel().setTitle(this.userSessionData.getApplicationLocalizationProvider((Application)app).getLocalized(app.getTitleKey(), new Object[0]));
            applicationDetailsView.focus();
            applicationVersionModelBuilder.setSelectedRecord((Object)app.getInstalledVersion());
        });
        ToolbarButtonGroup buttonGroup = applicationDetailsView.addLocalButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton((ToolbarButton)ToolbarButton.createSmall((Icon)ApplicationIcons.UPLOAD, (String)this.getLocalized((String)"applications.installUpdate"))).onClick.addListener(() -> this.perspectiveComponents.showInstallApplicationDialogue((Application)applicationModelBuilder.getSelectedRecord()));
        buttonGroup = applicationDetailsView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton rollbackButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.SIGN_WARNING_HARMFUL, (String)this.getLocalized("applications.performRollback")));
        rollbackButton.onClick.addListener(() -> {});
        buttonGroup = applicationDetailsView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton((ToolbarButton)ToolbarButton.create((Icon)ApplicationIcons.INSTALL, (String)this.getLocalized((String)"applications.install"), (String)this.getLocalized((String)"applications.installApplication"))).onClick.addListener(() -> this.perspectiveComponents.showInstallApplicationDialogue(null));
        buttonGroup = applicationDetailsView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        this.perspectiveComponents.createToolbarButtons(buttonGroup);
        rollbackButton.setVisible(false);
        applicationModelBuilder.getOnSelectionEvent().addListener(() -> {
            Application application = (Application)applicationModelBuilder.getSelectedRecord();
            rollbackButton.setVisible(application.getVersionsCount() > 1);
        });
        applicationDetailsView.setComponent((Component)applicationForm);
    }

    public void showInstallBaseSystemDialogue() {
    }
}

