/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.cluster;

import java.text.DecimalFormat;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.cluster.core.Cluster;
import org.teamapps.cluster.core.Node;
import org.teamapps.cluster.core.RemoteNode;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.ListTable;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class ClusterNodesPerspective
extends AbstractManagedApplicationPerspective {
    private final UserSessionData userSessionData;
    private final TwoWayBindableValue<RemoteNode> selectedNode = TwoWayBindableValue.create();

    public ClusterNodesPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.createUi();
    }

    private void createUi() {
        SystemRegistry registry = this.userSessionData.getRegistry();
        Cluster cluster = registry.getCluster();
        View centerView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.RACK_SERVER_NETWORK, (String)this.getLocalized("cluster.clusterNodes"), null));
        View rightView = this.getPerspective().addView(View.createView((String)"right", (Icon)ApplicationIcons.RACK_SERVER_NETWORK, (String)this.getLocalized("cluster.clusterNodes"), null));
        if (cluster == null) {
            return;
        }
        ListTable table = new ListTable(cluster.getRemoteNodes());
        table.setDisplayAsList(true);
        table.setRowHeight(28);
        table.setStripedRows(false);
        table.addColumn("name", "Node ID", (AbstractField)new TextField()).setDefaultWidth(100).setValueExtractor(node -> node.getNodeId());
        table.addColumn("host", "Host", (AbstractField)new TextField()).setDefaultWidth(70).setValueExtractor(node -> node.getHostAddress().getHost());
        table.addColumn("port", "Port", (AbstractField)new TextField()).setDefaultWidth(70).setValueExtractor(node -> "" + node.getHostAddress().getPort());
        table.addColumn("sentBytes", "Bytes sent", (AbstractField)new TextField()).setDefaultWidth(70).setValueExtractor(node -> ClusterNodesPerspective.readableFileSize(node.getSentBytes()));
        table.addColumn("receivedBytes", "Bytes received", (AbstractField)new TextField()).setDefaultWidth(70).setValueExtractor(node -> ClusterNodesPerspective.readableFileSize(node.getReceivedBytes()));
        table.addColumn("sentMessages", "Messages sent", (AbstractField)new TextField()).setDefaultWidth(70).setValueExtractor(node -> "" + node.getSentMessages());
        table.addColumn("receivedMessages", "Messages received", (AbstractField)new TextField()).setDefaultWidth(70).setValueExtractor(node -> "" + node.getReceivedMessages());
        table.addColumn("reconnects", "Reconnects", (AbstractField)new TextField()).setDefaultWidth(70).setValueExtractor(node -> "" + node.getReconnects());
        table.addColumn("services", "Services", (AbstractField)new TagComboBox()).setDefaultWidth(150).setValueExtractor(Node::getServices);
        table.onSingleRowSelected.addListener(arg_0 -> this.selectedNode.set(arg_0));
        ResponsiveForm form = new ResponsiveForm(120, 200, 0);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        TextField nameField = new TextField();
        TextField hostField = new TextField();
        TextField portField = new TextField();
        TextField sentBytesField = new TextField();
        TextField receivedBytesField = new TextField();
        TextField sentMessagesField = new TextField();
        TextField receivedMessagesField = new TextField();
        TextField reconnectsField = new TextField();
        TagComboBox servicesField = new TagComboBox();
        servicesField.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        formLayout.addLabelAndField(null, "Node ID", (AbstractField)nameField);
        formLayout.addLabelAndField(null, "Host", (AbstractField)hostField);
        formLayout.addLabelAndField(null, "Port", (AbstractField)portField);
        formLayout.addLabelAndField(null, "Bytes sent", (AbstractField)sentBytesField);
        formLayout.addLabelAndField(null, "Bytes received", (AbstractField)receivedBytesField);
        formLayout.addLabelAndField(null, "Messages sent", (AbstractField)sentMessagesField);
        formLayout.addLabelAndField(null, "Messages received", (AbstractField)receivedMessagesField);
        formLayout.addLabelAndField(null, "Reconnects", (AbstractField)reconnectsField);
        formLayout.addLabelAndField(null, "Services", (AbstractField)servicesField);
        this.selectedNode.onChanged().addListener(node -> {
            nameField.setValue((Object)node.getNodeId());
            hostField.setValue((Object)node.getHostAddress().getHost());
            portField.setValue((Object)("" + node.getHostAddress().getPort()));
            sentBytesField.setValue((Object)ClusterNodesPerspective.readableFileSize(node.getSentBytes()));
            receivedBytesField.setValue((Object)ClusterNodesPerspective.readableFileSize(node.getReceivedBytes()));
            sentMessagesField.setValue((Object)("" + node.getSentMessages()));
            receivedMessagesField.setValue((Object)("" + node.getReceivedMessages()));
            reconnectsField.setValue((Object)("" + node.getReconnects()));
            servicesField.setValue(node.getServices());
        });
        ToolbarButtonGroup buttonGroup = centerView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton((ToolbarButton)ToolbarButton.create((Icon)ApplicationIcons.NAV_REFRESH, (String)"Refresh view", (String)"Refresh all values")).onClick.addListener(() -> table.setRecords(cluster.getRemoteNodes()));
        centerView.setComponent((Component)table);
        rightView.setComponent((Component)form);
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }
}

