/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.launcher;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.perspective.ApplicationPerspective;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.launcher.ApplicationData;
import org.teamapps.application.server.system.launcher.ApplicationLauncher;
import org.teamapps.application.server.system.launcher.MobileApplicationNavigation;
import org.teamapps.application.server.system.launcher.PerspectiveByNameLauncher;
import org.teamapps.application.server.system.session.ManagedApplicationSessionData;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.animation.PageTransition;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.itemview.SimpleItem;
import org.teamapps.ux.component.itemview.SimpleItemGroup;
import org.teamapps.ux.component.itemview.SimpleItemView;
import org.teamapps.ux.component.mobile.MobileLayout;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.model.ListTreeModel;
import org.teamapps.ux.model.TreeModel;

public class ApplicationInstance
implements PerspectiveByNameLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final UserSessionData userSessionData;
    private final ApplicationData applicationData;
    private final Component applicationLauncher;
    private final MutableValue<ManagedApplicationPerspective> selectedPerspective;
    private boolean mobileInstance;
    private ToolbarButton backButton;
    private MobileLayout mobileLayout;
    private final Map<PerspectiveSessionData, ApplicationPerspective> applicationPerspectiveByPerspectiveBuilder = new HashMap<PerspectiveSessionData, ApplicationPerspective>();
    private View mobileApplicationMenu;
    private List<PerspectiveSessionData> sortedPerspectives;
    private Tree<PerspectiveSessionData> applicationMenuTree;

    public ApplicationInstance(UserSessionData userSessionData, ApplicationData applicationData, Component applicationLauncher, MutableValue<ManagedApplicationPerspective> selectedPerspective) {
        this.userSessionData = userSessionData;
        this.applicationData = applicationData;
        this.applicationLauncher = applicationLauncher;
        this.selectedPerspective = selectedPerspective;
        this.init();
    }

    private void init() {
        ManagedApplicationSessionData applicationSessionData = this.applicationData.getApplicationSessionData();
        this.sortedPerspectives = new ArrayList<PerspectiveSessionData>();
        List managedApplicationPerspectives = this.applicationData.getManagedApplication().getPerspectives().stream().sorted(Comparator.comparingInt(ManagedApplicationPerspective::getListingPosition)).collect(Collectors.toList());
        for (ManagedApplicationPerspective managedApplicationPerspective : managedApplicationPerspectives) {
            if (managedApplicationPerspective.getApplicationPerspective() == null) continue;
            PerspectiveSessionData perspectiveSessionData = applicationSessionData.createPerspectiveSessionData(managedApplicationPerspective, this);
            if (perspectiveSessionData == null) {
                LOGGER.error("Missing application loader for:" + managedApplicationPerspective.getApplicationPerspective());
            }
            if (perspectiveSessionData == null || perspectiveSessionData.getPerspectiveBuilder() == null || !perspectiveSessionData.getPerspectiveBuilder().isPerspectiveAccessible((ApplicationPrivilegeProvider)perspectiveSessionData)) continue;
            this.sortedPerspectives.add(perspectiveSessionData);
        }
    }

    public Component createApplication() {
        ManagedApplicationSessionData applicationSessionData = this.applicationData.getApplicationSessionData();
        ResponsiveApplication responsiveApplication = applicationSessionData.getResponsiveApplication();
        if (applicationSessionData.isUnmanagedApplication()) {
            applicationSessionData.getMainApplication().getBaseApplicationBuilder().build(responsiveApplication, applicationSessionData.getUnmanagedApplicationData());
            return responsiveApplication.getUi();
        }
        boolean toolbarApplicationMenu = this.applicationData.getManagedApplication().getToolbarApplicationMenu();
        this.backButton = toolbarApplicationMenu ? null : new ToolbarButton((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_SINGLE_LINE, (Object)new BaseTemplateRecord(ApplicationIcons.NAVIGATE_LEFT, this.getLocalized("org.teamapps.dictionary.back", new Object[0]), null));
        MobileLayout mobileLayout = this.mobileLayout = toolbarApplicationMenu ? null : new MobileLayout();
        if (toolbarApplicationMenu) {
            SimpleItemView<PerspectiveSessionData> applicationMenu = this.createApplicationMenu(this.sortedPerspectives);
            applicationSessionData.setApplicationToolbarMenuComponent((Component)applicationMenu);
            applicationMenu.onItemClicked.addListener(event -> {
                PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)((SimpleItem)event.getItem()).getPayload();
                this.showPerspective(perspectiveSessionData);
            });
        } else {
            this.applicationMenuTree = this.createApplicationMenuTree(this.sortedPerspectives);
            View applicationMenu = View.createView((String)"left", (Icon)ApplicationIcons.RADIO_BUTTON_GROUP, (String)this.getLocalized("org.teamapps.dictionary.menu", new Object[0]), null);
            responsiveApplication.addApplicationView(applicationMenu);
            applicationMenu.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.84f));
            VerticalLayout verticalLayout = new VerticalLayout();
            applicationMenu.setComponent((Component)verticalLayout);
            Toolbar toolbar = new Toolbar();
            ToolbarButtonGroup buttonGroup = toolbar.addButtonGroup(new ToolbarButtonGroup());
            buttonGroup.setShowGroupSeparator(false);
            this.backButton.setVisible(false);
            buttonGroup.addButton(this.backButton);
            verticalLayout.addComponent((Component)toolbar);
            this.mobileLayout.setContent(this.applicationMenuTree);
            verticalLayout.addComponentFillRemaining((Component)this.mobileLayout);
            this.backButton.onClick.addListener(() -> {
                this.backButton.setVisible(false);
                this.mobileLayout.setContent(this.applicationMenuTree, PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 500);
            });
            this.applicationMenuTree.onNodeSelected.addListener(this::showPerspective);
        }
        if (!this.sortedPerspectives.isEmpty()) {
            this.showPerspective(this.sortedPerspectives.get(0));
        }
        return responsiveApplication.getUi();
    }

    public Component createMobileApplication() {
        this.mobileInstance = true;
        ManagedApplicationSessionData applicationSessionData = this.applicationData.getApplicationSessionData();
        MobileApplicationNavigation mobileNavigation = applicationSessionData.getMobileNavigation();
        mobileNavigation.setApplicationLauncher(this.applicationLauncher);
        ResponsiveApplication responsiveApplication = applicationSessionData.getResponsiveApplication();
        if (applicationSessionData.isUnmanagedApplication()) {
            applicationSessionData.getMainApplication().getBaseApplicationBuilder().build(responsiveApplication, applicationSessionData.getUnmanagedApplicationData());
            return responsiveApplication.getUi();
        }
        this.mobileApplicationMenu = View.createView((String)"left", (Icon)ApplicationIcons.RADIO_BUTTON_GROUP, (String)this.getLocalized("org.teamapps.dictionary.applicationMenu", new Object[0]), null);
        this.mobileApplicationMenu.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.84f));
        responsiveApplication.addApplicationView(this.mobileApplicationMenu);
        this.mobileLayout = new MobileLayout();
        this.mobileApplicationMenu.setComponent((Component)this.mobileLayout);
        mobileNavigation.setApplicationMenu(this.mobileApplicationMenu);
        Tree<PerspectiveSessionData> tree = this.createApplicationMenuTree(this.sortedPerspectives);
        this.mobileLayout.setContent(tree);
        tree.onNodeSelected.addListener(this::showMobilePerspective);
        mobileNavigation.onBackOperation.addListener(() -> this.mobileLayout.setContent((Component)tree, PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 500));
        mobileNavigation.onShowViewRequest().fire((Object)this.mobileApplicationMenu);
        return responsiveApplication.getUi();
    }

    @Override
    public ApplicationPerspective showApplicationPerspective(String perspectiveName) {
        PerspectiveSessionData perspectiveSessionData = this.sortedPerspectives.stream().filter(p -> p.getPerspectiveBuilder().getName().equals(perspectiveName)).findFirst().orElse(null);
        if (perspectiveSessionData == null) {
            return null;
        }
        if (this.mobileInstance) {
            return this.showMobilePerspective(perspectiveSessionData);
        }
        return this.showPerspective(perspectiveSessionData);
    }

    private ApplicationPerspective showPerspective(PerspectiveSessionData perspectiveSessionData) {
        ManagedApplicationPerspective currentPerspective = perspectiveSessionData.getManagedApplicationPerspective();
        this.selectedPerspective.set((Object)currentPerspective);
        ApplicationLauncher.THREAD_LOCAL_MANAGED_PERSPECTIVE.set(currentPerspective);
        LOGGER.info("Open perspective");
        ResponsiveApplication responsiveApplication = perspectiveSessionData.getManagedApplicationSessionData().getResponsiveApplication();
        ApplicationPerspective applicationPerspective = this.applicationPerspectiveByPerspectiveBuilder.get(perspectiveSessionData);
        if (applicationPerspective == null) {
            applicationPerspective = perspectiveSessionData.getPerspectiveBuilder().build((ApplicationInstanceData)perspectiveSessionData, null);
            this.applicationPerspectiveByPerspectiveBuilder.put(perspectiveSessionData, applicationPerspective);
            responsiveApplication.addPerspective(applicationPerspective.getPerspective());
            if (applicationPerspective.getPerspectiveMenuPanel() != null) {
                if (perspectiveSessionData.getManagedApplicationPerspective().isToolbarPerspectiveMenu()) {
                    Component perspectiveMenuPanel = applicationPerspective.getPerspectiveMenuPanel();
                    perspectiveMenuPanel.setCssStyle("height", "300px");
                    if (perspectiveMenuPanel instanceof Tree) {
                        Tree menu = (Tree)perspectiveMenuPanel;
                        menu.onNodeSelected.addListener(() -> {});
                    }
                } else if (this.mobileLayout == null) {
                    View perspectiveMenuView = View.createView((String)"left", (Icon)ApplicationIcons.RADIO_BUTTON_GROUP, (String)this.getLocalized("org.teamapps.dictionary.applicationMenu", new Object[0]), null);
                    applicationPerspective.getPerspective().addView(perspectiveMenuView);
                    perspectiveMenuView.setComponent(applicationPerspective.getPerspectiveMenuPanel());
                }
            }
        } else {
            applicationPerspective.getOnPerspectiveRefreshRequested().fire();
        }
        if (this.applicationMenuTree != null && !perspectiveSessionData.equals(this.applicationMenuTree.getSelectedNode())) {
            this.applicationMenuTree.setSelectedNode((Object)perspectiveSessionData);
        }
        if (applicationPerspective.getPerspectiveMenuPanel() != null && perspectiveSessionData.getManagedApplicationPerspective().getToolbarPerspectiveMenu()) {
            perspectiveSessionData.getManagedApplicationSessionData().setPerspectiveToolbarMenuComponent(applicationPerspective.getPerspectiveToolbarMenuPanel() != null ? applicationPerspective.getPerspectiveToolbarMenuPanel() : applicationPerspective.getPerspectiveMenuPanel());
        } else {
            perspectiveSessionData.getManagedApplicationSessionData().setPerspectiveToolbarMenuComponent(null);
        }
        responsiveApplication.showPerspective(applicationPerspective.getPerspective());
        if (this.mobileLayout != null && applicationPerspective.getPerspectiveMenuPanel() != null && !perspectiveSessionData.getManagedApplicationPerspective().getToolbarPerspectiveMenu()) {
            this.backButton.setVisible(true);
            this.mobileLayout.setContent(applicationPerspective.getPerspectiveMenuPanel(), PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 500);
        }
        if (applicationPerspective instanceof AbstractManagedApplicationPerspective) {
            AbstractManagedApplicationPerspective managedApplicationPerspective = (AbstractManagedApplicationPerspective)applicationPerspective;
            managedApplicationPerspective.onPerspectiveInitialized.fire();
        }
        return applicationPerspective;
    }

    private ApplicationPerspective showMobilePerspective(PerspectiveSessionData perspectiveSessionData) {
        ManagedApplicationPerspective currentPerspective = perspectiveSessionData.getManagedApplicationPerspective();
        this.selectedPerspective.set((Object)currentPerspective);
        ApplicationLauncher.THREAD_LOCAL_MANAGED_PERSPECTIVE.set(currentPerspective);
        LOGGER.info("Open perspective");
        ResponsiveApplication responsiveApplication = perspectiveSessionData.getManagedApplicationSessionData().getResponsiveApplication();
        ApplicationPerspective applicationPerspective = this.applicationPerspectiveByPerspectiveBuilder.get(perspectiveSessionData);
        if (applicationPerspective == null) {
            applicationPerspective = perspectiveSessionData.getPerspectiveBuilder().build((ApplicationInstanceData)perspectiveSessionData, null);
            this.applicationPerspectiveByPerspectiveBuilder.put(perspectiveSessionData, applicationPerspective);
            responsiveApplication.addPerspective(applicationPerspective.getPerspective());
        } else {
            applicationPerspective.getOnPerspectiveRefreshRequested().fire();
        }
        Perspective perspective = applicationPerspective.getPerspective();
        if (perspective.getFocusedView() == null && applicationPerspective.getPerspectiveMenuPanel() != null) {
            perspective.setFocusedView(this.mobileApplicationMenu);
        }
        responsiveApplication.showPerspective(perspective);
        if (applicationPerspective.getPerspectiveMenuPanel() != null) {
            if (this.mobileApplicationMenu.equals(perspective.getFocusedView())) {
                this.mobileLayout.setContent(applicationPerspective.getPerspectiveMenuPanel(), PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 500);
            } else {
                this.mobileLayout.setContent(applicationPerspective.getPerspectiveMenuPanel());
            }
            perspectiveSessionData.getManagedApplicationSessionData().getMobileNavigation().setBackOperationAvailable(true);
        }
        return applicationPerspective;
    }

    private Tree<PerspectiveSessionData> createApplicationMenuTree(List<PerspectiveSessionData> sortedPerspectives) {
        ListTreeModel treeModel = new ListTreeModel(sortedPerspectives);
        Tree tree = new Tree((TreeModel)treeModel);
        tree.setShowExpanders(false);
        tree.setEntryTemplate((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        tree.setPropertyExtractor((perspectiveSessionData, propertyName) -> {
            switch (propertyName) {
                case "badge": {
                    return null;
                }
                case "icon": {
                    return perspectiveSessionData.getIcon();
                }
                case "caption": {
                    return perspectiveSessionData.getTitle();
                }
                case "description": {
                    return perspectiveSessionData.getDescription();
                }
            }
            return null;
        });
        return tree;
    }

    private SimpleItemView<PerspectiveSessionData> createApplicationMenu(List<PerspectiveSessionData> sortedPerspectives) {
        SimpleItemView itemView = new SimpleItemView();
        SimpleItemGroup itemGroup = itemView.addSingleColumnGroup(ApplicationIcons.WINDOWS, this.getLocalized("org.teamapps.dictionary.applicationPerspective", new Object[0]));
        itemGroup.setItemTemplate((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        sortedPerspectives.forEach(p -> itemGroup.addItem(p.getIcon(), p.getTitle(), p.getDescription()).setPayload(p));
        return itemView;
    }

    public String getLocalized(String key, Object ... objects) {
        return this.userSessionData.getLocalizationProvider().getLocalized(key, objects);
    }
}

