/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.launcher;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.desktop.ApplicationDesktop;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.auth.LoginHandler;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.bootstrap.LogoutHandler;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.system.config.ThemingConfig;
import org.teamapps.application.server.system.launcher.ApplicationData;
import org.teamapps.application.server.system.launcher.ApplicationGroupData;
import org.teamapps.application.server.system.launcher.ApplicationInstance;
import org.teamapps.application.server.system.launcher.MobileApplicationNavigation;
import org.teamapps.application.server.system.launcher.MobileAssembler;
import org.teamapps.application.server.system.session.ManagedApplicationSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.Login;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationGroup;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.model.controlcenter.User;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.assembler.ApplicationAssembler;
import org.teamapps.ux.application.assembler.DesktopApplicationAssembler;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.dialogue.FormDialogue;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.itemview.ItemGroup;
import org.teamapps.ux.component.itemview.SimpleItem;
import org.teamapps.ux.component.itemview.SimpleItemGroup;
import org.teamapps.ux.component.itemview.SimpleItemView;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.tabpanel.Tab;
import org.teamapps.ux.component.tabpanel.TabPanel;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.session.ClientInfo;
import org.teamapps.ux.session.SessionConfiguration;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.ux.session.StylingTheme;

public class ApplicationLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final ThreadLocal<ManagedApplication> THREAD_LOCAL_APPLICATION = new ThreadLocal();
    public static final ThreadLocal<ManagedApplicationPerspective> THREAD_LOCAL_MANAGED_PERSPECTIVE = new ThreadLocal();
    private final UserSessionData userSessionData;
    private final LogoutHandler logoutHandler;
    private final SystemRegistry registry;
    private final boolean mobileView;
    private List<ApplicationGroupData> sortedApplicationGroups;
    private Component applicationLauncher;
    private Set<ApplicationData> openedApplications = new HashSet<ApplicationData>();
    private Map<ApplicationData, Tab> tabByApplicationData = new HashMap<ApplicationData, Tab>();
    private Map<ApplicationData, Component> mobilAppByApplicationData = new HashMap<ApplicationData, Component>();
    private TabPanel applicationsTabPanel;
    private TwoWayBindableValue<ManagedApplication> selectedApplication = TwoWayBindableValue.create();
    private TwoWayBindableValue<ManagedApplicationPerspective> selectedPerspective = TwoWayBindableValue.create();
    private boolean selectedThemeIsDarkTheme;
    private int activityCount;
    private int applicationOpenCount;
    private final Login loginData;
    private Tab applicationLauncherTab;

    public ApplicationLauncher(UserSessionData userSessionData, LogoutHandler logoutHandler) {
        this.userSessionData = userSessionData;
        this.registry = userSessionData.getRegistry();
        ClientInfo clientInfo = userSessionData.getContext().getClientInfo();
        this.mobileView = clientInfo.isMobileDevice();
        this.logoutHandler = logoutHandler;
        this.loginData = this.createLoginData(userSessionData, clientInfo);
        userSessionData.getContext().onDestroyed.addListener(() -> this.loginData.setActivityCount(this.activityCount).setApplicationOpenCount(this.applicationOpenCount).setDateLogout(Instant.now()).save());
        userSessionData.getContext().addExecutionDecorator(runnable -> {
            try {
                UniversalDB.setUserId((int)userSessionData.getUser().getId());
                THREAD_LOCAL_APPLICATION.set((ManagedApplication)this.selectedApplication.get());
                THREAD_LOCAL_MANAGED_PERSPECTIVE.set((ManagedApplicationPerspective)this.selectedPerspective.get());
                ++this.activityCount;
                runnable.run();
            }
            catch (Throwable e) {
                LOGGER.error("Application crash", e);
                this.handleSessionException(e);
            }
            finally {
                UniversalDB.setUserId((int)0);
                THREAD_LOCAL_APPLICATION.set(null);
                THREAD_LOCAL_MANAGED_PERSPECTIVE.set(null);
            }
        }, false);
        this.selectedApplication.onChanged().addListener(this::handleApplicationSelection);
        userSessionData.getUser().setLastLogin(Instant.now()).save();
        userSessionData.setApplicationDesktopSupplier(this::createApplicationDesktop);
        this.initApplicationData();
        this.createApplicationLauncher();
        this.createMainView();
    }

    private Login createLoginData(UserSessionData userSessionData, ClientInfo clientInfo) {
        return (Login)Login.create().setUser(userSessionData.getUser()).setDateLogin(Instant.now()).setIp(clientInfo.getIp()).setUserAgent(clientInfo.getUserAgent()).setMobileDevice(clientInfo.isMobileDevice()).setScreenSize(clientInfo.getScreenWidth() + "x" + clientInfo.getScreenHeight()).save();
    }

    private void handleSessionException(Throwable e) {
        ManagedApplication managedApplication = (ManagedApplication)this.selectedApplication.get();
        ManagedApplicationPerspective perspective = THREAD_LOCAL_MANAGED_PERSPECTIVE.get();
        this.closeApplication(managedApplication);
        FormDialogue dialogue = FormDialogue.create((Icon)ApplicationIcons.SIGN_WARNING, (String)this.getLocalized("org.teamapps.dictionary.error", new Object[0]), (String)this.getLocalized("org.teamapps.dictionary.errorTheActiveApplicationCausedAnErrorAnWillBeClosed", new Object[0]));
        TemplateField managedApplicationField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPropertyProvider(this.userSessionData));
        TemplateField perspectiveField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPerspectivePropertyProvider(this.userSessionData));
        TextField errorField = new TextField();
        errorField.setEditingMode(FieldEditingMode.READONLY);
        managedApplicationField.setValue((Object)managedApplication);
        perspectiveField.setValue((Object)perspective);
        errorField.setValue((Object)e.getMessage());
        dialogue.addField(null, this.getLocalized("org.teamapps.dictionary.application", new Object[0]), (AbstractField)managedApplicationField);
        dialogue.addField(null, this.getLocalized("org.teamapps.dictionary.applicationPerspective", new Object[0]), (AbstractField)perspectiveField);
        dialogue.addField(null, this.getLocalized("org.teamapps.dictionary.error", new Object[0]), (AbstractField)errorField);
        dialogue.addOkButton(this.getLocalized("org.teamapps.dictionary.oK", new Object[0]));
        dialogue.setCloseOnEscape(true);
        dialogue.setAutoCloseOnOk(true);
        dialogue.setCloseable(true);
        dialogue.show();
    }

    private void handleApplicationSelection(ManagedApplication application) {
        if (application == null) {
            return;
        }
        THREAD_LOCAL_APPLICATION.set(application);
        if (application.isDarkTheme()) {
            this.userSessionData.getContext().setBackgroundImage("defaultDarkBackground", 0);
            SessionConfiguration configuration = SessionContext.current().getConfiguration();
            configuration.setTheme(StylingTheme.DARK);
            SessionContext.current().setConfiguration(configuration);
        } else {
            this.userSessionData.getContext().setBackgroundImage("defaultBackground", 0);
            SessionConfiguration configuration = SessionContext.current().getConfiguration();
            configuration.setTheme(StylingTheme.DEFAULT);
            SessionContext.current().setConfiguration(configuration);
        }
        this.selectedThemeIsDarkTheme = application.getDarkTheme();
    }

    private void handleApplicationLauncherSelection() {
        this.selectedApplication.set(null);
        if (this.selectedThemeIsDarkTheme) {
            this.userSessionData.getContext().setBackgroundImage("defaultBackground", 0);
            SessionConfiguration configuration = SessionContext.current().getConfiguration();
            configuration.setTheme(StylingTheme.DEFAULT);
            SessionContext.current().setConfiguration(configuration);
            this.selectedThemeIsDarkTheme = false;
        }
    }

    private void initApplicationData() {
        ArrayList<ApplicationGroupData> applicationGroups = new ArrayList<ApplicationGroupData>();
        for (ManagedApplicationGroup applicationGroup : ManagedApplicationGroup.getAll()) {
            ApplicationGroupData applicationGroupData = new ApplicationGroupData(applicationGroup, this.userSessionData);
            applicationGroups.add(applicationGroupData);
            for (ManagedApplication managedApplication : applicationGroup.getApplications()) {
                Application application = managedApplication.getMainApplication();
                LoadedApplication loadedApplication = this.registry.getLoadedApplication(application);
                if (loadedApplication == null || !loadedApplication.getBaseApplicationBuilder().isApplicationAccessible(this.userSessionData.getApplicationPrivilegeProvider(managedApplication))) continue;
                ManagedApplicationSessionData applicationSessionData = this.userSessionData.createManageApplicationSessionData(managedApplication, new MobileApplicationNavigation());
                ApplicationData applicationData = new ApplicationData(managedApplication, loadedApplication, applicationSessionData);
                applicationGroupData.addApplicationData(applicationData);
            }
        }
        this.sortedApplicationGroups = ApplicationGroupData.getSortedGroups(applicationGroups.stream().filter(group -> !group.getSortedApplications().isEmpty()).collect(Collectors.toList()));
    }

    private void createApplicationLauncher() {
        SimpleItemView itemView = new SimpleItemView();
        for (ApplicationGroupData applicationGroup : this.sortedApplicationGroups) {
            SimpleItemGroup itemGroup = new SimpleItemGroup(applicationGroup.getIcon(), applicationGroup.getTitle(), (Template)BaseTemplate.LIST_ITEM_EXTRA_VERY_LARGE_ICON_TWO_LINES);
            itemView.addGroup((ItemGroup)itemGroup);
            itemGroup.setButtonWidth(220.0f);
            for (ApplicationData applicationData : applicationGroup.getSortedApplications()) {
                SimpleItem item = itemGroup.addItem(applicationData.getIcon(), applicationData.getTitle(), applicationData.getDescription());
                item.onClick.addListener(() -> this.openApplication(applicationData));
            }
        }
        if (this.mobileView) {
            SimpleItemGroup itemGroup = new SimpleItemGroup(ApplicationIcons.LOG_OUT, this.getLocalized("org.teamapps.dictionary.logout", new Object[0]), (Template)BaseTemplate.LIST_ITEM_EXTRA_VERY_LARGE_ICON_TWO_LINES);
            itemView.addGroup((ItemGroup)itemGroup);
            itemGroup.setButtonWidth(220.0f);
            SimpleItem item = itemGroup.addItem(ApplicationIcons.LOG_OUT, this.getLocalized("org.teamapps.dictionary.logout", new Object[0]), this.getLocalized("org.teamapps.dictionary.logout", new Object[0]));
            item.onClick.addListener(this::logout);
        }
        this.applicationLauncher = this.createLauncherView((SimpleItemView<ApplicationData>)itemView, this.mobileView);
    }

    public void updateApplicationLauncher() {
        this.initApplicationData();
        this.createApplicationLauncher();
        if (this.applicationLauncherTab != null) {
            this.applicationLauncherTab.setContent(this.applicationLauncher);
        }
    }

    private void logout() {
        User user = this.userSessionData.getUser();
        LOGGER.info("User logout: {}, {} {}", new Object[]{user.getId(), user.getFirstName(), user.getLastName()});
        this.registry.getBootstrapSessionHandler().onUserLogout.fire((Object)this.userSessionData.getContext());
        this.userSessionData.invalidate();
        SessionContext.current().clearExecutionDecorators();
        LoginHandler loginHandler = new LoginHandler(this.registry, this.logoutHandler, this.userSessionData);
        loginHandler.createLoginView(this.userSessionData.getContext(), this.userSessionData.getRootPanel());
    }

    private void createMainView() {
        ThemingConfig themingConfig = this.registry.getSystemConfig().getThemingConfig();
        this.userSessionData.getContext().registerBackgroundImage("defaultBackground", themingConfig.getApplicationBackgroundUrl(), themingConfig.getApplicationSecondaryBackgroundUrl());
        this.userSessionData.getContext().registerBackgroundImage("defaultDarkBackground", themingConfig.getApplicationDarkBackgroundUrl(), themingConfig.getApplicationDarkSecondaryBackgroundUrl());
        this.userSessionData.getContext().setBackgroundImage("defaultBackground", 0);
        if (this.mobileView) {
            this.userSessionData.setRootComponent(this.applicationLauncher);
        } else {
            this.applicationsTabPanel = new TabPanel();
            this.applicationsTabPanel.onTabSelected.addListener(tab -> {
                this.tabByApplicationData.entrySet().stream().filter(entry -> ((Tab)entry.getValue()).equals(tab)).map(Map.Entry::getKey).findAny().ifPresent(applicationData -> this.selectedApplication.set((Object)applicationData.getManagedApplication()));
                if (tab.equals(this.applicationLauncherTab)) {
                    this.handleApplicationLauncherSelection();
                }
            });
            this.applicationLauncherTab = new Tab(ApplicationIcons.HOME, this.getLocalized("org.teamapps.dictionary.applications", new Object[0]), this.applicationLauncher);
            this.applicationsTabPanel.addTab(this.applicationLauncherTab, true);
            Tab logoutTab = new Tab(ApplicationIcons.LOG_OUT, this.getLocalized("org.teamapps.dictionary.logout", new Object[0]), null);
            logoutTab.setLazyLoading(true);
            logoutTab.setRightSide(true);
            this.applicationsTabPanel.addTab(logoutTab, false);
            logoutTab.onSelected.addListener(this::logout);
            this.userSessionData.setRootComponent((Component)this.applicationsTabPanel);
        }
        ApplicationData autoStartApp = this.getAllApplications().stream().filter(applicationData -> applicationData.getManagedApplication().isStartOnLogin()).findFirst().orElse(null);
        if (autoStartApp != null) {
            this.openApplication(autoStartApp);
        }
    }

    private void closeApplication(ManagedApplication managedApplication) {
        Tab tab;
        if (managedApplication == null) {
            return;
        }
        ApplicationData runningApplication = null;
        for (ApplicationData applicationData : this.openedApplications) {
            if (!applicationData.getManagedApplication().equals(managedApplication)) continue;
            runningApplication = applicationData;
        }
        if (runningApplication != null && !this.mobileView && (tab = this.tabByApplicationData.get(runningApplication)) != null) {
            this.applicationsTabPanel.removeTab(tab);
            this.tabByApplicationData.remove(runningApplication);
            this.openedApplications.remove(runningApplication);
            runningApplication.reloadApplicationData(this.userSessionData);
        }
    }

    private void openApplication(ApplicationData applicationData) {
        this.selectedApplication.set((Object)applicationData.getManagedApplication());
        THREAD_LOCAL_APPLICATION.set((ManagedApplication)this.selectedApplication.get());
        ++this.applicationOpenCount;
        LOGGER.info("Open app: " + (this.selectedPerspective.get() != null ? ((ManagedApplicationPerspective)this.selectedPerspective.get()).getApplicationPerspective().getQualifiedName() : null));
        if (this.openedApplications.contains(applicationData)) {
            if (this.mobileView) {
                Component component = this.mobilAppByApplicationData.get(applicationData);
                this.userSessionData.setRootComponent(component);
                applicationData.getApplicationSessionData().getMobileNavigation().onShowStartViewRequest().fire();
            } else {
                Tab tab = this.tabByApplicationData.get(applicationData);
                tab.select();
            }
        } else {
            ApplicationInstance applicationInstance = new ApplicationInstance(this.userSessionData, applicationData, this.applicationLauncher, (MutableValue<ManagedApplicationPerspective>)this.selectedPerspective);
            if (this.mobileView) {
                Component application = applicationInstance.createMobileApplication();
                this.userSessionData.setRootComponent(application);
                this.openedApplications.add(applicationData);
                this.mobilAppByApplicationData.put(applicationData, application);
            } else {
                Component application = applicationInstance.createApplication();
                Tab tab = new Tab(applicationData.getIcon(), applicationData.getTitle(), application);
                tab.setCloseable(true);
                this.openedApplications.add(applicationData);
                this.tabByApplicationData.put(applicationData, tab);
                tab.onClosed.addListener(() -> {
                    this.tabByApplicationData.remove(applicationData);
                    this.openedApplications.remove(applicationData);
                    applicationData.reloadApplicationData(this.userSessionData);
                });
                this.applicationsTabPanel.addTab(tab, true);
            }
        }
    }

    public ApplicationDesktop createApplicationDesktop() {
        return new ApplicationDesktop(){
            private ResponsiveApplication application;
            private Tab tab;
            {
                this.application = ApplicationLauncher.this.createResponsiveApplication();
            }

            public ResponsiveApplication getApplication() {
                return this.application;
            }

            public void showApplication(Icon icon, String title, boolean select, boolean closable) {
                if (ApplicationLauncher.this.mobileView) {
                    ApplicationLauncher.this.userSessionData.setRootComponent(this.application.getUi());
                } else {
                    this.tab = new Tab(icon, title, this.application.getUi());
                    this.tab.setCloseable(closable);
                    ApplicationLauncher.this.applicationsTabPanel.addTab(this.tab, select);
                }
            }

            public void close() {
                if (ApplicationLauncher.this.mobileView) {
                    ApplicationLauncher.this.userSessionData.setRootComponent(ApplicationLauncher.this.applicationLauncher);
                } else {
                    ApplicationLauncher.this.applicationsTabPanel.removeTab(this.tab);
                }
            }
        };
    }

    public ResponsiveApplication createResponsiveApplication() {
        MobileApplicationNavigation mobileNavigation = new MobileApplicationNavigation();
        mobileNavigation.setApplicationLauncher(this.applicationLauncher);
        return ResponsiveApplication.createApplication((ApplicationAssembler)(SessionContext.current().getClientInfo().isMobileDevice() ? new MobileAssembler(mobileNavigation, this.userSessionData.getLocalizationProvider()) : new DesktopApplicationAssembler()));
    }

    private Component createLauncherView(SimpleItemView<ApplicationData> applicationLauncher, boolean mobileView) {
        Panel panel = new Panel(ApplicationIcons.HOME, this.getLocalized("org.teamapps.dictionary.applications", new Object[0]));
        TextField applicationsSearchField = new TextField();
        applicationsSearchField.setShowClearButton(true);
        applicationsSearchField.setEmptyText(this.getLocalized("org.teamapps.dictionary.search___", new Object[0]));
        applicationsSearchField.onTextInput().addListener(arg_0 -> applicationLauncher.setFilter(arg_0));
        panel.setRightHeaderField((AbstractField)applicationsSearchField);
        panel.setContent(applicationLauncher);
        panel.setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.7f));
        if (mobileView) {
            return panel;
        }
        Panel framePanel = new Panel();
        framePanel.setHideTitleBar(true);
        framePanel.setPadding(5);
        framePanel.setContent((Component)panel);
        framePanel.setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.001f));
        return framePanel;
    }

    private List<ApplicationData> getAllApplications() {
        return this.sortedApplicationGroups.stream().flatMap(group -> group.getSortedApplications().stream()).collect(Collectors.toList());
    }

    public String getLocalized(String key, Object ... objects) {
        return this.userSessionData.getLocalizationProvider().getLocalized(key, objects);
    }
}

