/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.privilege;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.PrivilegeGroupType;
import org.teamapps.application.server.system.privilege.MergedPrivilege;
import org.teamapps.application.server.system.privilege.MergedPrivilegeGroup;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.ApplicationPrivilege;
import org.teamapps.model.controlcenter.ApplicationPrivilegeGroup;
import org.teamapps.ux.component.template.BaseTemplateTreeNode;

public class MergedApplicationPrivileges
extends BaseTemplateTreeNode<Object> {
    private final String name;
    private final Icon icon;
    private final String title;
    private final String description;
    private final Map<String, MergedPrivilegeGroup> privilegeGroupByName = new HashMap<String, MergedPrivilegeGroup>();

    public MergedApplicationPrivileges(String name, Icon icon, String title, String description) {
        this.name = name;
        this.icon = icon;
        this.title = title;
        this.description = description;
    }

    public void addPrivilegeGroup(PrivilegeGroup privilegeGroup, ApplicationLocalizationProvider localizationProvider) {
        MergedPrivilegeGroup mergedPrivilegeGroup = this.privilegeGroupByName.computeIfAbsent(privilegeGroup.getName(), s -> new MergedPrivilegeGroup(this, (String)s, privilegeGroup.getType(), privilegeGroup.getIcon(), localizationProvider.getLocalized(privilegeGroup.getTitleKey(), new Object[0]), localizationProvider.getLocalized(privilegeGroup.getDescriptionKey(), new Object[0])));
        if (privilegeGroup.getPrivileges() != null) {
            for (Privilege privilege : privilegeGroup.getPrivileges()) {
                mergedPrivilegeGroup.getPrivilegesByName().computeIfAbsent(privilege.getName(), s -> new MergedPrivilege(mergedPrivilegeGroup, (String)s, privilege.getIcon(), localizationProvider.getLocalized(privilege.getTitleKey(), new Object[0])));
            }
        }
    }

    public void addPrivilegeGroup(ApplicationPrivilegeGroup privilegeGroup, ApplicationLocalizationProvider localizationProvider) {
        PrivilegeGroupType privilegeGroupType = PrivilegeGroupType.valueOf((String)privilegeGroup.getApplicationPrivilegeGroupType().name());
        MergedPrivilegeGroup mergedPrivilegeGroup = this.privilegeGroupByName.computeIfAbsent(privilegeGroup.getName(), s -> new MergedPrivilegeGroup(this, (String)s, privilegeGroupType, IconUtils.decodeIcon((String)privilegeGroup.getIcon()), localizationProvider.getLocalized(privilegeGroup.getTitleKey(), new Object[0]), localizationProvider.getLocalized(privilegeGroup.getDescriptionKey(), new Object[0])));
        if (privilegeGroup.getPrivileges() != null) {
            for (ApplicationPrivilege privilege : privilegeGroup.getPrivileges()) {
                mergedPrivilegeGroup.getPrivilegesByName().computeIfAbsent(privilege.getName(), s -> new MergedPrivilege(mergedPrivilegeGroup, (String)s, IconUtils.decodeIcon((String)privilege.getIcon()), localizationProvider.getLocalized(privilege.getTitleKey(), new Object[0])));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, MergedPrivilegeGroup> getPrivilegeGroupByName() {
        return this.privilegeGroupByName;
    }

    public BaseTemplateTreeNode<Object> getParent() {
        return null;
    }

    public List<BaseTemplateTreeNode<Object>> getTreeRecords() {
        ArrayList<BaseTemplateTreeNode<Object>> nodes = new ArrayList<BaseTemplateTreeNode<Object>>();
        nodes.add(this);
        for (MergedPrivilegeGroup privilegeGroup : this.privilegeGroupByName.values()) {
            nodes.add(privilegeGroup);
            nodes.addAll(privilegeGroup.getPrivilegesByName().values());
        }
        return nodes;
    }

    public String getBadge() {
        return "" + this.privilegeGroupByName.values().stream().mapToInt(value -> Math.max(1, value.getPrivilegesByName().size())).sum();
    }

    public String getCaption() {
        return this.title;
    }
}

