/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.server;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.teamapps.application.server.system.server.ByteArrayResourceProvider;
import org.teamapps.application.server.system.server.LastModifiedProvider;
import org.teamapps.application.server.system.server.SecureLinkBuilder;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.servlet.resourceprovider.ResourceProvider;

public class SecureResourceHandler
implements ResourceProvider {
    public static final String HANDLER_PREFIX = "/TA-SEC-PRVD/";
    private Map<String, SecureLinkBuilder> resourceProviderByHandlerKey = new ConcurrentHashMap<String, SecureLinkBuilder>();
    private static final SecureResourceHandler INSTANCE = new SecureResourceHandler();

    public static SecureResourceHandler getInstance() {
        return INSTANCE;
    }

    private SecureResourceHandler() {
    }

    public SecureLinkBuilder registerByteArrayResourceHandler(ByteArrayResourceProvider resourceProvider, LastModifiedProvider lastModifiedProvider, String fileSuffix) {
        String handlerKey = this.getUUID(12);
        SecureLinkBuilder secureLinkBuilder = new SecureLinkBuilder(HANDLER_PREFIX + handlerKey, fileSuffix, resourceProvider, lastModifiedProvider);
        this.resourceProviderByHandlerKey.put(handlerKey, secureLinkBuilder);
        return secureLinkBuilder;
    }

    public Resource getResource(String servletPath, String relativeResourcePath, String httpSessionId) {
        SecureLinkBuilder secureLinkBuilder;
        String[] parts = relativeResourcePath.split("/");
        if (parts.length > 2 && (secureLinkBuilder = this.resourceProviderByHandlerKey.get(parts[1])) != null) {
            return secureLinkBuilder.getResource(parts[2]);
        }
        return null;
    }

    private String getUUID(int length) {
        String id = UUID.randomUUID().toString().replace("-", "");
        return id.substring(0, Math.min(id.length(), length));
    }
}

