package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface OrganizationUnitTypeViewQuery extends Query<OrganizationUnitTypeView> {

    static OrganizationUnitTypeViewQuery create() {
        return new UdbOrganizationUnitTypeViewQuery();
    }

    OrganizationUnitTypeViewQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    OrganizationUnitTypeViewQuery parseFullTextFilter(String query, String... fieldNames);

	OrganizationUnitTypeViewQuery name(TranslatableTextFilter filter);

	OrganizationUnitTypeViewQuery orName(TranslatableTextFilter filter);

	OrganizationUnitTypeViewQuery abbreviation(TranslatableTextFilter filter);

	OrganizationUnitTypeViewQuery orAbbreviation(TranslatableTextFilter filter);

	OrganizationUnitTypeViewQuery icon(TextFilter filter);

	OrganizationUnitTypeViewQuery orIcon(TextFilter filter);

	OrganizationUnitTypeViewQuery translateOrganizationUnits(BooleanFilter filter);

	OrganizationUnitTypeViewQuery orTranslateOrganizationUnits(BooleanFilter filter);

	OrganizationUnitTypeViewQuery allowUserContainer(BooleanFilter filter);

	OrganizationUnitTypeViewQuery orAllowUserContainer(BooleanFilter filter);

	OrganizationUnitTypeViewQuery filterDefaultChildType(OrganizationUnitTypeViewQuery query);

	OrganizationUnitTypeViewQuery defaultChildType(NumericFilter filter);

	OrganizationUnitTypeViewQuery orDefaultChildType(NumericFilter filter);

	OrganizationUnitTypeViewQuery filterPossibleChildrenTypes(OrganizationUnitTypeViewQuery query);

	OrganizationUnitTypeViewQuery possibleChildrenTypes(MultiReferenceFilterType type, OrganizationUnitTypeView ... value);

	OrganizationUnitTypeViewQuery possibleChildrenTypesCount(MultiReferenceFilterType type, int count);

	OrganizationUnitTypeViewQuery possibleChildrenTypes(MultiReferenceFilter filter);

	OrganizationUnitTypeViewQuery orPossibleChildrenTypes(MultiReferenceFilter filter);

	OrganizationUnitTypeViewQuery geoLocationType(EnumFilterType filterType, GeoLocationType ... enums);

	OrganizationUnitTypeViewQuery orGeoLocationType(EnumFilterType filterType, GeoLocationType ... enums);


    OrganizationUnitTypeViewQuery andOr(OrganizationUnitTypeViewQuery... queries);

    OrganizationUnitTypeViewQuery customFilter(Function<OrganizationUnitTypeView, Boolean> customFilter);

    List<OrganizationUnitTypeView> execute();

    OrganizationUnitTypeView executeExpectSingleton();

    BitSet executeToBitSet();

    List<OrganizationUnitTypeView> execute(String sortFieldName, boolean ascending, String ... path);

    List<OrganizationUnitTypeView> execute(int startIndex, int length, Sorting sorting);

}

