package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface RoleApplicationRoleAssignment extends Entity<RoleApplicationRoleAssignment> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_ROLE = "role";
	final static String FIELD_APPLICATION = "application";
	final static String FIELD_APPLICATION_ROLE_NAME = "applicationRoleName";
	final static String FIELD_ORGANIZATION_FIELD_FILTER = "organizationFieldFilter";
	final static String FIELD_FIXED_ORGANIZATION_ROOT = "fixedOrganizationRoot";
	final static String FIELD_ORGANIZATION_UNIT_TYPE_FILTER = "organizationUnitTypeFilter";

    static RoleApplicationRoleAssignment create() {
        return new UdbRoleApplicationRoleAssignment();
    }

    static RoleApplicationRoleAssignment create(int id) {
        return new UdbRoleApplicationRoleAssignment(id, true);
    }

    static RoleApplicationRoleAssignment getById(int id) {
        return new UdbRoleApplicationRoleAssignment(id, false);
    }

    static EntityBuilder<RoleApplicationRoleAssignment> getBuilder() {
        return new UdbRoleApplicationRoleAssignment(0, false);
    }

    Instant getMetaCreationDate();

    RoleApplicationRoleAssignment setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    RoleApplicationRoleAssignment setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    RoleApplicationRoleAssignment setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    RoleApplicationRoleAssignment setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    RoleApplicationRoleAssignment setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    RoleApplicationRoleAssignment setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    RoleApplicationRoleAssignment setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    RoleApplicationRoleAssignment setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    RoleApplicationRoleAssignment setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    RoleApplicationRoleAssignment setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    RoleApplicationRoleAssignment setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    RoleApplicationRoleAssignment setMetaDeletedBy(int value);

    Role getRole();

    RoleApplicationRoleAssignment setRole(Role value);

    Application getApplication();

    RoleApplicationRoleAssignment setApplication(Application value);

    String getApplicationRoleName();

    RoleApplicationRoleAssignment setApplicationRoleName(String value);

    OrganizationField getOrganizationFieldFilter();

    RoleApplicationRoleAssignment setOrganizationFieldFilter(OrganizationField value);

    OrganizationUnit getFixedOrganizationRoot();

    RoleApplicationRoleAssignment setFixedOrganizationRoot(OrganizationUnit value);

    List<OrganizationUnitType> getOrganizationUnitTypeFilter();

    RoleApplicationRoleAssignment setOrganizationUnitTypeFilter(List<OrganizationUnitType> value);

    int getOrganizationUnitTypeFilterCount();

    RoleApplicationRoleAssignment setOrganizationUnitTypeFilter(OrganizationUnitType ... value);

    BitSet getOrganizationUnitTypeFilterAsBitSet();

    RoleApplicationRoleAssignment addOrganizationUnitTypeFilter(List<OrganizationUnitType> value);

    RoleApplicationRoleAssignment addOrganizationUnitTypeFilter(OrganizationUnitType ... value);

    RoleApplicationRoleAssignment removeOrganizationUnitTypeFilter(List<OrganizationUnitType> value);

    RoleApplicationRoleAssignment removeOrganizationUnitTypeFilter(OrganizationUnitType ... value);

    RoleApplicationRoleAssignment removeAllOrganizationUnitTypeFilter();


    static List<RoleApplicationRoleAssignment> getAll() {
        return UdbRoleApplicationRoleAssignment.getAll();
    }

    static List<RoleApplicationRoleAssignment> sort(List<RoleApplicationRoleAssignment> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbRoleApplicationRoleAssignment.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbRoleApplicationRoleAssignment.getCount();
    }

    static RoleApplicationRoleAssignmentQuery filter() {
        return new UdbRoleApplicationRoleAssignmentQuery();
    }
}

