package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbUserContainerQuery extends AbstractUdbQuery<UserContainer> implements UserContainerQuery {

    public UdbUserContainerQuery() {
        super(UdbUserContainer.table, UserContainer.getBuilder());
    }

	@Override
	public UserContainerQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbUserContainer.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public UserContainerQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbUserContainer.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public UserContainerQuery metaCreationDate(NumericFilter filter) {
		and(UdbUserContainer.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbUserContainer.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery metaCreatedBy(NumericFilter filter) {
		and(UdbUserContainer.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbUserContainer.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery metaModificationDate(NumericFilter filter) {
		and(UdbUserContainer.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbUserContainer.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery metaModifiedBy(NumericFilter filter) {
		and(UdbUserContainer.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbUserContainer.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery metaDeletionDate(NumericFilter filter) {
		and(UdbUserContainer.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbUserContainer.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery metaDeletedBy(NumericFilter filter) {
		and(UdbUserContainer.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbUserContainer.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery filterOrganizationUnit(OrganizationUnitQuery query) {
		UdbOrganizationUnitQuery udbQuery = (UdbOrganizationUnitQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUserContainer.organizationUnit, UdbOrganizationUnit.userContainer);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserContainerQuery organizationUnit(NumericFilter filter) {
		and(UdbUserContainer.organizationUnit.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery orOrganizationUnit(NumericFilter filter) {
		or(UdbUserContainer.organizationUnit.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery filterUsers(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUserContainer.users, UdbUser.container);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserContainerQuery users(MultiReferenceFilterType type, User ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (User value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbUserContainer.users.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery usersCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbUserContainer.users.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery users(MultiReferenceFilter filter) {
		and(UdbUserContainer.users.createFilter(filter));
		return this;
	}

	@Override
	public UserContainerQuery orUsers(MultiReferenceFilter filter) {
		or(UdbUserContainer.users.createFilter(filter));
		return this;
	}


	@Override
	public UdbUserContainerQuery andOr(UserContainerQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public UserContainerQuery customFilter(Function<UserContainer, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(UserContainer.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



