package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface UserContainer extends Entity<UserContainer> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_ORGANIZATION_UNIT = "organizationUnit";
	final static String FIELD_USERS = "users";

    static UserContainer create() {
        return new UdbUserContainer();
    }

    static UserContainer create(int id) {
        return new UdbUserContainer(id, true);
    }

    static UserContainer getById(int id) {
        return new UdbUserContainer(id, false);
    }

    static EntityBuilder<UserContainer> getBuilder() {
        return new UdbUserContainer(0, false);
    }

    Instant getMetaCreationDate();

    UserContainer setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    UserContainer setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    UserContainer setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    UserContainer setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    UserContainer setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    UserContainer setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    UserContainer setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    UserContainer setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    UserContainer setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    UserContainer setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    UserContainer setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    UserContainer setMetaDeletedBy(int value);

    OrganizationUnit getOrganizationUnit();

    UserContainer setOrganizationUnit(OrganizationUnit value);

    List<User> getUsers();

    UserContainer setUsers(List<User> value);

    int getUsersCount();

    UserContainer setUsers(User ... value);

    BitSet getUsersAsBitSet();

    UserContainer addUsers(List<User> value);

    UserContainer addUsers(User ... value);

    UserContainer removeUsers(List<User> value);

    UserContainer removeUsers(User ... value);

    UserContainer removeAllUsers();


    static List<UserContainer> getAll() {
        return UdbUserContainer.getAll();
    }

    static List<UserContainer> sort(List<UserContainer> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbUserContainer.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbUserContainer.getCount();
    }

    static UserContainerQuery filter() {
        return new UdbUserContainerQuery();
    }
}

