package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface UserContainerQuery extends Query<UserContainer> {

    static UserContainerQuery create() {
        return new UdbUserContainerQuery();
    }

    UserContainerQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    UserContainerQuery parseFullTextFilter(String query, String... fieldNames);

	UserContainerQuery metaCreationDate(NumericFilter filter);

	UserContainerQuery orMetaCreationDate(NumericFilter filter);

	UserContainerQuery metaCreatedBy(NumericFilter filter);

	UserContainerQuery orMetaCreatedBy(NumericFilter filter);

	UserContainerQuery metaModificationDate(NumericFilter filter);

	UserContainerQuery orMetaModificationDate(NumericFilter filter);

	UserContainerQuery metaModifiedBy(NumericFilter filter);

	UserContainerQuery orMetaModifiedBy(NumericFilter filter);

	UserContainerQuery metaDeletionDate(NumericFilter filter);

	UserContainerQuery orMetaDeletionDate(NumericFilter filter);

	UserContainerQuery metaDeletedBy(NumericFilter filter);

	UserContainerQuery orMetaDeletedBy(NumericFilter filter);

	UserContainerQuery filterOrganizationUnit(OrganizationUnitQuery query);

	UserContainerQuery organizationUnit(NumericFilter filter);

	UserContainerQuery orOrganizationUnit(NumericFilter filter);

	UserContainerQuery filterUsers(UserQuery query);

	UserContainerQuery users(MultiReferenceFilterType type, User ... value);

	UserContainerQuery usersCount(MultiReferenceFilterType type, int count);

	UserContainerQuery users(MultiReferenceFilter filter);

	UserContainerQuery orUsers(MultiReferenceFilter filter);


    UserContainerQuery andOr(UserContainerQuery... queries);

    UserContainerQuery customFilter(Function<UserContainer, Boolean> customFilter);

    List<UserContainer> execute();

    UserContainer executeExpectSingleton();

    BitSet executeToBitSet();

    List<UserContainer> execute(String sortFieldName, boolean ascending, String ... path);

    List<UserContainer> execute(int startIndex, int length, Sorting sorting);

}

