/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.applications;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.ui.localize.LocalizationUiUtils;
import org.teamapps.application.tools.EntityListModelBuilder;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.form.FormPanel;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationGroup;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Fields;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.linkbutton.LinkButton;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class ApplicationGroupsPerspective
extends AbstractManagedApplicationPerspective {
    private final PerspectiveSessionData perspectiveSessionData;
    private final UserSessionData userSessionData;
    private final TwoWayBindableValue<ManagedApplicationGroup> selectedGroup = TwoWayBindableValue.create();

    public ApplicationGroupsPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.createUi();
    }

    private void createUi() {
        View groupsView = View.createView((String)"center", (Icon)ApplicationIcons.WINDOWS, (String)this.getLocalized("applicationGroups.title"), null);
        View applicationDetailsView = View.createView((String)"right", (Icon)ApplicationIcons.WINDOWS, (String)this.getLocalized("applicationGroups.title"), null);
        applicationDetailsView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        ToolbarButtonGroup buttonGroup = applicationDetailsView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton addGroupButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ADD, (String)this.getLocalized("applicationGroups.addGroup"), (String)this.getLocalized("applicationGroups.addGroup.desc")));
        buttonGroup = applicationDetailsView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton groupMoveUpButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.NAVIGATE_UP, (String)this.getLocalized("applicationGroups.moveUp"), (String)this.getLocalized("applicationGroups.moveUp.desc")));
        ToolbarButton groupMoveDownButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.NAVIGATE_DOWN, (String)this.getLocalized("applicationGroups.moveDown"), (String)this.getLocalized("applicationGroups.moveDown.desc")));
        buttonGroup = applicationDetailsView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton saveGroupButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.FLOPPY_DISK, (String)this.getLocalized("org.teamapps.dictionary.saveChanges")));
        EntityListModelBuilder groupModelBuilder = new EntityListModelBuilder(this.getApplicationInstanceData(), group -> this.getLocalized(group.getTitleKey()));
        groupModelBuilder.setRecords(ManagedApplicationGroup.getAll().stream().sorted(Comparator.comparingInt(ManagedApplicationGroup::getListingPosition)).collect(Collectors.toList()));
        Table groupTable = groupModelBuilder.createTemplateFieldTableList((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationGroupPropertyProvider(this.userSessionData), 40);
        groupTable.setStripedRows(false);
        groupsView.setComponent((Component)groupTable);
        groupModelBuilder.onDataChanged.fire();
        groupModelBuilder.attachSearchField(groupsView);
        groupModelBuilder.attachViewCountHandler(groupsView, () -> this.getLocalized("applicationGroups.title"));
        groupModelBuilder.onSelectedRecordChanged.addListener(arg_0 -> this.selectedGroup.set(arg_0));
        this.getPerspective().addView(groupsView);
        this.getPerspective().addView(applicationDetailsView);
        ResponsiveForm groupForm = new ResponsiveForm(100, 150, 0);
        ResponsiveFormLayout formLayout = groupForm.addResponsiveFormLayout(400);
        ComboBox iconComboBox = ApplicationIcons.createIconComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_SINGLE_LINE, (boolean)true);
        ComboBox<String> titleKeyCombo = LocalizationUiUtils.createLocalizationKeyCombo((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, (ApplicationLocalizationProvider)this.getApplicationInstanceData());
        LinkButton crateTitleKeyButton = new LinkButton(this.getLocalized("applications.createNewTitle"));
        EntityListModelBuilder applicationModelBuilder = new EntityListModelBuilder(this.getApplicationInstanceData());
        Table applicationTable = applicationModelBuilder.createTemplateFieldTableList((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPropertyProvider(this.userSessionData), 26);
        FormPanel formPanel = new FormPanel(this.getApplicationInstanceData());
        formPanel.setTable(applicationTable, true, false, false);
        ToolbarButton moveUpButton = formPanel.addButton(ApplicationIcons.NAVIGATE_UP, this.getLocalized("applications.moveUp"));
        ToolbarButton moveDownButton = formPanel.addButton(ApplicationIcons.NAVIGATE_DOWN, this.getLocalized("applications.moveDown"));
        formLayout.addSection().setDrawHeaderLine(false).setCollapsible(false);
        formLayout.addLabelAndComponent(null, this.getLocalized("applicationGroups.groupIcon"), (Component)iconComboBox);
        formLayout.addLabelAndComponent(null, this.getLocalized("applicationGroups.groupTitle"), titleKeyCombo);
        formLayout.addLabelAndComponent(null, null, (Component)crateTitleKeyButton);
        formLayout.addLabelAndComponent(null, this.getLocalized("org.teamapps.dictionary.applications"), (Component)formPanel.getPanel());
        Arrays.asList(iconComboBox, titleKeyCombo).forEach(f -> f.setRequired(true));
        applicationDetailsView.setComponent((Component)groupForm);
        addGroupButton.onClick.addListener(() -> this.selectedGroup.set((Object)ManagedApplicationGroup.create()));
        moveUpButton.onClick.addListener(() -> this.changeApplicationOrder((EntityListModelBuilder<ManagedApplication>)applicationModelBuilder, (Table<ManagedApplication>)applicationTable, true));
        moveDownButton.onClick.addListener(() -> this.changeApplicationOrder((EntityListModelBuilder<ManagedApplication>)applicationModelBuilder, (Table<ManagedApplication>)applicationTable, false));
        groupMoveUpButton.onClick.addListener(() -> this.changeGroupOrder((EntityListModelBuilder<ManagedApplicationGroup>)groupModelBuilder, (ManagedApplicationGroup)this.selectedGroup.get(), true));
        groupMoveDownButton.onClick.addListener(() -> this.changeGroupOrder((EntityListModelBuilder<ManagedApplicationGroup>)groupModelBuilder, (ManagedApplicationGroup)this.selectedGroup.get(), false));
        this.selectedGroup.onChanged().addListener(group -> {
            iconComboBox.setValue((Object)IconUtils.decodeIcon((String)group.getIcon()));
            titleKeyCombo.setValue((Object)group.getTitleKey());
            applicationModelBuilder.setRecords(group.getApplications());
        });
        saveGroupButton.onClick.addListener(() -> {
            ManagedApplicationGroup group = (ManagedApplicationGroup)this.selectedGroup.get();
            if (group == null) {
                return;
            }
            if (Fields.validateAll((AbstractField[])new AbstractField[]{iconComboBox, titleKeyCombo})) {
                group.setIcon(IconUtils.encodeNoStyle((Icon)((Icon)iconComboBox.getValue())));
                group.setTitleKey((String)titleKeyCombo.getValue());
                group.save();
                int pos = 0;
                for (ManagedApplication application : applicationModelBuilder.getRecords()) {
                    application.setListingPosition(pos++).save();
                }
                groupModelBuilder.setRecords(ManagedApplicationGroup.getAll().stream().sorted(Comparator.comparingInt(ManagedApplicationGroup::getListingPosition)).collect(Collectors.toList()));
                UiUtils.showSaveNotification((boolean)true, (ApplicationInstanceData)this.getApplicationInstanceData());
            } else {
                UiUtils.showSaveNotification((boolean)false, (ApplicationInstanceData)this.getApplicationInstanceData());
            }
        });
        this.selectedGroup.set((Object)ManagedApplicationGroup.create());
    }

    private void changeApplicationOrder(EntityListModelBuilder<ManagedApplication> applicationModelBuilder, Table<ManagedApplication> applicationTable, boolean moveUp) {
        ManagedApplication selectedPerspective = (ManagedApplication)applicationTable.getSelectedRecord();
        if (selectedPerspective != null) {
            List applications = applicationModelBuilder.getRecords();
            int position = 0;
            int changeValue = moveUp ? -5 : 15;
            for (ManagedApplication application : applications) {
                if (application.equals(selectedPerspective)) {
                    application.setListingPosition(position + changeValue);
                    continue;
                }
                application.setListingPosition(position += 10);
            }
            applicationModelBuilder.setRecords(applications.stream().sorted(Comparator.comparingInt(ManagedApplication::getListingPosition)).collect(Collectors.toList()));
        }
    }

    private void changeGroupOrder(EntityListModelBuilder<ManagedApplicationGroup> groupModelBuilder, ManagedApplicationGroup group, boolean moveUp) {
        if (group != null) {
            List groups = groupModelBuilder.getRecords();
            int position = 0;
            int changeValue = moveUp ? -5 : 15;
            for (ManagedApplicationGroup application : groups) {
                if (application.equals(group)) {
                    application.setListingPosition(position + changeValue);
                    continue;
                }
                application.setListingPosition(position += 10);
            }
            groupModelBuilder.setRecords(groups.stream().sorted(Comparator.comparingInt(ManagedApplicationGroup::getListingPosition)).collect(Collectors.toList()));
            int pos = 0;
            for (ManagedApplicationGroup g : groupModelBuilder.getRecords()) {
                g.setListingPosition(pos++).save();
            }
        }
    }
}

