/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap.installer;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.teamapps.application.api.application.AbstractApplicationBuilder;
import org.teamapps.application.api.application.AbstractBaseApplicationBuilder;
import org.teamapps.application.api.application.ApplicationBuilder;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.server.system.bootstrap.ApplicationInfo;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationInstallationPhase;
import org.teamapps.universaldb.index.file.FileUtil;

public class ApplicationJarInstallationPhase
implements ApplicationInstallationPhase {
    @Override
    public void checkApplication(ApplicationInfo applicationInfo) {
        try {
            if (applicationInfo.getApplicationJar() == null) {
                return;
            }
            boolean unmanagedApplication = false;
            ApplicationBuilder baseApplicationBuilder = null;
            String fileHash = FileUtil.createFileHash((File)applicationInfo.getApplicationJar());
            URLClassLoader classLoader = new URLClassLoader(new URL[]{applicationInfo.getApplicationJar().toURI().toURL()});
            ScanResult scanResult = new ClassGraph().overrideClassLoaders(new ClassLoader[]{classLoader}).enableAllInfo().scan();
            ClassInfoList classes = scanResult.getClassesImplementing(ApplicationBuilder.class.getName()).getStandardClasses();
            if (classes.isEmpty()) {
                classes = scanResult.getSubclasses(AbstractApplicationBuilder.class.getName()).getStandardClasses();
            }
            if (classes.isEmpty()) {
                classes = scanResult.getClassesImplementing(AbstractApplicationBuilder.class.getName()).getStandardClasses();
                unmanagedApplication = true;
            }
            if (classes.isEmpty()) {
                classes = scanResult.getSubclasses(AbstractBaseApplicationBuilder.class.getName()).getStandardClasses();
                unmanagedApplication = true;
            }
            if (classes.isEmpty()) {
                applicationInfo.addError("Could not find application in jar file");
                return;
            }
            if (classes.size() > 1) {
                applicationInfo.addError("Too many application classes in jar file");
                return;
            }
            Class builder = ((ClassInfo)classes.get(0)).loadClass();
            scanResult.close();
            baseApplicationBuilder = unmanagedApplication ? (ApplicationBuilder)builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : (ApplicationBuilder)builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            applicationInfo.setBaseApplicationBuilder((BaseApplicationBuilder)baseApplicationBuilder);
            applicationInfo.setUnmanagedPerspectives(unmanagedApplication);
            applicationInfo.setBinaryHash(fileHash);
            applicationInfo.setApplicationClassLoader(classLoader);
        }
        catch (Exception e) {
            e.printStackTrace();
            applicationInfo.addError("Error checking jar file:" + e.getMessage());
        }
    }

    @Override
    public void installApplication(ApplicationInfo applicationInfo) {
    }

    @Override
    public void loadApplication(ApplicationInfo applicationInfo) {
    }
}

