/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.launcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.server.system.launcher.ApplicationData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.ManagedApplicationGroup;

public class ApplicationGroupData {
    private final Icon icon;
    private final String title;
    private final int groupPosition;
    private final List<ApplicationData> applications = new ArrayList<ApplicationData>();

    public ApplicationGroupData(ManagedApplicationGroup applicationGroup, UserSessionData userSessionData) {
        this.icon = applicationGroup.getIcon() != null ? IconUtils.decodeIcon((String)applicationGroup.getIcon()) : null;
        this.title = userSessionData.getDictionary().getLocalized(applicationGroup.getTitleKey(), new Object[0]);
        this.groupPosition = applicationGroup.getListingPosition();
    }

    public ApplicationGroupData(Icon icon, String title, int groupPosition) {
        this.icon = icon;
        this.title = title;
        this.groupPosition = groupPosition;
    }

    public void addApplicationData(ApplicationData applicationData) {
        this.applications.add(applicationData);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getGroupPosition() {
        return this.groupPosition;
    }

    public List<ApplicationData> getSortedApplications() {
        return this.applications.stream().sorted(Comparator.comparing(ApplicationData::getApplicationPosition)).collect(Collectors.toList());
    }

    public static List<ApplicationGroupData> getSortedGroups(Collection<ApplicationGroupData> groups) {
        return groups.stream().sorted(Comparator.comparing(ApplicationGroupData::getGroupPosition)).collect(Collectors.toList());
    }
}

