/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.localization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.teamapps.application.api.localization.LocalizationData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.machinetranslation.TranslationService;
import org.teamapps.application.server.system.utils.KeyCompare;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationKeyType;
import org.teamapps.model.controlcenter.LocalizationTopic;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.model.controlcenter.MachineTranslationState;
import org.teamapps.model.controlcenter.TranslationState;
import org.teamapps.model.controlcenter.TranslationVerificationState;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.text.TextFilter;

public class LocalizationUtil {
    private static List<String> allowedSourceTranslationLanguages = Arrays.asList("en", "de", "fr", "es", "pt", "nl", "it", "pl", "ru");

    public static void synchronizeLocalizationData(LocalizationData localizationData, Application application, LocalizationKeyType localizationKeyType, List<String> requiredLanguages) {
        Map localizationMapByKey = localizationData.createLocalizationMapByKey();
        int appIdFilter = 0;
        if (application != null) {
            appIdFilter = application.getId();
        }
        List<LocalizationKey> localizationKeys = LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)appIdFilter)).execute();
        KeyCompare<String, LocalizationKey> keyCompare = new KeyCompare<String, LocalizationKey>(localizationMapByKey.keySet(), localizationKeys, s -> s, LocalizationKey::getKey);
        List<String> newKeys = keyCompare.getNotInB();
        LocalizationTopic topic = LocalizationUtil.getTopic(localizationKeyType, application);
        for (String key2 : newKeys) {
            LocalizationKey localizationKey = (LocalizationKey)LocalizationKey.create().setApplication(application).setLocalizationKeyType(localizationKeyType).setTopics(topic).setUsed(true).setKey(key2).save();
            Map map = (Map)localizationMapByKey.get(key2);
            for (Map.Entry entry : map.entrySet()) {
                String language2 = (String)entry.getKey();
                String original = (String)entry.getValue();
                LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage(language2).setOriginal(original).setCurrentDisplayValue(original).setMachineTranslationState(MachineTranslationState.NOT_NECESSARY).setTranslationState(TranslationState.NOT_NECESSARY).setTranslationVerificationState(TranslationVerificationState.NOT_NECESSARY).save();
            }
        }
        List<LocalizationKey> removedKeys = keyCompare.getNotInA();
        removedKeys.forEach(key -> key.setUsed(false).save());
        List<String> existingKeys = keyCompare.getInB();
        for (String string : existingKeys) {
            Map translations = (Map)localizationMapByKey.get(string);
            LocalizationKey localizationKey = keyCompare.getB(string);
            KeyCompare<String, LocalizationValue> languageCompare = new KeyCompare<String, LocalizationValue>(translations.keySet(), localizationKey.getLocalizationValues(), s -> s, LocalizationValue::getLanguage);
            if (languageCompare.isDifferent()) {
                List<String> newLanguages = languageCompare.getNotInB();
                newLanguages.forEach(language -> {
                    String original = (String)translations.get(language);
                    LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage((String)language).setOriginal(original).setCurrentDisplayValue(original).setMachineTranslationState(MachineTranslationState.NOT_NECESSARY).setTranslationState(TranslationState.NOT_NECESSARY).setTranslationVerificationState(TranslationVerificationState.NOT_NECESSARY).save();
                });
                List<LocalizationValue> removedLanguages = languageCompare.getNotInA();
                for (LocalizationValue value2 : removedLanguages) {
                    value2.setOriginal(null);
                    if (value2.getAdminKeyOverride() == null && value2.getAdminLocalOverride() == null && value2.getMachineTranslation() == null && value2.getTranslation() == null) {
                        value2.setMachineTranslationState(MachineTranslationState.TRANSLATION_REQUESTED).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setTranslationVerificationState(TranslationVerificationState.NOT_YET_TRANSLATED);
                    }
                    value2.save();
                }
            }
            for (LocalizationValue localizationValue : languageCompare.getInA()) {
                String original = (String)translations.get(localizationValue.getLanguage());
                if (original == null || original.isBlank() || original.equals(localizationValue.getOriginal())) continue;
                localizationValue.setOriginal(original).save();
                localizationValue.getLocalizationKey().getLocalizationValues().stream().filter(value -> !value.equals(localizationValue)).filter(value -> value.getOriginal() == null).filter(value -> value.getAdminLocalOverride() == null).filter(value -> value.getAdminKeyOverride() == null).forEach(value -> value.setMachineTranslationState(MachineTranslationState.TRANSLATION_REQUESTED).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setTranslationVerificationState(TranslationVerificationState.NOT_YET_TRANSLATED).save());
            }
        }
        localizationKeys = LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)appIdFilter)).execute();
        for (LocalizationKey localizationKey : localizationKeys) {
            Map<String, LocalizationValue> valueByLanguage = localizationKey.getLocalizationValues().stream().collect(Collectors.toMap(LocalizationValue::getLanguage, v -> v));
            for (String language2 : requiredLanguages) {
                if (valueByLanguage.containsKey(language2)) continue;
                LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage(language2).setMachineTranslationState(MachineTranslationState.TRANSLATION_REQUESTED).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setTranslationVerificationState(TranslationVerificationState.NOT_YET_TRANSLATED).save();
            }
        }
    }

    public static void translateAllApplicationValues(TranslationService translationService, Application application) {
        if (translationService == null) {
            return;
        }
        List<LocalizationValue> translationRequests = LocalizationValue.filter().machineTranslationState(EnumFilterType.EQUALS, MachineTranslationState.TRANSLATION_REQUESTED).execute().stream().filter(value -> value.getLocalizationKey().getApplication().equals(application)).collect(Collectors.toList());
        ExecutorService executor = Executors.newFixedThreadPool(10);
        translationRequests.forEach(localizationValue -> executor.submit(() -> LocalizationUtil.translateLocalizationValue(localizationValue, translationService)));
        executor.shutdown();
    }

    public static void translateAllDictionaryValues(TranslationService translationService) {
        if (translationService == null) {
            return;
        }
        List<LocalizationValue> translationRequests = LocalizationValue.filter().machineTranslationState(EnumFilterType.EQUALS, MachineTranslationState.TRANSLATION_REQUESTED).execute().stream().filter(value -> value.getLocalizationKey().getLocalizationKeyType() == LocalizationKeyType.DICTIONARY_KEY).collect(Collectors.toList());
        ExecutorService executor = Executors.newFixedThreadPool(10);
        translationRequests.forEach(localizationValue -> executor.submit(() -> LocalizationUtil.translateLocalizationValue(localizationValue, translationService)));
        executor.shutdown();
    }

    public static void translateAllValues(TranslationService translationService) {
        if (translationService == null) {
            return;
        }
        List<LocalizationValue> translationRequests = LocalizationValue.filter().machineTranslationState(EnumFilterType.EQUALS, MachineTranslationState.TRANSLATION_REQUESTED).execute();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        translationRequests.forEach(localizationValue -> executor.submit(() -> LocalizationUtil.translateLocalizationValue(localizationValue, translationService)));
        executor.shutdown();
    }

    public static void translateLocalizationValue(LocalizationValue localizationValue, TranslationService translationService) {
        String translation;
        LocalizationValue adminValue = localizationValue.getLocalizationKey().getLocalizationValues().stream().filter(value -> value.getAdminKeyOverride() != null).filter(value -> allowedSourceTranslationLanguages.contains(value.getLanguage())).findFirst().orElse(null);
        if (adminValue != null && translationService.canTranslate(adminValue.getLanguage(), localizationValue.getLanguage()) && (translation = translationService.translate(adminValue.getAdminKeyOverride(), adminValue.getLanguage(), localizationValue.getLanguage())) != null) {
            translation = LocalizationUtil.firstUpperIfSourceUpper(adminValue.getAdminKeyOverride(), translation);
            localizationValue.setTranslation(translation).setMachineTranslationState(MachineTranslationState.OK).setCurrentDisplayValue(LocalizationUtil.getDisplayValue(localizationValue)).save();
            return;
        }
        Map<String, LocalizationValue> localizationValueByLanguage = localizationValue.getLocalizationKey().getLocalizationValues().stream().filter(value -> !value.equals(localizationValue)).filter(value -> value.getOriginal() != null).collect(Collectors.toMap(LocalizationValue::getLanguage, v -> v));
        for (String language : allowedSourceTranslationLanguages) {
            String translationSourceText;
            String translation2;
            LocalizationValue value2 = localizationValueByLanguage.get(language);
            if (value2 == null || !translationService.canTranslate(language, localizationValue.getLanguage()) || (translation2 = translationService.translate(translationSourceText = LocalizationUtil.getTranslationSourceText(localizationValue), language, localizationValue.getLanguage())) == null) continue;
            translation2 = LocalizationUtil.firstUpperIfSourceUpper(translationSourceText, translation2);
            localizationValue.setTranslation(translation2).setMachineTranslationState(MachineTranslationState.OK).setCurrentDisplayValue(LocalizationUtil.getDisplayValue(localizationValue)).save();
            return;
        }
    }

    private static String getTranslationSourceText(LocalizationValue localizationValue) {
        String value = localizationValue.getAdminKeyOverride();
        if (value == null) {
            value = localizationValue.getAdminLocalOverride();
        }
        if (value == null) {
            value = localizationValue.getOriginal();
        }
        return value;
    }

    private static String getDisplayValue(LocalizationValue localizationValue) {
        String value = localizationValue.getAdminKeyOverride();
        if (value == null) {
            value = localizationValue.getAdminLocalOverride();
        }
        if (value == null) {
            value = localizationValue.getOriginal();
        }
        if (value == null) {
            value = localizationValue.getTranslation();
        }
        if (value == null) {
            value = localizationValue.getMachineTranslation();
        }
        return value;
    }

    private static String firstUpperIfSourceUpper(String source, String text) {
        if (source == null || text == null || source.isEmpty() || text.isEmpty()) {
            return text;
        }
        char c = source.substring(0, 1).charAt(0);
        if (Character.isUpperCase(c)) {
            return text.substring(0, 1).toUpperCase() + text.substring(1);
        }
        return text;
    }

    private static LocalizationTopic getTopic(LocalizationKeyType keyType, Application application) {
        return switch (keyType) {
            case LocalizationKeyType.APPLICATION_RESOURCE_KEY -> LocalizationUtil.getOrCreateTopic(application.getName(), application.getIcon(), application);
            case LocalizationKeyType.DICTIONARY_KEY -> LocalizationUtil.getOrCreateTopic("Dictionary", IconUtils.encodeNoStyle((Icon)ApplicationIcons.DICTIONARY), application);
            case LocalizationKeyType.SYSTEM_KEY -> LocalizationUtil.getOrCreateTopic("System", IconUtils.encodeNoStyle((Icon)ApplicationIcons.SYSTEM), application);
            case LocalizationKeyType.REPORTING_KEY -> LocalizationUtil.getOrCreateTopic("Reporting", IconUtils.encodeNoStyle((Icon)ApplicationIcons.FORM), application);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static LocalizationTopic getOrCreateTopic(String name, String icon, Application application) {
        LocalizationTopic topic = LocalizationTopic.filter().title(TextFilter.textEqualsFilter((String)name)).executeExpectSingleton();
        if (topic == null) {
            topic = (LocalizationTopic)LocalizationTopic.create().setTitle(name).setApplication(application).setIcon(icon).save();
        }
        return topic;
    }
}

