/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserContainer;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;

public class UdbUserContainer
extends AbstractUdbEntity<UserContainer>
implements UserContainer {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static SingleReferenceIndex organizationUnit;
    protected static MultiReferenceIndex users;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        organizationUnit = (SingleReferenceIndex)tableIndex.getColumnIndex("organizationUnit");
        users = (MultiReferenceIndex)tableIndex.getColumnIndex("users");
    }

    public static List<UserContainer> getAll() {
        return new EntityBitSetList(UserContainer.getBuilder(), table.getRecordBitSet());
    }

    public static List<UserContainer> sort(List<UserContainer> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbUserContainer.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static List<UserContainer> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return UdbUserContainer.sort((TableIndex)table, UserContainer.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUserContainer() {
        super(table);
    }

    public UdbUserContainer(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public UserContainer build() {
        return new UdbUserContainer();
    }

    public UserContainer build(int id) {
        return new UdbUserContainer(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public UserContainer setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public UserContainer setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public UserContainer setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public UserContainer setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public UserContainer setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public UserContainer setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public UserContainer setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public UserContainer setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public UserContainer setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public UserContainer setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public UserContainer setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public UserContainer setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public OrganizationUnit getOrganizationUnit() {
        if (this.isChanged((ColumnIndex)organizationUnit)) {
            return (OrganizationUnit)this.getReferenceChangeValue((ColumnIndex)organizationUnit);
        }
        int id = organizationUnit.getValue(this.getId());
        if (id > 0) {
            return OrganizationUnit.getById(id);
        }
        return null;
    }

    @Override
    public UserContainer setOrganizationUnit(OrganizationUnit value) {
        this.setSingleReferenceValue((ColumnIndex)organizationUnit, value, table);
        return this;
    }

    @Override
    public List<User> getUsers() {
        return this.getMultiReferenceValue(users, User.getBuilder());
    }

    @Override
    public UserContainer setUsers(List<User> value) {
        this.setMultiReferenceValue(value, users);
        return this;
    }

    @Override
    public int getUsersCount() {
        return this.getMultiReferenceValueCount(users, User.getBuilder());
    }

    @Override
    public UserContainer setUsers(User ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), users);
        return this;
    }

    @Override
    public BitSet getUsersAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(users, User.getBuilder());
    }

    @Override
    public UserContainer addUsers(List<User> value) {
        this.addMultiReferenceValue(value, users);
        return this;
    }

    @Override
    public UserContainer addUsers(User ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), users);
        return this;
    }

    @Override
    public UserContainer removeUsers(List<User> value) {
        this.removeMultiReferenceValue(value, users);
        return this;
    }

    @Override
    public UserContainer removeUsers(User ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), users);
        return this;
    }

    @Override
    public UserContainer removeAllUsers() {
        this.removeAllMultiReferenceValue(users);
        return this;
    }

    public UdbUserContainer save(Transaction transaction, boolean strictChangeVerification) {
        this.save(transaction, table, strictChangeVerification);
        return this;
    }

    public UdbUserContainer saveTransactional(boolean strictChangeVerification) {
        this.save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    public UdbUserContainer save() {
        this.save(table);
        return this;
    }

    public void delete(Transaction transaction) {
        this.delete(transaction, table);
    }

    public void delete() {
        this.delete(table);
    }
}

