/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.roles;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.application.ux.localize.TranslatableField;
import org.teamapps.application.ux.localize.TranslatableTextUtils;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.model.controlcenter.Role;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class RolesPerspective
extends AbstractManagedApplicationPerspective {
    private final TwoWayBindableValue<Role> selectedRole = TwoWayBindableValue.create();

    public RolesPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        View masterView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.WORKER, (String)this.getLocalized("roles.roles"), null));
        View detailView = this.getPerspective().addView(View.createView((String)"right", (Icon)ApplicationIcons.WORKER, (String)this.getLocalized("roles.role"), null));
        detailView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        EntityModelBuilder roleModelBuilder = new EntityModelBuilder(() -> this.isAppFilter() ? Role.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())) : Role.filter(), this.getApplicationInstanceData());
        roleModelBuilder.attachViewCountHandler(masterView, () -> this.getLocalized("roles.roles"));
        roleModelBuilder.attachSearchField(masterView);
        roleModelBuilder.onSelectedRecordChanged.addListener(arg_0 -> this.selectedRole.set(arg_0));
        Table table = roleModelBuilder.createTable();
        table.setDisplayAsList(true);
        table.setRowHeight(28);
        table.setStripedRows(false);
        roleModelBuilder.updateModels();
        TemplateField roleTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData()));
        TemplateField organizationFieldTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createOrganizationFieldPropertyProvider(this.getApplicationInstanceData()));
        TagComboBox allowedOrganizationUnitTypesTableField = UiUtils.createTagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData()));
        CheckBox noDirectMembershipsTableField = new CheckBox(this.getLocalized("roles.noDirectMemberships"));
        table.addColumn(new TableColumn("title", this.getLocalized("org.teamapps.dictionary.name"), (AbstractField)roleTableField).setDefaultWidth(200));
        if (!this.isAppFilter()) {
            table.addColumn(new TableColumn("organizationField", this.getLocalized("organizationField.organizationField"), (AbstractField)organizationFieldTableField).setDefaultWidth(130));
        }
        table.addColumn(new TableColumn("allowedOrganizationUnitTypes", this.getLocalized("roles.allowedOrganizationUnitTypes"), (AbstractField)allowedOrganizationUnitTypesTableField).setDefaultWidth(350));
        table.addColumn(new TableColumn("noDirectMemberships", this.getLocalized("roles.noMemberships"), (AbstractField)noDirectMembershipsTableField).setDefaultWidth(200));
        table.setPropertyExtractor((role, propertyName) -> switch (propertyName) {
            case "title" -> role;
            case "organizationField" -> role.getOrganizationField();
            case "allowedOrganizationUnitTypes" -> role.getAllowedOrganizationUnitTypes();
            case "noDirectMemberships" -> role.getNoDirectMemberships();
            default -> null;
        });
        masterView.setComponent((Component)table);
        ToolbarButtonGroup buttonGroup = detailView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton addButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ADD, (String)this.getLocalized("org.teamapps.dictionary.add"), (String)this.getLocalized("org.teamapps.dictionary.addRecord")));
        buttonGroup = detailView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton saveButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.FLOPPY_DISK, (String)this.getLocalized("org.teamapps.dictionary.saveChanges")));
        TranslatableField titleField = TranslatableTextUtils.createTranslatableField((ApplicationInstanceData)this.getApplicationInstanceData());
        ComboBox iconComboBox = ApplicationIcons.createIconComboBox();
        ComboBox parentRoleComboBox = ComboBoxUtils.createRecordComboBox(() -> this.isAppFilter() ? Role.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())).execute() : Role.getAll(), PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData()), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        TagComboBox<OrganizationUnitType> allowedOrganizationUnitTypesTagCombo = this.createOrgUnitTypeTagComboBox();
        ComboBox organizationFieldComboBox = ComboBoxUtils.createRecordComboBox(() -> this.isAppFilter() ? Collections.singletonList(this.getOrganizationField()) : OrganizationField.getAll(), PropertyProviders.createOrganizationFieldPropertyProvider(this.getApplicationInstanceData()), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        TagComboBox<Role> generalizationRolesTagCombo = this.createRoleTagComboBox();
        TagComboBox<Role> specializationRolesTagCombo = this.createRoleTagComboBox();
        TagComboBox<Role> privilegesReceivingRolesTagCombo = this.createRoleTagComboBox();
        TagComboBox<Role> privilegesSendingRolesTagCombo = this.createRoleTagComboBox();
        CheckBox noDirectMembershipsCheckBox = new CheckBox(this.getLocalized("roles.noDirectMemberships"));
        ResponsiveForm form = new ResponsiveForm(120, 120, 0);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("roles.role"), (AbstractField)titleField);
        formLayout.addLabelAndField(null, this.getLocalized("roles.icon"), (AbstractField)iconComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("roles.parentRole"), (AbstractField)parentRoleComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("roles.allowedOrganizationUnitTypes"), allowedOrganizationUnitTypesTagCombo);
        if (!this.isOrgFieldFilterApplied()) {
            formLayout.addLabelAndField(null, this.getLocalized("roles.organizationField"), (AbstractField)organizationFieldComboBox);
        }
        formLayout.addLabelAndField(null, this.getLocalized("roles.generalizationRoles"), generalizationRolesTagCombo);
        formLayout.addLabelAndField(null, this.getLocalized("roles.specializationRoles"), specializationRolesTagCombo);
        formLayout.addLabelAndField(null, this.getLocalized("roles.privilegesReceivingRoles"), privilegesReceivingRolesTagCombo);
        formLayout.addLabelAndField(null, this.getLocalized("roles.privilegesSendingRoles"), privilegesSendingRolesTagCombo);
        formLayout.addLabelAndField(null, this.getLocalized("roles.noMemberships"), (AbstractField)noDirectMembershipsCheckBox);
        detailView.setComponent((Component)form);
        addButton.onClick.addListener(() -> this.selectedRole.set((Object)Role.create()));
        saveButton.onClick.addListener(() -> {
            Role role = (Role)this.selectedRole.get();
            if (role != null && titleField.getValue() != null && iconComboBox.getValue() != null) {
                OrganizationField organizationField = this.isOrgFieldFilterApplied() ? this.getOrganizationField() : (OrganizationField)organizationFieldComboBox.getValue();
                role.setTitle(titleField.getValue()).setIcon(IconUtils.encodeNoStyle((Icon)((Icon)iconComboBox.getValue()))).setParent((Role)parentRoleComboBox.getValue()).setAllowedOrganizationUnitTypes((List)allowedOrganizationUnitTypesTagCombo.getValue()).setOrganizationField(organizationField).setGeneralizationRoles((List)generalizationRolesTagCombo.getValue()).setSpecializationRoles((List)specializationRolesTagCombo.getValue()).setPrivilegesReceivingRoles((List)privilegesReceivingRolesTagCombo.getValue()).setPrivilegesSendingRoles((List)privilegesSendingRolesTagCombo.getValue()).setNoDirectMemberships((Boolean)noDirectMembershipsCheckBox.getValue()).save();
                UiUtils.showSaveNotification((boolean)true, (ApplicationInstanceData)this.getApplicationInstanceData());
                roleModelBuilder.updateModels();
            } else {
                UiUtils.showSaveNotification((boolean)false, (ApplicationInstanceData)this.getApplicationInstanceData());
            }
        });
        this.selectedRole.onChanged().addListener(role -> {
            titleField.setValue(role.getTitle());
            iconComboBox.setValue((Object)IconUtils.decodeIcon((String)role.getIcon()));
            parentRoleComboBox.setValue((Object)role.getParent());
            allowedOrganizationUnitTypesTagCombo.setValue(role.getAllowedOrganizationUnitTypes());
            organizationFieldComboBox.setValue((Object)role.getOrganizationField());
            generalizationRolesTagCombo.setValue(role.getGeneralizationRoles());
            specializationRolesTagCombo.setValue(role.getSpecializationRoles());
            privilegesReceivingRolesTagCombo.setValue(role.getPrivilegesReceivingRoles());
            privilegesSendingRolesTagCombo.setValue(role.getPrivilegesSendingRoles());
            noDirectMembershipsCheckBox.setValue((Object)role.getNoDirectMemberships());
        });
        this.selectedRole.set((Object)Role.create());
    }

    private TagComboBox<Role> createRoleTagComboBox() {
        TagComboBox tagComboBox = new TagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        tagComboBox.setModel(query -> query == null || query.isBlank() ? (this.isAppFilter() ? Role.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())).execute() : Role.getAll().stream().limit(50L).collect(Collectors.toList())) : (this.isAppFilter() ? Role.filter().parseFullTextFilter(query, new String[0]).organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())).execute() : Role.filter().parseFullTextFilter(query, new String[0]).execute()));
        PropertyProvider<Role> propertyProvider = PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData());
        tagComboBox.setPropertyProvider(propertyProvider);
        tagComboBox.setRecordToStringFunction(unitType -> (String)propertyProvider.getValues(unitType, Collections.emptyList()).get("caption"));
        tagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        tagComboBox.setDistinct(true);
        return tagComboBox;
    }

    private TagComboBox<OrganizationUnitType> createOrgUnitTypeTagComboBox() {
        TagComboBox tagComboBox = new TagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        tagComboBox.setModel(query -> query == null || query.isBlank() ? OrganizationUnitType.getAll().stream().limit(50L).collect(Collectors.toList()) : OrganizationUnitType.filter().parseFullTextFilter(query, new String[0]).execute().stream().limit(50L).collect(Collectors.toList()));
        PropertyProvider<OrganizationUnitType> propertyProvider = PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData());
        tagComboBox.setPropertyProvider(propertyProvider);
        tagComboBox.setRecordToStringFunction(unitType -> (String)propertyProvider.getValues(unitType, Collections.emptyList()).get("caption"));
        tagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        tagComboBox.setDistinct(true);
        return tagComboBox;
    }
}

