/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.api.config.ApplicationConfig;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.bootstrap.ApplicationInfo;
import org.teamapps.application.server.system.bootstrap.BaseResourceLinkProvider;
import org.teamapps.application.server.system.bootstrap.BootstrapSessionHandler;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationInstaller;
import org.teamapps.application.server.system.config.DocumentConversionConfig;
import org.teamapps.application.server.system.config.SystemConfig;
import org.teamapps.application.server.system.localization.DictionaryLocalizationProvider;
import org.teamapps.application.server.system.localization.SystemLocalizationProvider;
import org.teamapps.application.server.system.machinetranslation.TranslationService;
import org.teamapps.application.server.system.server.SessionRegistryHandler;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPerspective;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationGroup;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.universaldb.UniversalDB;

public class SystemRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final BootstrapSessionHandler bootstrapSessionHandler;
    private final UniversalDB universalDB;
    private final ApplicationConfig<SystemConfig> applicationConfig;
    private final TranslationService translationService;
    private final DictionaryLocalizationProvider dictionary;
    private final SystemLocalizationProvider systemDictionary;
    private final Map<Application, LoadedApplication> loadedApplicationMap = new HashMap<Application, LoadedApplication>();
    private final ManagedApplicationGroup unspecifiedApplicationGroup;
    private final BaseResourceLinkProvider baseResourceLinkProvider;
    private SessionRegistryHandler sessionRegistryHandler;
    private DocumentConverter documentConverter;

    public SystemRegistry(BootstrapSessionHandler bootstrapSessionHandler, UniversalDB universalDB, ApplicationConfig<SystemConfig> applicationConfig, TranslationService translationService) {
        SystemConfig systemConfig = (SystemConfig)applicationConfig.getConfig();
        this.bootstrapSessionHandler = bootstrapSessionHandler;
        this.universalDB = universalDB;
        this.applicationConfig = applicationConfig;
        this.translationService = translationService;
        this.dictionary = new DictionaryLocalizationProvider(translationService, systemConfig.getLocalizationConfig().getRequiredLanguages());
        this.systemDictionary = new SystemLocalizationProvider(translationService, systemConfig.getLocalizationConfig().getRequiredLanguages());
        this.baseResourceLinkProvider = new BaseResourceLinkProvider();
        this.unspecifiedApplicationGroup = this.getOrCreateUnspecifiedApplicationGroup();
        this.handleConfigUpdate();
        applicationConfig.onConfigUpdate.addListener(this::handleConfigUpdate);
    }

    private void handleConfigUpdate() {
        DocumentConversionConfig documentConversionConfig = ((SystemConfig)this.applicationConfig.getConfig()).getDocumentConversionConfig();
        if (documentConversionConfig.isActive()) {
            this.documentConverter = DocumentConverter.createRemoteConverter((String)documentConversionConfig.getHost(), (String)documentConversionConfig.getUser(), (String)documentConversionConfig.getPassword());
        }
    }

    private ManagedApplicationGroup getOrCreateUnspecifiedApplicationGroup() {
        if (ManagedApplicationGroup.getCount() == 0) {
            return (ManagedApplicationGroup)ManagedApplicationGroup.create().setIcon(IconUtils.encodeNoStyle((Icon)ApplicationIcons.HOME)).setTitleKey("org.teamapps.dictionary.applications").save();
        }
        return ManagedApplicationGroup.getAll().get(0);
    }

    public ApplicationInstaller createJarInstaller(File jarFile) {
        return ApplicationInstaller.createJarInstaller(jarFile, this.universalDB, this.translationService, this.getSystemConfig().getLocalizationConfig());
    }

    public boolean installAndLoadApplication(BaseApplicationBuilder baseApplicationBuilder) {
        ApplicationInstaller applicationInstaller = ApplicationInstaller.createClassInstaller(baseApplicationBuilder, this.universalDB, this.translationService, this.getSystemConfig().getLocalizationConfig());
        return this.installAndLoadApplication(applicationInstaller);
    }

    public boolean installAndLoadApplication(ApplicationInstaller applicationInstaller) {
        if (!applicationInstaller.isInstalled()) {
            if (applicationInstaller.installApplication()) {
                ApplicationInfo applicationInfo = applicationInstaller.getApplicationInfo();
                Application application = applicationInfo.getApplication();
                if (application.getVersions().size() == 1) {
                    ManagedApplication managedApplication = (ManagedApplication)ManagedApplication.create().setMainApplication(application).setApplicationGroup(this.unspecifiedApplicationGroup).setSingleApplication(applicationInfo.isUnmanagedPerspectives()).save();
                    List perspectives = application.getPerspectives().stream().filter(perspective -> perspective.getAutoProvision()).collect(Collectors.toList());
                    for (ApplicationPerspective perspective2 : perspectives) {
                        ManagedApplicationPerspective.create().setManagedApplication(managedApplication).setApplicationPerspective(perspective2).save();
                    }
                }
            } else {
                System.out.println("Error installing " + applicationInstaller.getApplicationInfo().getName() + ": " + applicationInstaller.getApplicationInfo().getErrorMessage());
                System.out.println("\tWarnings:" + applicationInstaller.getApplicationInfo().getWarningMessage());
                return false;
            }
        }
        this.loadApplication(applicationInstaller);
        return true;
    }

    public void loadApplication(ApplicationInstaller applicationInstaller) {
        try {
            LoadedApplication loadedApplication = applicationInstaller.loadApplication();
            System.out.println("Loaded app:" + applicationInstaller.getApplicationInfo().getName());
            if (applicationInstaller.getApplicationInfo().getErrors().isEmpty()) {
                this.addLoadedApplication(loadedApplication);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error loading application: " + applicationInstaller.getApplicationInfo(), e);
        }
    }

    public void addLoadedApplication(LoadedApplication loadedApplication) {
        this.loadedApplicationMap.put(loadedApplication.getApplication(), loadedApplication);
    }

    public LoadedApplication getLoadedApplication(Application application) {
        return this.loadedApplicationMap.get(application);
    }

    public DictionaryLocalizationProvider getDictionary() {
        return this.dictionary;
    }

    public SystemLocalizationProvider getSystemDictionary() {
        return this.systemDictionary;
    }

    public Supplier<DocumentConverter> getDocumentConverterSupplier() {
        return () -> this.documentConverter;
    }

    public SystemConfig getSystemConfig() {
        return (SystemConfig)this.applicationConfig.getConfig();
    }

    public BootstrapSessionHandler getBootstrapSessionHandler() {
        return this.bootstrapSessionHandler;
    }

    public TranslationService getTranslationService() {
        return this.translationService;
    }

    public BaseResourceLinkProvider getBaseResourceLinkProvider() {
        return this.baseResourceLinkProvider;
    }

    public SessionRegistryHandler getSessionRegistryHandler() {
        return this.sessionRegistryHandler;
    }

    public void setSessionRegistryHandler(SessionRegistryHandler sessionRegistryHandler) {
        this.sessionRegistryHandler = sessionRegistryHandler;
    }
}

