/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.localization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.application.server.system.localization.LocalizationProvider;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.universaldb.index.numeric.NumericFilter;

public class ApplicationScopeLocalizationProvider
implements LocalizationProvider {
    private final Application application;
    private Map<String, Map<String, LocalizationValue>> localizationLanguageValueMapByKey;

    public ApplicationScopeLocalizationProvider(Application application) {
        this.application = application;
        this.loadLocalizationData();
    }

    private void loadLocalizationData() {
        try {
            this.localizationLanguageValueMapByKey = new HashMap<String, Map<String, LocalizationValue>>();
            LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)this.application.getId())).execute().stream().flatMap(key -> key.getLocalizationValues().stream()).forEach(value -> this.localizationLanguageValueMapByKey.computeIfAbsent(value.getLocalizationKey().getKey(), k -> new HashMap()).put(value.getLanguage(), value));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getLocalizationValue(String key, List<String> languagePriorityOrder) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        Map<String, LocalizationValue> languageValueMap = this.localizationLanguageValueMapByKey.get(key);
        if (languageValueMap != null) {
            for (String language : languagePriorityOrder) {
                LocalizationValue value = languageValueMap.get(language);
                if (value == null || value.getCurrentDisplayValue() == null) continue;
                return value.getCurrentDisplayValue();
            }
        }
        return key;
    }
}

