/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.teamapps.application.server.EntityUpdateEventHandler;
import org.teamapps.application.server.SessionHandler;
import org.teamapps.protocol.system.SystemLogEntry;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.log.MessageStore;

public class ServerRegistry {
    private final UniversalDB universalDB;
    private final MessageStore<SystemLogEntry> systemLogMessageStore;
    private final Supplier<List<SessionHandler>> sessionHandlerSupplier;
    private EntityUpdateEventHandler entityUpdateEventHandler;
    private Map<String, Object> loadedApplications = new ConcurrentHashMap<String, Object>();

    public ServerRegistry(UniversalDB universalDB, MessageStore<SystemLogEntry> systemLogMessageStore, Supplier<List<SessionHandler>> sessionHandlerSupplier) {
        this.universalDB = universalDB;
        this.entityUpdateEventHandler = new EntityUpdateEventHandler(universalDB.getUpdateEventQueue());
        this.systemLogMessageStore = systemLogMessageStore;
        this.sessionHandlerSupplier = sessionHandlerSupplier;
    }

    public UniversalDB getUniversalDB() {
        return this.universalDB;
    }

    public EntityUpdateEventHandler getEntityUpdateEventHandler() {
        return this.entityUpdateEventHandler;
    }

    public Map<String, Object> getLoadedApplications() {
        return this.loadedApplications;
    }

    public List<SessionHandler> getSessionHandlers() {
        return this.sessionHandlerSupplier.get();
    }

    public MessageStore<SystemLogEntry> getSystemLogMessageStore() {
        return this.systemLogMessageStore;
    }
}

