package org.teamapps.protocol.system;

import org.teamapps.protocol.schema.*;
import org.teamapps.protocol.service.*;
import org.teamapps.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import io.netty.buffer.ByteBuf;
import java.util.*;


public class SystemLogEntry extends MessageObject {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<SystemLogEntry> decoder = new PojoObjectDecoder<SystemLogEntry>() {
		@Override
		public SystemLogEntry decode(DataInputStream dis, FileProvider fileProvider) {
			try {
				return new SystemLogEntry(dis, fileProvider);
			} catch (IOException e) {
				LOGGER.error("Error creating SystemLogEntry instance", e);
			}
			return null;
		}

		@Override
		public SystemLogEntry decode(ByteBuf buf, FileProvider fileProvider) {
			try {
				return new SystemLogEntry(buf, fileProvider);
			} catch (IOException e) {
				LOGGER.error("Error creating SystemLogEntry instance", e);
			}
			return null;
		}

		@Override
		public SystemLogEntry remap(MessageObject message) {
			return new SystemLogEntry(message, ApplicationServerProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageObjectUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<SystemLogEntry> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ApplicationServerProtocol.MODEL_COLLECTION;
	}

    public static SystemLogEntry remap(MessageObject message) {
        return new SystemLogEntry(message, ApplicationServerProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "#t.sle";


	public SystemLogEntry() {
		super(ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public SystemLogEntry(MessageObject message, PojoObjectDecoderRegistry pojoObjectDecoderRegistry) {
		super(message, pojoObjectDecoderRegistry);
	}

	public SystemLogEntry(DataInputStream dis) throws IOException {
		super(dis, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public SystemLogEntry(DataInputStream dis, FileProvider fileProvider) throws IOException {
		super(dis, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public SystemLogEntry(ByteBuf buf, FileProvider fileProvider) throws IOException {
		super(buf, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public SystemLogEntry(byte[] bytes) throws IOException {
		super(bytes, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public SystemLogEntry(byte[] bytes, FileProvider fileProvider) throws IOException {
		super(bytes, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public long getNodeId() {
		return getLongProperty("nodeId");
	}

	public SystemLogEntry setNodeId(long value) {
		setLongProperty("nodeId", value);
		return this;
	}

	public int getUserId() {
		return getIntProperty("userId");
	}

	public SystemLogEntry setUserId(int value) {
		setIntProperty("userId", value);
		return this;
	}

	public long getTimestamp() {
		return getLongProperty("timestamp");
	}

	public SystemLogEntry setTimestamp(long value) {
		setLongProperty("timestamp", value);
		return this;
	}

	public int getLogLevel() {
		return getIntProperty("logLevel");
	}

	public SystemLogEntry setLogLevel(int value) {
		setIntProperty("logLevel", value);
		return this;
	}

	public int getManagedApplicationId() {
		return getIntProperty("managedApplicationId");
	}

	public SystemLogEntry setManagedApplicationId(int value) {
		setIntProperty("managedApplicationId", value);
		return this;
	}

	public int getManagedApplicationPerspectiveId() {
		return getIntProperty("managedApplicationPerspectiveId");
	}

	public SystemLogEntry setManagedApplicationPerspectiveId(int value) {
		setIntProperty("managedApplicationPerspectiveId", value);
		return this;
	}

	public String getApplicationVersion() {
		return getStringProperty("applicationVersion");
	}

	public SystemLogEntry setApplicationVersion(String value) {
		setStringProperty("applicationVersion", value);
		return this;
	}

	public String getExceptionClass() {
		return getStringProperty("exceptionClass");
	}

	public SystemLogEntry setExceptionClass(String value) {
		setStringProperty("exceptionClass", value);
		return this;
	}

	public String getThreadName() {
		return getStringProperty("threadName");
	}

	public SystemLogEntry setThreadName(String value) {
		setStringProperty("threadName", value);
		return this;
	}

	public String getTitle() {
		return getStringProperty("title");
	}

	public SystemLogEntry setTitle(String value) {
		setStringProperty("title", value);
		return this;
	}

	public String getMessage() {
		return getStringProperty("message");
	}

	public SystemLogEntry setMessage(String value) {
		setStringProperty("message", value);
		return this;
	}

	public String getStackTrace() {
		return getStringProperty("stackTrace");
	}

	public SystemLogEntry setStackTrace(String value) {
		setStringProperty("stackTrace", value);
		return this;
	}



}