/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.teamapps.application.server.EntityUpdateEventHandler;
import org.teamapps.application.server.SessionHandler;
import org.teamapps.protocol.system.SystemLogEntry;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.log.ChunkedIndexMessageStore;

public class ServerRegistry {
    private File basePath;
    private final UniversalDB universalDB;
    private final ChunkedIndexMessageStore<SystemLogEntry> systemLogMessageStore;
    private final Supplier<List<SessionHandler>> sessionHandlerSupplier;
    private EntityUpdateEventHandler entityUpdateEventHandler;
    private Map<String, Object> loadedApplications = new ConcurrentHashMap<String, Object>();

    public ServerRegistry(File basePath, UniversalDB universalDB, ChunkedIndexMessageStore<SystemLogEntry> systemLogMessageStore, Supplier<List<SessionHandler>> sessionHandlerSupplier) {
        this.basePath = basePath;
        this.universalDB = universalDB;
        this.entityUpdateEventHandler = new EntityUpdateEventHandler(universalDB.getUpdateEventQueue());
        this.systemLogMessageStore = systemLogMessageStore;
        this.sessionHandlerSupplier = sessionHandlerSupplier;
    }

    public File getBasePath() {
        return this.basePath;
    }

    public UniversalDB getUniversalDB() {
        return this.universalDB;
    }

    public EntityUpdateEventHandler getEntityUpdateEventHandler() {
        return this.entityUpdateEventHandler;
    }

    public Map<String, Object> getLoadedApplications() {
        return this.loadedApplications;
    }

    public List<SessionHandler> getSessionHandlers() {
        return this.sessionHandlerSupplier.get();
    }

    public ChunkedIndexMessageStore<SystemLogEntry> getSystemLogMessageStore() {
        return this.systemLogMessageStore;
    }
}

