package org.teamapps.protocol.system;

import org.teamapps.protocol.schema.*;
import org.teamapps.protocol.service.*;
import org.teamapps.protocol.file.*;
import java.util.HashMap;
import java.util.Map;

public class ApplicationServerProtocol {

	public static final MessageModelCollection MODEL_COLLECTION = new MessageModelCollection("ApplicationServerProtocol", "org.teamapps.protocol.system", 1);


    static {
		ObjectPropertyDefinition systemLogEntry = MODEL_COLLECTION.createModel("systemLogEntry", "#t.sle", 1, null, null);

		systemLogEntry.addProperty("logId", 1, PropertyType.INT, PropertyContentType.GENERIC, null, null);
		systemLogEntry.addProperty("nodeId", 2, PropertyType.LONG, PropertyContentType.GENERIC, null, null);
		systemLogEntry.addProperty("userId", 3, PropertyType.INT, PropertyContentType.GENERIC, null, null);
		systemLogEntry.addProperty("timestamp", 4, PropertyType.LONG, PropertyContentType.GENERIC, null, null);
		systemLogEntry.addProperty("logLevel", 5, PropertyType.INT, PropertyContentType.GENERIC, null, null);
		systemLogEntry.addProperty("managedApplicationId", 6, PropertyType.INT, PropertyContentType.GENERIC, null, null);
		systemLogEntry.addProperty("managedApplicationPerspectiveId", 7, PropertyType.INT, PropertyContentType.GENERIC, null, null);
		systemLogEntry.addProperty("applicationVersion", 8, PropertyType.STRING, PropertyContentType.GENERIC, null, null);
		systemLogEntry.addProperty("exceptionClass", 9, PropertyType.STRING, PropertyContentType.GENERIC, null, null);
		systemLogEntry.addProperty("threadName", 10, PropertyType.STRING, PropertyContentType.GENERIC, null, null);
		systemLogEntry.addProperty("title", 11, PropertyType.STRING, PropertyContentType.GENERIC, null, null);
		systemLogEntry.addProperty("message", 12, PropertyType.STRING, PropertyContentType.GENERIC, null, null);
		systemLogEntry.addProperty("stackTrace", 13, PropertyType.STRING, PropertyContentType.GENERIC, null, null);


		MODEL_COLLECTION.addMessageDecoder(systemLogEntry.getObjectUuid(), SystemLogEntry.getMessageDecoder());

    }



}