/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRegistration;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.server.DatabaseLogAppender;
import org.teamapps.application.server.EmbeddedResourceStore;
import org.teamapps.application.server.PublicLinkResourceProvider;
import org.teamapps.application.server.SecureResourceHandler;
import org.teamapps.application.server.ServerRegistry;
import org.teamapps.application.server.ServletRegistration;
import org.teamapps.application.server.SessionHandler;
import org.teamapps.application.server.SessionManager;
import org.teamapps.cluster.network.NodeAddress;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.core.TeamAppsCore;
import org.teamapps.model.ApplicationServerSchema;
import org.teamapps.model.system.SystemStarts;
import org.teamapps.model.system.Type;
import org.teamapps.protocol.system.SystemLogEntry;
import org.teamapps.server.undertow.embedded.TeamAppsUndertowEmbeddedServer;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.log.MessageStore;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.servlet.resourceprovider.ClassPathResourceProvider;
import org.teamapps.ux.servlet.resourceprovider.ResourceProvider;
import org.teamapps.ux.servlet.resourceprovider.ResourceProviderServlet;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class ApplicationServer
implements WebController,
SessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private File basePath;
    private File fileStorePath;
    private TeamAppsConfiguration teamAppsConfiguration;
    private int port;
    private UniversalDB universalDb;
    private ServerRegistry serverRegistry;
    private List<ServletRegistration> servletRegistrations = new ArrayList<ServletRegistration>();
    private SessionHandler sessionHandler;
    private WeakHashMap<SessionHandler, Long> weakStartDateBySessionHandler = new WeakHashMap();
    private boolean useCluster;
    private String clusterSecret;
    private int leaderPort;
    private String leaderHost;
    private int localPort;
    private TeamAppsCore teamAppsCore;

    public ApplicationServer() {
        this(new File("./server-data"), new TeamAppsConfiguration(), 8080);
    }

    public ApplicationServer(boolean useCluster, String clusterSecret, int localPort, String leaderHost, int leaderPort) {
        this.basePath = new File("./server-data");
        this.teamAppsConfiguration = new TeamAppsConfiguration();
        this.port = 8080;
        this.useCluster = useCluster;
        this.clusterSecret = clusterSecret;
        this.leaderPort = leaderPort;
        this.leaderHost = leaderHost;
        this.localPort = localPort;
    }

    public ApplicationServer(File basePath) {
        this(basePath, new TeamAppsConfiguration(), 8080);
    }

    public ApplicationServer(File basePath, TeamAppsConfiguration teamAppsConfiguration, int port) {
        this.basePath = basePath;
        this.teamAppsConfiguration = teamAppsConfiguration;
        this.port = port;
    }

    @Override
    public SessionHandler updateSessionHandler(File jarFile) throws Exception {
        LOGGER.info("Loading new session handler:" + jarFile.getPath());
        URL resource = jarFile.toURI().toURL();
        return this.updateSessionHandler(resource);
    }

    public SessionHandler updateSessionHandler(URL resource) throws Exception {
        LOGGER.info("Loading new session handler:" + resource.getPath());
        URLClassLoader classLoader = new URLClassLoader(new URL[]{resource});
        SessionHandler newSessionHandler = this.loadSessionHandler(classLoader);
        if (newSessionHandler != null) {
            this.weakStartDateBySessionHandler.put(newSessionHandler, System.currentTimeMillis());
            if (this.serverRegistry != null) {
                newSessionHandler.init(this, this.serverRegistry);
            }
            this.sessionHandler = newSessionHandler;
            System.gc();
            LOGGER.info("Updated session handler:" + this.sessionHandler);
        }
        return newSessionHandler;
    }

    @Override
    public void updateSessionHandler(SessionHandler sessionHandler) {
        this.weakStartDateBySessionHandler.put(sessionHandler, System.currentTimeMillis());
        if (this.serverRegistry != null) {
            sessionHandler.init(this, this.serverRegistry);
        }
        this.sessionHandler = sessionHandler;
        System.gc();
        LOGGER.info("Updated session handler:" + sessionHandler);
    }

    private SessionHandler loadSessionHandler(URLClassLoader classLoader) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        ClassGraph classGraph = new ClassGraph();
        if (classLoader != null) {
            classGraph.overrideClassLoaders(new ClassLoader[]{classLoader});
        }
        ClassInfoList classInfos = classGraph.enableAllInfo().scan().getClassesImplementing(SessionHandler.class.getName()).getStandardClasses();
        ClassInfo bootableClassInfo = null;
        for (ClassInfo classInfo : classInfos) {
            String path2;
            if (bootableClassInfo == null) {
                bootableClassInfo = classInfo;
                continue;
            }
            String path1 = this.getInheritanceClassPath(classInfo);
            if (path1.contains(path2 = this.getInheritanceClassPath(bootableClassInfo))) {
                bootableClassInfo = classInfo;
                continue;
            }
            if (path2.contains(path1)) continue;
            bootableClassInfo = null;
            LOGGER.error("Error several implementations for SessionHandler without common inheritance");
            break;
        }
        if (bootableClassInfo == null) {
            LOGGER.info("Selecting class by annotation...");
            bootableClassInfo = classInfos.stream().sorted((o1, o2) -> Integer.compare(this.getBootPriority((ClassInfo)o2), this.getBootPriority((ClassInfo)o1))).findFirst().orElse(null);
        }
        if (bootableClassInfo != null) {
            LOGGER.info("Booting class: " + bootableClassInfo.getName() + " with priority:" + this.getBootPriority(bootableClassInfo));
            Class<?> builder = classLoader.loadClass(bootableClassInfo.getName());
            return (SessionHandler)builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        LOGGER.error("Error: no matching class found!");
        return null;
    }

    private int getBootPriority(ClassInfo classInfo) {
        AnnotationInfo bootableClass = classInfo.getAnnotationInfo("org.teamapps.application.api.annotation.TeamAppsBootableClass");
        return bootableClass != null ? (Integer)bootableClass.getParameterValues(true).getValue("priority") : 0;
    }

    private String getInheritanceClassPath(ClassInfo classInfo) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(classInfo.getName());
        for (ClassInfo superclass : classInfo.getSuperclasses()) {
            path.add(superclass.getName());
        }
        Collections.reverse(path);
        return path.stream().collect(Collectors.joining("/"));
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void onSessionStart(SessionContext context) {
        this.sessionHandler.handleSessionStart(context);
    }

    @Override
    public Collection<Long> getBootstrappedSystems() {
        return this.weakStartDateBySessionHandler.values();
    }

    public void start() throws Exception {
        File dbPath = new File(this.basePath, "database");
        dbPath.mkdir();
        if (this.fileStorePath == null) {
            this.fileStorePath = new File(dbPath, "file-store");
        }
        final File embeddedStore = new File(this.basePath, "embedded-store");
        embeddedStore.mkdir();
        this.universalDb = this.useCluster ? (this.leaderHost != null ? new UniversalDB(dbPath, (SchemaInfoProvider)new ApplicationServerSchema(), this.clusterSecret, this.localPort, new NodeAddress(this.leaderHost, this.leaderPort)) : new UniversalDB(dbPath, (SchemaInfoProvider)new ApplicationServerSchema(), this.clusterSecret, this.localPort)) : UniversalDB.createStandalone((File)dbPath, (File)this.fileStorePath, (SchemaInfoProvider)new ApplicationServerSchema());
        MessageStore logMessageStore = new MessageStore(this.basePath, "systemLogs", false, SystemLogEntry.getMessageDecoder(), SystemLogEntry::setLogId, SystemLogEntry::getLogId);
        DatabaseLogAppender.startLogger((MessageStore<SystemLogEntry>)logMessageStore);
        TeamAppsUndertowEmbeddedServer server = new TeamAppsUndertowEmbeddedServer((WebController)this, this.teamAppsConfiguration, this.port);
        this.teamAppsCore = server.getTeamAppsCore();
        this.serverRegistry = new ServerRegistry(this.basePath, this.universalDb, (MessageStore<SystemLogEntry>)logMessageStore, () -> this.weakStartDateBySessionHandler.keySet().stream().filter(Objects::nonNull).collect(Collectors.toList()), this.teamAppsCore);
        this.sessionHandler.init(this, this.serverRegistry);
        this.addClassPathResourceProvider("org.teamapps.application.server.media", "/ta-media/");
        File staticResourcesPath = new File(this.basePath, "static");
        staticResourcesPath.mkdir();
        this.addServletRegistration(new ServletRegistration((Servlet)new ResourceProviderServlet((servletPath, relativeResourcePath, httpSessionId) -> {
            File file = new File(staticResourcesPath, relativeResourcePath);
            if (file.exists() && !file.isDirectory()) {
                return new FileResource(file);
            }
            return null;
        }), "/static/*"));
        for (final ServletRegistration servletRegistration : this.servletRegistrations) {
            for (final String mapping : servletRegistration.getMappings()) {
                LOGGER.info("Registering servlet on url path: " + mapping);
                server.addServletContextListener(new ServletContextListener(){

                    public void contextInitialized(ServletContextEvent sce) {
                        ServletRegistration.Dynamic dynamic = sce.getServletContext().addServlet("teamapps-registered-" + servletRegistration.getServlet().getClass().getSimpleName() + UUID.randomUUID().toString(), servletRegistration.getServlet());
                        dynamic.setAsyncSupported(servletRegistration.isAsyncSupported());
                        dynamic.addMapping(new String[]{mapping});
                    }
                });
            }
        }
        server.addServletContextListener(new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                ServletContext servletContext = sce.getServletContext();
                servletContext.addServlet("ta-embedded", (Servlet)new ResourceProviderServlet((ResourceProvider)new EmbeddedResourceStore(embeddedStore))).addMapping(new String[]{"/TA-EMBEDDED/*"});
                servletContext.addServlet("ta-sec-links", (Servlet)new ResourceProviderServlet((servletPath, relativeResourcePath, httpSessionId) -> SecureResourceHandler.getInstance().getResource(servletPath, relativeResourcePath, httpSessionId))).addMapping(new String[]{"/TA-SEC-PRVD/*"});
                servletContext.addServlet("ta-public-link", (Servlet)new ResourceProviderServlet((ResourceProvider)PublicLinkResourceProvider.getInstance())).addMapping(new String[]{"/pl/*"});
            }
        });
        server.start();
        SystemStarts.create().setTimestamp(Instant.now()).setType(Type.START).save();
    }

    public void addClassPathResourceProvider(String basePackage, String prefix) {
        if (!((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        this.addServletRegistration(new ServletRegistration((Servlet)new ResourceProviderServlet((ResourceProvider)new ClassPathResourceProvider(basePackage)), (String)prefix + "*"));
    }

    public void addServletRegistration(ServletRegistration servletRegistration) {
        this.servletRegistrations.add(servletRegistration);
    }

    public void setTeamAppsConfiguration(TeamAppsConfiguration teamAppsConfiguration) {
        this.teamAppsConfiguration = teamAppsConfiguration;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setBasePath(File basePath) {
        this.basePath = basePath;
    }

    public File getFileStorePath() {
        return this.fileStorePath;
    }

    public void setFileStorePath(File fileStorePath) {
        this.fileStorePath = fileStorePath;
    }

    public TeamAppsCore getTeamAppsCore() {
        return this.teamAppsCore;
    }
}

