/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.teamapps.application.server.EntityUpdateEventHandler;
import org.teamapps.application.server.SessionHandler;
import org.teamapps.core.TeamAppsCore;
import org.teamapps.protocol.system.SystemLogEntry;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.log.MessageStore;

public class ServerRegistry {
    private File basePath;
    private final UniversalDB universalDB;
    private final MessageStore<SystemLogEntry> systemLogMessageStore;
    private final Supplier<List<SessionHandler>> sessionHandlerSupplier;
    private final TeamAppsCore teamAppsCore;
    private EntityUpdateEventHandler entityUpdateEventHandler;
    private Map<String, Object> loadedApplications = new ConcurrentHashMap<String, Object>();

    public ServerRegistry(File basePath, UniversalDB universalDB, MessageStore<SystemLogEntry> systemLogMessageStore, Supplier<List<SessionHandler>> sessionHandlerSupplier, TeamAppsCore teamAppsCore) {
        this.basePath = basePath;
        this.universalDB = universalDB;
        this.entityUpdateEventHandler = new EntityUpdateEventHandler(universalDB.getUpdateEventQueue());
        this.systemLogMessageStore = systemLogMessageStore;
        this.sessionHandlerSupplier = sessionHandlerSupplier;
        this.teamAppsCore = teamAppsCore;
    }

    public File getBasePath() {
        return this.basePath;
    }

    public UniversalDB getUniversalDB() {
        return this.universalDB;
    }

    public EntityUpdateEventHandler getEntityUpdateEventHandler() {
        return this.entityUpdateEventHandler;
    }

    public Map<String, Object> getLoadedApplications() {
        return this.loadedApplications;
    }

    public List<SessionHandler> getSessionHandlers() {
        return this.sessionHandlerSupplier.get();
    }

    public MessageStore<SystemLogEntry> getSystemLogMessageStore() {
        return this.systemLogMessageStore;
    }

    public TeamAppsCore getTeamAppsCore() {
        return this.teamAppsCore;
    }
}

