/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.system;

import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.schema.MessageModel;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelCollection;
import org.teamapps.protocol.schema.PojoObjectDecoder;
import org.teamapps.protocol.schema.PojoObjectDecoderRegistry;
import org.teamapps.protocol.system.ApplicationServerProtocol;

public class SystemLogEntry
extends MessageObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PojoObjectDecoder<SystemLogEntry> decoder = new PojoObjectDecoder<SystemLogEntry>(){

        public SystemLogEntry decode(DataInputStream dis, FileProvider fileProvider) {
            try {
                return new SystemLogEntry(dis, fileProvider);
            }
            catch (IOException e) {
                LOGGER.error("Error creating SystemLogEntry instance", (Throwable)e);
                return null;
            }
        }

        public SystemLogEntry decode(ByteBuf buf, FileProvider fileProvider) {
            try {
                return new SystemLogEntry(buf, fileProvider);
            }
            catch (IOException e) {
                LOGGER.error("Error creating SystemLogEntry instance", (Throwable)e);
                return null;
            }
        }

        public SystemLogEntry remap(MessageObject message) {
            return new SystemLogEntry(message, (PojoObjectDecoderRegistry)ApplicationServerProtocol.MODEL_COLLECTION);
        }

        public String getMessageObjectUuid() {
            return SystemLogEntry.OBJECT_UUID;
        }
    };
    public static final String OBJECT_UUID = "#t.sle";

    public static PojoObjectDecoder<SystemLogEntry> getMessageDecoder() {
        return decoder;
    }

    public static MessageModel getMessageModel() {
        return ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

    public static ModelCollection getModelCollection() {
        return ApplicationServerProtocol.MODEL_COLLECTION;
    }

    public static SystemLogEntry remap(MessageObject message) {
        return new SystemLogEntry(message, (PojoObjectDecoderRegistry)ApplicationServerProtocol.MODEL_COLLECTION);
    }

    public SystemLogEntry() {
        super(ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
    }

    public SystemLogEntry(MessageObject message, PojoObjectDecoderRegistry pojoObjectDecoderRegistry) {
        super(message, pojoObjectDecoderRegistry);
    }

    public SystemLogEntry(DataInputStream dis) throws IOException {
        super(dis, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, (PojoObjectDecoderRegistry)ApplicationServerProtocol.MODEL_COLLECTION);
    }

    public SystemLogEntry(DataInputStream dis, FileProvider fileProvider) throws IOException {
        super(dis, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, (PojoObjectDecoderRegistry)ApplicationServerProtocol.MODEL_COLLECTION);
    }

    public SystemLogEntry(ByteBuf buf, FileProvider fileProvider) throws IOException {
        super(buf, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, (PojoObjectDecoderRegistry)ApplicationServerProtocol.MODEL_COLLECTION);
    }

    public SystemLogEntry(byte[] bytes) throws IOException {
        super(bytes, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, (PojoObjectDecoderRegistry)ApplicationServerProtocol.MODEL_COLLECTION);
    }

    public SystemLogEntry(byte[] bytes, FileProvider fileProvider) throws IOException {
        super(bytes, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, (PojoObjectDecoderRegistry)ApplicationServerProtocol.MODEL_COLLECTION);
    }

    public int getLogId() {
        return this.getIntProperty("logId");
    }

    public SystemLogEntry setLogId(int value) {
        this.setIntProperty("logId", value);
        return this;
    }

    public long getNodeId() {
        return this.getLongProperty("nodeId");
    }

    public SystemLogEntry setNodeId(long value) {
        this.setLongProperty("nodeId", value);
        return this;
    }

    public int getUserId() {
        return this.getIntProperty("userId");
    }

    public SystemLogEntry setUserId(int value) {
        this.setIntProperty("userId", value);
        return this;
    }

    public long getTimestamp() {
        return this.getLongProperty("timestamp");
    }

    public SystemLogEntry setTimestamp(long value) {
        this.setLongProperty("timestamp", value);
        return this;
    }

    public int getLogLevel() {
        return this.getIntProperty("logLevel");
    }

    public SystemLogEntry setLogLevel(int value) {
        this.setIntProperty("logLevel", value);
        return this;
    }

    public int getManagedApplicationId() {
        return this.getIntProperty("managedApplicationId");
    }

    public SystemLogEntry setManagedApplicationId(int value) {
        this.setIntProperty("managedApplicationId", value);
        return this;
    }

    public int getManagedApplicationPerspectiveId() {
        return this.getIntProperty("managedApplicationPerspectiveId");
    }

    public SystemLogEntry setManagedApplicationPerspectiveId(int value) {
        this.setIntProperty("managedApplicationPerspectiveId", value);
        return this;
    }

    public String getApplicationVersion() {
        return this.getStringProperty("applicationVersion");
    }

    public SystemLogEntry setApplicationVersion(String value) {
        this.setStringProperty("applicationVersion", value);
        return this;
    }

    public String getExceptionClass() {
        return this.getStringProperty("exceptionClass");
    }

    public SystemLogEntry setExceptionClass(String value) {
        this.setStringProperty("exceptionClass", value);
        return this;
    }

    public String getThreadName() {
        return this.getStringProperty("threadName");
    }

    public SystemLogEntry setThreadName(String value) {
        this.setStringProperty("threadName", value);
        return this;
    }

    public String getTitle() {
        return this.getStringProperty("title");
    }

    public SystemLogEntry setTitle(String value) {
        this.setStringProperty("title", value);
        return this;
    }

    public String getMessage() {
        return this.getStringProperty("message");
    }

    public SystemLogEntry setMessage(String value) {
        this.setStringProperty("message", value);
        return this;
    }

    public String getStackTrace() {
        return this.getStringProperty("stackTrace");
    }

    public SystemLogEntry setStackTrace(String value) {
        this.setStringProperty("stackTrace", value);
        return this;
    }
}

