package org.teamapps.protocol.system;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import java.util.HashMap;
import java.util.Map;

public class ApplicationServerProtocol {

	public static final MessageModelCollection MODEL_COLLECTION = new MessageModelCollection("ApplicationServerProtocol", "org.teamapps.protocol.system", 1);


    static {
		MessageDefinition systemLogEntry = MODEL_COLLECTION.createModel("systemLogEntry", "#t.sle", 1, null, true);
		MessageDefinition loginData = MODEL_COLLECTION.createModel("loginData", "#t.l", 1, null, true);


		systemLogEntry.addAttribute("logId", 1, AttributeType.INT, null);
		systemLogEntry.addAttribute("nodeId", 2, AttributeType.LONG, null);
		systemLogEntry.addAttribute("userId", 3, AttributeType.INT, null);
		systemLogEntry.addAttribute("timestamp", 4, AttributeType.LONG, null);
		systemLogEntry.addAttribute("logLevel", 5, AttributeType.INT, null);
		systemLogEntry.addAttribute("managedApplicationId", 6, AttributeType.INT, null);
		systemLogEntry.addAttribute("managedApplicationPerspectiveId", 7, AttributeType.INT, null);
		systemLogEntry.addAttribute("applicationVersion", 8, AttributeType.STRING, null);
		systemLogEntry.addAttribute("exceptionClass", 9, AttributeType.STRING, null);
		systemLogEntry.addAttribute("threadName", 10, AttributeType.STRING, null);
		systemLogEntry.addAttribute("message", 12, AttributeType.STRING, null);
		systemLogEntry.addAttribute("stackTrace", 13, AttributeType.STRING, null);
		systemLogEntry.addAttribute("marker", 14, AttributeType.STRING, null);

		loginData.addAttribute("loginId", 1, AttributeType.INT, null);
		loginData.addAttribute("userId", 2, AttributeType.INT, null);
		loginData.addAttribute("ip", 3, AttributeType.STRING, null);
		loginData.addAttribute("userAgent", 4, AttributeType.STRING, null);
		loginData.addAttribute("mobileDevice", 5, AttributeType.BOOLEAN, null);
		loginData.addAttribute("screenWidth", 6, AttributeType.INT, null);
		loginData.addAttribute("screenHeight", 7, AttributeType.INT, null);
		loginData.addAttribute("loginTimestamp", 8, AttributeType.INT, null);
		loginData.addAttribute("logoutTimestamp", 9, AttributeType.INT, null);
		loginData.addAttribute("openApplicationsCount", 10, AttributeType.INT, null);
		loginData.addAttribute("openPerspectivesCount", 11, AttributeType.INT, null);
		loginData.addAttribute("activityCount", 12, AttributeType.INT, null);
		loginData.addAttribute("sentBytesToClient", 13, AttributeType.LONG, null);
		loginData.addAttribute("receivedBytesFromClient", 14, AttributeType.LONG, null);


		MODEL_COLLECTION.addMessageDecoder(systemLogEntry.getObjectUuid(), SystemLogEntry.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(loginData.getObjectUuid(), LoginData.getMessageDecoder());

    }



}