/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.io.File;
import org.teamapps.config.TeamAppsConfiguration;

public class ApplicationServerConfig {
    private final File basePath;
    private final File dateBasePath;
    private final File fileStorePath;
    private final File messageStorePath;
    private final File logStorePath;
    private final File embeddedContentStorePath;
    private final File webserverStaticFilesPath;
    private final TeamAppsConfiguration teamAppsConfiguration;
    private final int port;

    public static ApplicationServerConfig create() {
        TeamAppsConfiguration teamAppsConfiguration = new TeamAppsConfiguration();
        int port = 8080;
        File basePath = new File("./server-data");
        basePath.mkdir();
        return ApplicationServerConfig.createPaths(teamAppsConfiguration, port, basePath);
    }

    public static ApplicationServerConfig create(File basePath) {
        TeamAppsConfiguration teamAppsConfiguration = new TeamAppsConfiguration();
        int port = 8080;
        return ApplicationServerConfig.createPaths(teamAppsConfiguration, port, basePath);
    }

    public static ApplicationServerConfig create(File basePath, TeamAppsConfiguration teamAppsConfiguration, int port) {
        return ApplicationServerConfig.createPaths(teamAppsConfiguration, port, basePath);
    }

    public static ApplicationServerConfig create(File basePath, File dateBasePath, File fileStorePath, File messageStorePath, File logStorePath, File embeddedContentStorePath, File webserverStaticFilesPath, TeamAppsConfiguration teamAppsConfiguration, int port) {
        return new ApplicationServerConfig(basePath, dateBasePath, fileStorePath, messageStorePath, logStorePath, embeddedContentStorePath, webserverStaticFilesPath, teamAppsConfiguration, port);
    }

    private static ApplicationServerConfig createPaths(TeamAppsConfiguration teamAppsConfiguration, int port, File basePath) {
        File dateBasePath = ApplicationServerConfig.createPath(basePath, "database");
        File fileStorePath = ApplicationServerConfig.createPath(basePath, "file-store");
        File messageStorePath = ApplicationServerConfig.createPath(basePath, "message-store");
        File logStorePath = ApplicationServerConfig.createPath(basePath, "log-store");
        File embeddedContentStorePath = ApplicationServerConfig.createPath(basePath, "embedded-content-store");
        File webserverStaticFilesPath = ApplicationServerConfig.createPath(basePath, "static-files");
        return new ApplicationServerConfig(basePath, dateBasePath, fileStorePath, messageStorePath, logStorePath, embeddedContentStorePath, webserverStaticFilesPath, teamAppsConfiguration, port);
    }

    private ApplicationServerConfig(File basePath, File dateBasePath, File fileStorePath, File messageStorePath, File logStorePath, File embeddedContentStorePath, File webserverStaticFilesPath, TeamAppsConfiguration teamAppsConfiguration, int port) {
        this.basePath = basePath;
        this.dateBasePath = dateBasePath;
        this.fileStorePath = fileStorePath;
        this.messageStorePath = messageStorePath;
        this.logStorePath = logStorePath;
        this.embeddedContentStorePath = embeddedContentStorePath;
        this.webserverStaticFilesPath = webserverStaticFilesPath;
        this.teamAppsConfiguration = teamAppsConfiguration;
        this.port = port;
    }

    private static File createPath(File basePath, String name) {
        File path = new File(basePath, name);
        path.mkdir();
        return path;
    }

    public File getBasePath() {
        return this.basePath;
    }

    public File getDateBasePath() {
        return this.dateBasePath;
    }

    public File getFileStorePath() {
        return this.fileStorePath;
    }

    public File getMessageStorePath() {
        return this.messageStorePath;
    }

    public File getLogStorePath() {
        return this.logStorePath;
    }

    public File getEmbeddedContentStorePath() {
        return this.embeddedContentStorePath;
    }

    public File getWebserverStaticFilesPath() {
        return this.webserverStaticFilesPath;
    }

    public TeamAppsConfiguration getTeamAppsConfiguration() {
        return this.teamAppsConfiguration;
    }

    public int getPort() {
        return this.port;
    }
}

