package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface Application extends Entity<Application> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_NAME = "name";
	final static String FIELD_ICON = "icon";
	final static String FIELD_TITLE_KEY = "titleKey";
	final static String FIELD_DESCRIPTION_KEY = "descriptionKey";
	final static String FIELD_UNMANAGED_APPLICATION = "unmanagedApplication";
	final static String FIELD_CONFIG = "config";
	final static String FIELD_DARK_THEME = "darkTheme";
	final static String FIELD_PERSPECTIVES = "perspectives";
	final static String FIELD_PRIVILEGE_GROUPS = "privilegeGroups";
	final static String FIELD_VERSIONS = "versions";
	final static String FIELD_INSTALLED_VERSION = "installedVersion";
	final static String FIELD_INSTALLED_AS_MAIN_APPLICATION = "installedAsMainApplication";

    static Application create() {
        return new UdbApplication();
    }

    static Application create(int id) {
        return new UdbApplication(id, true);
    }

    static Application getById(int id) {
        return new UdbApplication(id, false);
    }

    static EntityBuilder<Application> getBuilder() {
        return new UdbApplication(0, false);
    }

    Instant getMetaCreationDate();

    Application setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    Application setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    Application setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    Application setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    Application setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    Application setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    Application setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    Application setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    Application setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    Application setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    Application setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    Application setMetaDeletedBy(int value);

    String getName();

    Application setName(String value);

    String getIcon();

    Application setIcon(String value);

    String getTitleKey();

    Application setTitleKey(String value);

    String getDescriptionKey();

    Application setDescriptionKey(String value);

    boolean getUnmanagedApplication();

    Application setUnmanagedApplication(boolean value);

    boolean isUnmanagedApplication();

    String getConfig();

    Application setConfig(String value);

    boolean getDarkTheme();

    Application setDarkTheme(boolean value);

    boolean isDarkTheme();

    List<ApplicationPerspective> getPerspectives();

    Application setPerspectives(List<ApplicationPerspective> value);

    int getPerspectivesCount();

    Application setPerspectives(ApplicationPerspective ... value);

    BitSet getPerspectivesAsBitSet();

    Application addPerspectives(List<ApplicationPerspective> value);

    Application addPerspectives(ApplicationPerspective ... value);

    Application removePerspectives(List<ApplicationPerspective> value);

    Application removePerspectives(ApplicationPerspective ... value);

    Application removeAllPerspectives();

    List<ApplicationPrivilegeGroup> getPrivilegeGroups();

    Application setPrivilegeGroups(List<ApplicationPrivilegeGroup> value);

    int getPrivilegeGroupsCount();

    Application setPrivilegeGroups(ApplicationPrivilegeGroup ... value);

    BitSet getPrivilegeGroupsAsBitSet();

    Application addPrivilegeGroups(List<ApplicationPrivilegeGroup> value);

    Application addPrivilegeGroups(ApplicationPrivilegeGroup ... value);

    Application removePrivilegeGroups(List<ApplicationPrivilegeGroup> value);

    Application removePrivilegeGroups(ApplicationPrivilegeGroup ... value);

    Application removeAllPrivilegeGroups();

    List<ApplicationVersion> getVersions();

    Application setVersions(List<ApplicationVersion> value);

    int getVersionsCount();

    Application setVersions(ApplicationVersion ... value);

    BitSet getVersionsAsBitSet();

    Application addVersions(List<ApplicationVersion> value);

    Application addVersions(ApplicationVersion ... value);

    Application removeVersions(List<ApplicationVersion> value);

    Application removeVersions(ApplicationVersion ... value);

    Application removeAllVersions();

    ApplicationVersion getInstalledVersion();

    Application setInstalledVersion(ApplicationVersion value);

    List<ManagedApplication> getInstalledAsMainApplication();

    Application setInstalledAsMainApplication(List<ManagedApplication> value);

    int getInstalledAsMainApplicationCount();

    Application setInstalledAsMainApplication(ManagedApplication ... value);

    BitSet getInstalledAsMainApplicationAsBitSet();

    Application addInstalledAsMainApplication(List<ManagedApplication> value);

    Application addInstalledAsMainApplication(ManagedApplication ... value);

    Application removeInstalledAsMainApplication(List<ManagedApplication> value);

    Application removeInstalledAsMainApplication(ManagedApplication ... value);

    Application removeAllInstalledAsMainApplication();


    static List<Application> getAll() {
        return UdbApplication.getAll();
    }

    static List<Application> sort(List<Application> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbApplication.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbApplication.getCount();
    }

    static ApplicationQuery filter() {
        return new UdbApplicationQuery();
    }
}

