package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface GroupFolderQuery extends Query<GroupFolder> {

    static GroupFolderQuery create() {
        return new UdbGroupFolderQuery();
    }

    GroupFolderQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    GroupFolderQuery parseFullTextFilter(String query, String... fieldNames);

	GroupFolderQuery metaCreationDate(NumericFilter filter);

	GroupFolderQuery orMetaCreationDate(NumericFilter filter);

	GroupFolderQuery metaCreatedBy(NumericFilter filter);

	GroupFolderQuery orMetaCreatedBy(NumericFilter filter);

	GroupFolderQuery metaModificationDate(NumericFilter filter);

	GroupFolderQuery orMetaModificationDate(NumericFilter filter);

	GroupFolderQuery metaModifiedBy(NumericFilter filter);

	GroupFolderQuery orMetaModifiedBy(NumericFilter filter);

	GroupFolderQuery metaDeletionDate(NumericFilter filter);

	GroupFolderQuery orMetaDeletionDate(NumericFilter filter);

	GroupFolderQuery metaDeletedBy(NumericFilter filter);

	GroupFolderQuery orMetaDeletedBy(NumericFilter filter);

	GroupFolderQuery filterGroup(GroupQuery query);

	GroupFolderQuery group(NumericFilter filter);

	GroupFolderQuery orGroup(NumericFilter filter);

	GroupFolderQuery name(TextFilter filter);

	GroupFolderQuery orName(TextFilter filter);

	GroupFolderQuery moderatorReadAccess(BooleanFilter filter);

	GroupFolderQuery orModeratorReadAccess(BooleanFilter filter);

	GroupFolderQuery moderatorWriteAccess(BooleanFilter filter);

	GroupFolderQuery orModeratorWriteAccess(BooleanFilter filter);

	GroupFolderQuery subjectTags(TextFilter filter);

	GroupFolderQuery orSubjectTags(TextFilter filter);

	GroupFolderQuery groupFolderType(EnumFilterType filterType, GroupFolderType ... enums);

	GroupFolderQuery orGroupFolderType(EnumFilterType filterType, GroupFolderType ... enums);

	GroupFolderQuery filterMessages(MessageQuery query);

	GroupFolderQuery messages(MultiReferenceFilterType type, Message ... value);

	GroupFolderQuery messagesCount(MultiReferenceFilterType type, int count);

	GroupFolderQuery messages(MultiReferenceFilter filter);

	GroupFolderQuery orMessages(MultiReferenceFilter filter);


    GroupFolderQuery andOr(GroupFolderQuery... queries);

    GroupFolderQuery customFilter(Function<GroupFolder, Boolean> customFilter);

    List<GroupFolder> execute();

    GroupFolder executeExpectSingleton();

    BitSet executeToBitSet();

    List<GroupFolder> execute(String sortFieldName, boolean ascending, String ... path);

    List<GroupFolder> execute(int startIndex, int length, Sorting sorting);

}

