package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface MessageQuery extends Query<Message> {

    static MessageQuery create() {
        return new UdbMessageQuery();
    }

    MessageQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    MessageQuery parseFullTextFilter(String query, String... fieldNames);

	MessageQuery metaCreationDate(NumericFilter filter);

	MessageQuery orMetaCreationDate(NumericFilter filter);

	MessageQuery metaCreatedBy(NumericFilter filter);

	MessageQuery orMetaCreatedBy(NumericFilter filter);

	MessageQuery metaModificationDate(NumericFilter filter);

	MessageQuery orMetaModificationDate(NumericFilter filter);

	MessageQuery metaModifiedBy(NumericFilter filter);

	MessageQuery orMetaModifiedBy(NumericFilter filter);

	MessageQuery metaDeletionDate(NumericFilter filter);

	MessageQuery orMetaDeletionDate(NumericFilter filter);

	MessageQuery metaDeletedBy(NumericFilter filter);

	MessageQuery orMetaDeletedBy(NumericFilter filter);

	MessageQuery messageRecipientType(EnumFilterType filterType, MessageRecipientType ... enums);

	MessageQuery orMessageRecipientType(EnumFilterType filterType, MessageRecipientType ... enums);

	MessageQuery filterPrivateRecipients(UserQuery query);

	MessageQuery privateRecipients(MultiReferenceFilterType type, User ... value);

	MessageQuery privateRecipientsCount(MultiReferenceFilterType type, int count);

	MessageQuery privateRecipients(MultiReferenceFilter filter);

	MessageQuery orPrivateRecipients(MultiReferenceFilter filter);

	MessageQuery filterGroupFolder(GroupFolderQuery query);

	MessageQuery groupFolder(NumericFilter filter);

	MessageQuery orGroupFolder(NumericFilter filter);

	MessageQuery filterApplicationFolder(ApplicationFolderQuery query);

	MessageQuery applicationFolder(NumericFilter filter);

	MessageQuery orApplicationFolder(NumericFilter filter);

	MessageQuery subject(TextFilter filter);

	MessageQuery orSubject(TextFilter filter);

	MessageQuery message(TextFilter filter);

	MessageQuery orMessage(TextFilter filter);

	MessageQuery messageType(EnumFilterType filterType, MessageType ... enums);

	MessageQuery orMessageType(EnumFilterType filterType, MessageType ... enums);

	MessageQuery file(FileFilter filter);

	MessageQuery orFile(FileFilter filter);

	MessageQuery filterAppointment(AppointmentQuery query);

	MessageQuery appointment(NumericFilter filter);

	MessageQuery orAppointment(NumericFilter filter);

	MessageQuery filterAppointmentSeries(AppointmentSeriesQuery query);

	MessageQuery appointmentSeries(NumericFilter filter);

	MessageQuery orAppointmentSeries(NumericFilter filter);


    MessageQuery andOr(MessageQuery... queries);

    MessageQuery customFilter(Function<Message, Boolean> customFilter);

    List<Message> execute();

    Message executeExpectSingleton();

    BitSet executeToBitSet();

    List<Message> execute(String sortFieldName, boolean ascending, String ... path);

    List<Message> execute(int startIndex, int length, Sorting sorting);

}

