package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface OrganizationUnit extends Entity<OrganizationUnit> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_NAME = "name";
	final static String FIELD_PARENT = "parent";
	final static String FIELD_CHILDREN = "children";
	final static String FIELD_TYPE = "type";
	final static String FIELD_ICON = "icon";
	final static String FIELD_ADDRESS = "address";
	final static String FIELD_USER_CONTAINER = "userContainer";

    static OrganizationUnit create() {
        return new UdbOrganizationUnit();
    }

    static OrganizationUnit create(int id) {
        return new UdbOrganizationUnit(id, true);
    }

    static OrganizationUnit getById(int id) {
        return new UdbOrganizationUnit(id, false);
    }

    static EntityBuilder<OrganizationUnit> getBuilder() {
        return new UdbOrganizationUnit(0, false);
    }

    Instant getMetaCreationDate();

    OrganizationUnit setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    OrganizationUnit setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    OrganizationUnit setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    OrganizationUnit setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    OrganizationUnit setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    OrganizationUnit setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    OrganizationUnit setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    OrganizationUnit setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    OrganizationUnit setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    OrganizationUnit setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    OrganizationUnit setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    OrganizationUnit setMetaDeletedBy(int value);

    TranslatableText getName();

    OrganizationUnit setName(TranslatableText value);

    OrganizationUnit getParent();

    OrganizationUnit setParent(OrganizationUnit value);

    List<OrganizationUnit> getChildren();

    OrganizationUnit setChildren(List<OrganizationUnit> value);

    int getChildrenCount();

    OrganizationUnit setChildren(OrganizationUnit ... value);

    BitSet getChildrenAsBitSet();

    OrganizationUnit addChildren(List<OrganizationUnit> value);

    OrganizationUnit addChildren(OrganizationUnit ... value);

    OrganizationUnit removeChildren(List<OrganizationUnit> value);

    OrganizationUnit removeChildren(OrganizationUnit ... value);

    OrganizationUnit removeAllChildren();

    OrganizationUnitType getType();

    OrganizationUnit setType(OrganizationUnitType value);

    String getIcon();

    OrganizationUnit setIcon(String value);

    Address getAddress();

    OrganizationUnit setAddress(Address value);

    UserContainer getUserContainer();

    OrganizationUnit setUserContainer(UserContainer value);


    static List<OrganizationUnit> getAll() {
        return UdbOrganizationUnit.getAll();
    }

    static List<OrganizationUnit> sort(List<OrganizationUnit> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbOrganizationUnit.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbOrganizationUnit.getCount();
    }

    static OrganizationUnitQuery filter() {
        return new UdbOrganizationUnitQuery();
    }
}

