package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbChatChannelQuery extends AbstractUdbQuery<ChatChannel> implements ChatChannelQuery {

    public UdbChatChannelQuery() {
        super(UdbChatChannel.table, ChatChannel.getBuilder());
    }

	@Override
	public ChatChannelQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbChatChannel.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public ChatChannelQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbChatChannel.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public ChatChannelQuery metaCreationDate(NumericFilter filter) {
		and(UdbChatChannel.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbChatChannel.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery metaCreatedBy(NumericFilter filter) {
		and(UdbChatChannel.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbChatChannel.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery metaModificationDate(NumericFilter filter) {
		and(UdbChatChannel.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbChatChannel.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery metaModifiedBy(NumericFilter filter) {
		and(UdbChatChannel.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbChatChannel.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery metaDeletionDate(NumericFilter filter) {
		and(UdbChatChannel.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbChatChannel.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery metaDeletedBy(NumericFilter filter) {
		and(UdbChatChannel.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbChatChannel.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery title(TextFilter filter) {
		and(UdbChatChannel.title.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery orTitle(TextFilter filter) {
		or(UdbChatChannel.title.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery filterChatMessages(ChatMessageQuery query) {
		UdbChatMessageQuery udbQuery = (UdbChatMessageQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbChatChannel.chatMessages, UdbChatMessage.chatChannel);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ChatChannelQuery chatMessages(MultiReferenceFilterType type, ChatMessage ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (ChatMessage value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbChatChannel.chatMessages.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery chatMessagesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbChatChannel.chatMessages.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery chatMessages(MultiReferenceFilter filter) {
		and(UdbChatChannel.chatMessages.createFilter(filter));
		return this;
	}

	@Override
	public ChatChannelQuery orChatMessages(MultiReferenceFilter filter) {
		or(UdbChatChannel.chatMessages.createFilter(filter));
		return this;
	}


	@Override
	public UdbChatChannelQuery andOr(ChatChannelQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public ChatChannelQuery customFilter(Function<ChatChannel, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(ChatChannel.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



