package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbLocalizationValueQuery extends AbstractUdbQuery<LocalizationValue> implements LocalizationValueQuery {

    public UdbLocalizationValueQuery() {
        super(UdbLocalizationValue.table, LocalizationValue.getBuilder());
    }

	@Override
	public LocalizationValueQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbLocalizationValue.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public LocalizationValueQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbLocalizationValue.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public LocalizationValueQuery metaCreationDate(NumericFilter filter) {
		and(UdbLocalizationValue.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbLocalizationValue.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery metaCreatedBy(NumericFilter filter) {
		and(UdbLocalizationValue.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbLocalizationValue.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery metaModificationDate(NumericFilter filter) {
		and(UdbLocalizationValue.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbLocalizationValue.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery metaModifiedBy(NumericFilter filter) {
		and(UdbLocalizationValue.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbLocalizationValue.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery metaDeletionDate(NumericFilter filter) {
		and(UdbLocalizationValue.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbLocalizationValue.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery metaDeletedBy(NumericFilter filter) {
		and(UdbLocalizationValue.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbLocalizationValue.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery filterLocalizationKey(LocalizationKeyQuery query) {
		UdbLocalizationKeyQuery udbQuery = (UdbLocalizationKeyQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbLocalizationValue.localizationKey, UdbLocalizationKey.localizationValues);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public LocalizationValueQuery localizationKey(NumericFilter filter) {
		and(UdbLocalizationValue.localizationKey.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orLocalizationKey(NumericFilter filter) {
		or(UdbLocalizationValue.localizationKey.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery language(TextFilter filter) {
		and(UdbLocalizationValue.language.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orLanguage(TextFilter filter) {
		or(UdbLocalizationValue.language.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery original(TextFilter filter) {
		and(UdbLocalizationValue.original.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orOriginal(TextFilter filter) {
		or(UdbLocalizationValue.original.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery machineTranslation(TextFilter filter) {
		and(UdbLocalizationValue.machineTranslation.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orMachineTranslation(TextFilter filter) {
		or(UdbLocalizationValue.machineTranslation.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery translation(TextFilter filter) {
		and(UdbLocalizationValue.translation.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orTranslation(TextFilter filter) {
		or(UdbLocalizationValue.translation.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery adminLocalOverride(TextFilter filter) {
		and(UdbLocalizationValue.adminLocalOverride.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orAdminLocalOverride(TextFilter filter) {
		or(UdbLocalizationValue.adminLocalOverride.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery adminKeyOverride(TextFilter filter) {
		and(UdbLocalizationValue.adminKeyOverride.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orAdminKeyOverride(TextFilter filter) {
		or(UdbLocalizationValue.adminKeyOverride.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery currentDisplayValue(TextFilter filter) {
		and(UdbLocalizationValue.currentDisplayValue.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orCurrentDisplayValue(TextFilter filter) {
		or(UdbLocalizationValue.currentDisplayValue.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery notes(TextFilter filter) {
		and(UdbLocalizationValue.notes.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery orNotes(TextFilter filter) {
		or(UdbLocalizationValue.notes.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationValueQuery machineTranslationState(EnumFilterType filterType, MachineTranslationState... enums) {
		and(UdbLocalizationValue.machineTranslationState.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public LocalizationValueQuery orMachineTranslationState(EnumFilterType filterType, MachineTranslationState... enums) {
		or(UdbLocalizationValue.machineTranslationState.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public LocalizationValueQuery translationState(EnumFilterType filterType, TranslationState... enums) {
		and(UdbLocalizationValue.translationState.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public LocalizationValueQuery orTranslationState(EnumFilterType filterType, TranslationState... enums) {
		or(UdbLocalizationValue.translationState.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public LocalizationValueQuery translationVerificationState(EnumFilterType filterType, TranslationVerificationState... enums) {
		and(UdbLocalizationValue.translationVerificationState.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public LocalizationValueQuery orTranslationVerificationState(EnumFilterType filterType, TranslationVerificationState... enums) {
		or(UdbLocalizationValue.translationVerificationState.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}


	@Override
	public UdbLocalizationValueQuery andOr(LocalizationValueQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public LocalizationValueQuery customFilter(Function<LocalizationValue, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(LocalizationValue.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



