package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbUserGroupMembershipQuery extends AbstractUdbQuery<UserGroupMembership> implements UserGroupMembershipQuery {

    public UdbUserGroupMembershipQuery() {
        super(UdbUserGroupMembership.table, UserGroupMembership.getBuilder());
    }

	@Override
	public UserGroupMembershipQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbUserGroupMembership.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public UserGroupMembershipQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbUserGroupMembership.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public UserGroupMembershipQuery filterGroup(GroupQuery query) {
		UdbGroupQuery udbQuery = (UdbGroupQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUserGroupMembership.group, UdbGroup.userMemberships);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserGroupMembershipQuery group(NumericFilter filter) {
		and(UdbUserGroupMembership.group.createFilter(filter));
		return this;
	}

	@Override
	public UserGroupMembershipQuery orGroup(NumericFilter filter) {
		or(UdbUserGroupMembership.group.createFilter(filter));
		return this;
	}

	@Override
	public UserGroupMembershipQuery filterUser(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUserGroupMembership.user, UdbUser.allGroupMemberships);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserGroupMembershipQuery user(NumericFilter filter) {
		and(UdbUserGroupMembership.user.createFilter(filter));
		return this;
	}

	@Override
	public UserGroupMembershipQuery orUser(NumericFilter filter) {
		or(UdbUserGroupMembership.user.createFilter(filter));
		return this;
	}

	@Override
	public UserGroupMembershipQuery groupMembershipRole(EnumFilterType filterType, GroupMembershipRole... enums) {
		and(UdbUserGroupMembership.groupMembershipRole.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public UserGroupMembershipQuery orGroupMembershipRole(EnumFilterType filterType, GroupMembershipRole... enums) {
		or(UdbUserGroupMembership.groupMembershipRole.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public UserGroupMembershipQuery membershipRejected(BooleanFilter filter) {
		and(UdbUserGroupMembership.membershipRejected.createFilter(filter));
		return this;
	}

	@Override
	public UserGroupMembershipQuery orMembershipRejected(BooleanFilter filter) {
		or(UdbUserGroupMembership.membershipRejected.createFilter(filter));
		return this;
	}

	@Override
	public UserGroupMembershipQuery groupMembershipNotificationSetting(EnumFilterType filterType, GroupMembershipNotificationSetting... enums) {
		and(UdbUserGroupMembership.groupMembershipNotificationSetting.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public UserGroupMembershipQuery orGroupMembershipNotificationSetting(EnumFilterType filterType, GroupMembershipNotificationSetting... enums) {
		or(UdbUserGroupMembership.groupMembershipNotificationSetting.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}


	@Override
	public UdbUserGroupMembershipQuery andOr(UserGroupMembershipQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public UserGroupMembershipQuery customFilter(Function<UserGroupMembership, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(UserGroupMembership.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



