/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.applications;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.system.utils.ApplicationUiUtils;
import org.teamapps.application.server.ui.localize.LocalizationTranslationKeyField;
import org.teamapps.application.server.ui.localize.LocalizationUiUtils;
import org.teamapps.application.tools.EntityListModelBuilder;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.RecordComboBox;
import org.teamapps.application.ux.form.FormPanel;
import org.teamapps.application.ux.form.FormWindow;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPerspective;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationGroup;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.Fields;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.linkbutton.LinkButton;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class ApplicationProvisioningPerspective
extends AbstractManagedApplicationPerspective {
    private final PerspectiveSessionData perspectiveSessionData;
    private final UserSessionData userSessionData;
    private final TwoWayBindableValue<ManagedApplication> selectedApplication = TwoWayBindableValue.create();

    public ApplicationProvisioningPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.createUi();
    }

    private void createUi() {
        View applicationsView = View.createView((String)"center", (Icon)ApplicationIcons.INSTALL, (String)this.getLocalized("applicationProvisioning.provisionedApplications"), null);
        View applicationDetailsView = View.createView((String)"right", (Icon)ApplicationIcons.INSTALL, (String)this.getLocalized("applicationProvisioning.provisionedApplication"), null);
        applicationDetailsView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        EntityModelBuilder applicationModelBuilder = new EntityModelBuilder(ManagedApplication::filter, this.getApplicationInstanceData());
        Table applicationsTable = applicationModelBuilder.createTemplateFieldTableList((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES, PropertyProviders.createManagedApplicationPropertyProvider(this.userSessionData), 60);
        applicationsTable.setStripedRows(false);
        applicationsView.setComponent((Component)applicationsTable);
        applicationModelBuilder.onDataChanged.fire();
        applicationModelBuilder.attachSearchField(applicationsView);
        applicationModelBuilder.attachViewCountHandler(applicationsView, () -> this.getLocalized("applicationProvisioning.provisionedApplications"));
        applicationModelBuilder.onSelectedRecordChanged.addListener(arg_0 -> this.selectedApplication.set(arg_0));
        this.getPerspective().addView(applicationsView);
        this.getPerspective().addView(applicationDetailsView);
        ResponsiveForm applicationForm = new ResponsiveForm(100, 150, 0);
        ResponsiveFormLayout formLayout = applicationForm.addResponsiveFormLayout(400);
        ComboBox<Application> applicationComboBox = ApplicationUiUtils.createApplicationComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, this.userSessionData);
        ComboBox<OrganizationField> organizationFieldCombo = OrganizationUtils.createOrganizationFieldCombo(this.getApplicationInstanceData());
        ComboBox iconComboBox = ApplicationIcons.createIconComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_SINGLE_LINE, (boolean)true);
        iconComboBox.setShowClearButton(true);
        LocalizationTranslationKeyField titleKeyField = new LocalizationTranslationKeyField(this.getLocalized("applications.createNewTitle"), this.getApplicationInstanceData(), () -> applicationComboBox.getValue());
        LocalizationTranslationKeyField descriptionKeyField = new LocalizationTranslationKeyField(this.getLocalized("applications.createNewDescription"), this.getApplicationInstanceData(), () -> applicationComboBox.getValue());
        CheckBox darkThemeCheckBox = new CheckBox(this.getLocalized("applications.darkTheme"));
        CheckBox toolbarAppMenuCheckbox = new CheckBox(this.getLocalized("applications.useToolbarApplicationMenu"));
        EntityListModelBuilder perspectiveModelBuilder = new EntityListModelBuilder(this.getApplicationInstanceData());
        Table perspectivesList = perspectiveModelBuilder.createTable();
        perspectivesList.setDisplayAsList(true);
        perspectivesList.setForceFitWidth(true);
        perspectivesList.setRowHeight(26);
        TemplateField perspectiveColumnField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPerspectivePropertyProvider(this.userSessionData));
        TemplateField applicationColumnField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createApplicationPropertyProvider(this.userSessionData));
        perspectivesList.addColumn(new TableColumn("perspective", this.getLocalized("applications.perspective"), (AbstractField)perspectiveColumnField));
        perspectivesList.addColumn(new TableColumn("application", this.getLocalized("applications.application"), (AbstractField)applicationColumnField));
        perspectivesList.setPropertyExtractor((record, propertyName) -> switch (propertyName) {
            case "perspective" -> record;
            case "application" -> {
                if (record.getApplicationPerspective() != null) {
                    yield record.getApplicationPerspective().getApplication();
                }
                yield null;
            }
            default -> null;
        });
        perspectivesList.setStripedRows(false);
        FormPanel formPanel = new FormPanel(this.getApplicationInstanceData());
        formPanel.setTable(perspectivesList, true, true, true);
        formPanel.addButtonGroup();
        ToolbarButton moveUpButton = formPanel.addButton(ApplicationIcons.NAVIGATE_UP, this.getLocalized("applications.moveUp"));
        ToolbarButton moveDownButton = formPanel.addButton(ApplicationIcons.NAVIGATE_DOWN, this.getLocalized("applications.moveDown"));
        CheckBox hideApplicationCheckBox = new CheckBox(this.getLocalized("org.teamapps.dictionary.hide"));
        ComboBox<ManagedApplicationGroup> applicationGroupComboBox = ApplicationUiUtils.createApplicationGroupComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, this.getApplicationInstanceData());
        Arrays.asList(applicationComboBox, iconComboBox, titleKeyField.getKeyDisplayField(), descriptionKeyField.getKeyDisplayField(), applicationGroupComboBox).forEach(f -> f.setRequired(true));
        formLayout.addSection().setDrawHeaderLine(false).setCollapsible(false);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.mainApplication"), applicationComboBox);
        formLayout.addLabelAndComponent(null, this.getLocalized("org.teamapps.dictionary.hidden"), (Component)hideApplicationCheckBox);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.organizationField"), organizationFieldCombo);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.applicationIcon"), (Component)iconComboBox);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.appTitle"), titleKeyField.getSelectionField());
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.appTitle"), titleKeyField.getKeyDisplayField());
        formLayout.addLabelAndComponent(null, null, (Component)titleKeyField.getKeyLinkButton());
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.appDescription"), descriptionKeyField.getSelectionField());
        formLayout.addLabelAndComponent(null, null, (Component)descriptionKeyField.getKeyLinkButton());
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.darkTheme"), (Component)darkThemeCheckBox);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.toolbarAppMenu"), (Component)toolbarAppMenuCheckbox);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.perspectives"), (Component)formPanel.getPanel());
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.applicationGroup"), applicationGroupComboBox);
        ToolbarButtonGroup buttonGroup = applicationDetailsView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton addApplicationButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ADD, (String)this.getLocalized("applications.addApplication"), (String)this.getLocalized("applications.addApplication.desc")));
        buttonGroup = applicationDetailsView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton saveApplicationButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.FLOPPY_DISK, (String)this.getLocalized("org.teamapps.dictionary.saveChanges")));
        formPanel.getAddButton().onClick.addListener(() -> this.showPerspectiveFormWindow(null, (EntityListModelBuilder<ManagedApplicationPerspective>)perspectiveModelBuilder));
        formPanel.getEditButton().onClick.addListener(() -> this.showPerspectiveFormWindow((ManagedApplicationPerspective)perspectivesList.getSelectedRecord(), (EntityListModelBuilder<ManagedApplicationPerspective>)perspectiveModelBuilder));
        formPanel.getDeleteButton().onClick.addListener(() -> perspectiveModelBuilder.removeRecord((Object)((ManagedApplicationPerspective)perspectivesList.getSelectedRecord())));
        addApplicationButton.onClick.addListener(() -> this.selectedApplication.set((Object)ManagedApplication.create()));
        saveApplicationButton.onClick.addListener(() -> {
            ManagedApplication application = (ManagedApplication)this.selectedApplication.get();
            if (application == null) {
                return;
            }
            if (Fields.validateAll((AbstractField[])new AbstractField[]{applicationComboBox, iconComboBox, titleKeyField.getSelectionField(), descriptionKeyField.getSelectionField(), applicationGroupComboBox}) && (!perspectiveModelBuilder.getRecords().isEmpty() || application.isSingleApplication() || application.getMainApplication().isUnmanagedApplication())) {
                Application mainApplication = (Application)applicationComboBox.getValue();
                application.setMainApplication(mainApplication);
                application.setHidden((Boolean)hideApplicationCheckBox.getValue());
                application.setOrganizationField((OrganizationField)organizationFieldCombo.getValue());
                application.setIcon(mainApplication.getIcon().equals(IconUtils.encodeNoStyle((Icon)((Icon)iconComboBox.getValue()))) ? null : IconUtils.encodeNoStyle((Icon)((Icon)iconComboBox.getValue())));
                application.setTitleKey(mainApplication.getTitleKey().equals(titleKeyField.getKey()) ? null : titleKeyField.getKey());
                application.setDescriptionKey(mainApplication.getDescriptionKey().equals(descriptionKeyField.getKey()) ? null : descriptionKeyField.getKey());
                application.setDarkTheme((Boolean)darkThemeCheckBox.getValue());
                application.setToolbarApplicationMenu((Boolean)toolbarAppMenuCheckbox.getValue());
                application.setPerspectives(perspectiveModelBuilder.getRecords());
                application.setApplicationGroup((ManagedApplicationGroup)applicationGroupComboBox.getValue());
                application.save();
                int pos = 0;
                for (ManagedApplicationPerspective perspective : perspectiveModelBuilder.getRecords()) {
                    perspective.setListingPosition(pos++).save();
                }
                applicationModelBuilder.onDataChanged.fire();
                UiUtils.showSaveNotification((boolean)true, (ApplicationInstanceData)this.getApplicationInstanceData());
            } else {
                UiUtils.showSaveNotification((boolean)false, (ApplicationInstanceData)this.getApplicationInstanceData());
            }
        });
        moveUpButton.onClick.addListener(() -> this.changePerspectiveOrder((EntityListModelBuilder<ManagedApplicationPerspective>)perspectiveModelBuilder, (Table<ManagedApplicationPerspective>)perspectivesList, true));
        moveDownButton.onClick.addListener(() -> this.changePerspectiveOrder((EntityListModelBuilder<ManagedApplicationPerspective>)perspectiveModelBuilder, (Table<ManagedApplicationPerspective>)perspectivesList, false));
        applicationComboBox.onValueChanged.addListener(app -> {
            iconComboBox.setValue(app != null ? IconUtils.decodeIcon((String)app.getIcon()) : null);
            titleKeyField.setKey(app != null ? app.getTitleKey() : null);
            descriptionKeyField.setKey(app != null ? app.getDescriptionKey() : null);
            if (this.selectedApplication.get() != null && !((ManagedApplication)this.selectedApplication.get()).isStored()) {
                List perspectives = app.getPerspectives().stream().filter(ApplicationPerspective::getAutoProvision).map(p -> ManagedApplicationPerspective.create().setApplicationPerspective((ApplicationPerspective)p)).collect(Collectors.toList());
                perspectiveModelBuilder.setRecords(perspectives);
            }
        });
        this.selectedApplication.onChanged().addListener(app -> {
            applicationComboBox.setValue((Object)app.getMainApplication());
            hideApplicationCheckBox.setValue((Object)app.getHidden());
            organizationFieldCombo.setValue((Object)app.getOrganizationField());
            iconComboBox.setValue(app.getIcon() != null ? IconUtils.decodeIcon((String)app.getIcon()) : (app.getMainApplication() != null ? IconUtils.decodeIcon((String)app.getMainApplication().getIcon()) : null));
            titleKeyField.setKey(app.getTitleKey() != null ? app.getTitleKey() : (app.getMainApplication() != null ? app.getMainApplication().getTitleKey() : null));
            descriptionKeyField.setKey(app.getDescriptionKey() != null ? app.getDescriptionKey() : (app.getMainApplication() != null ? app.getMainApplication().getDescriptionKey() : null));
            darkThemeCheckBox.setValue((Object)app.getDarkTheme());
            toolbarAppMenuCheckbox.setValue((Object)app.getToolbarApplicationMenu());
            perspectiveModelBuilder.setRecords(app.getPerspectives().stream().filter(perspective -> perspective.getApplicationPerspective() != null).sorted(Comparator.comparingInt(ManagedApplicationPerspective::getListingPosition)).collect(Collectors.toList()));
            applicationGroupComboBox.setValue((Object)app.getApplicationGroup());
        });
        applicationDetailsView.setComponent((Component)applicationForm);
        this.selectedApplication.set((Object)ManagedApplication.create());
    }

    private void showPerspectiveFormWindow(ManagedApplicationPerspective managedApplicationPerspective, EntityListModelBuilder<ManagedApplicationPerspective> perspectiveModelBuilder) {
        ManagedApplicationPerspective perspective = managedApplicationPerspective != null ? managedApplicationPerspective : ManagedApplicationPerspective.create();
        FormWindow formWindow = new FormWindow(ApplicationIcons.WINDOWS, this.getLocalized("applications.perspective"), this.getApplicationInstanceData());
        formWindow.addSaveButton();
        formWindow.addCancelButton();
        formWindow.addSection();
        ComboBox<Application> applicationComboBox = ApplicationUiUtils.createApplicationComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, this.userSessionData);
        RecordComboBox applicationsPerspectiveCombo = new RecordComboBox(PropertyProviders.createApplicationPerspectivePropertyProvider(this.userSessionData), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        ComboBox iconComboBox = ApplicationIcons.createIconComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_SINGLE_LINE, (boolean)true);
        ComboBox<String> titleKeyCombo = LocalizationUiUtils.createLocalizationKeyCombo((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, (ApplicationLocalizationProvider)this.getApplicationInstanceData(), () -> applicationComboBox.getValue());
        LinkButton crateTitleKeyButton = new LinkButton(this.getLocalized("applications.createNewTitle"));
        ComboBox<String> descriptionKeyCombo = LocalizationUiUtils.createLocalizationKeyCombo((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, (ApplicationLocalizationProvider)this.getApplicationInstanceData(), () -> applicationComboBox.getValue());
        LinkButton createDescriptionKeyButton = new LinkButton(this.getLocalized("applications.createNewDescription"));
        CheckBox toolbarPerspectiveMenuCheckBox = new CheckBox(this.getLocalized("applications.useToolbarPerspectiveMenu"));
        formWindow.addField(this.getLocalized("applications.application"), applicationComboBox);
        formWindow.addField(this.getLocalized("applications.perspective"), (Component)applicationsPerspectiveCombo);
        formWindow.addField(this.getLocalized("applications.perspectiveIcon"), (Component)iconComboBox);
        formWindow.addField(this.getLocalized("applications.perspectiveTitle"), titleKeyCombo);
        formWindow.addField(null, (Component)crateTitleKeyButton);
        formWindow.addField(this.getLocalized("applications.perspectiveDescription"), descriptionKeyCombo);
        formWindow.addField(null, (Component)createDescriptionKeyButton);
        formWindow.addField(this.getLocalized("applications.toolbarPerspectiveMenu"), (Component)toolbarPerspectiveMenuCheckBox);
        if (managedApplicationPerspective != null) {
            applicationComboBox.setValue((Object)perspective.getApplicationPerspective().getApplication());
            applicationsPerspectiveCombo.setValue((Object)perspective.getApplicationPerspective());
            iconComboBox.setValue((Object)(perspective.getIconOverride() != null ? IconUtils.decodeIcon((String)perspective.getIconOverride()) : IconUtils.decodeIcon((String)perspective.getApplicationPerspective().getIcon())));
            titleKeyCombo.setValue((Object)(perspective.getTitleKeyOverride() != null ? perspective.getTitleKeyOverride() : perspective.getApplicationPerspective().getTitleKey()));
            descriptionKeyCombo.setValue((Object)(perspective.getDescriptionKeyOverride() != null ? perspective.getDescriptionKeyOverride() : perspective.getApplicationPerspective().getDescriptionKey()));
            toolbarPerspectiveMenuCheckBox.setValue((Object)perspective.getToolbarPerspectiveMenu());
        }
        Arrays.asList(applicationsPerspectiveCombo, iconComboBox, titleKeyCombo, descriptionKeyCombo, applicationsPerspectiveCombo).forEach(f -> f.setRequired(true));
        applicationComboBox.onValueChanged.addListener(app -> applicationsPerspectiveCombo.setRecords(app.getPerspectives()));
        applicationsPerspectiveCombo.onValueChanged.addListener(p -> {
            iconComboBox.setValue(p != null ? IconUtils.decodeIcon((String)p.getIcon()) : null);
            titleKeyCombo.setValue((Object)(p != null ? p.getTitleKey() : null));
            descriptionKeyCombo.setValue((Object)(p != null ? p.getDescriptionKey() : null));
        });
        formWindow.getSaveButton().onClick.addListener(() -> {
            if (Fields.validateAll((AbstractField[])new AbstractField[]{applicationsPerspectiveCombo, iconComboBox, titleKeyCombo, descriptionKeyCombo, applicationsPerspectiveCombo})) {
                ApplicationPerspective applicationPerspective = (ApplicationPerspective)applicationsPerspectiveCombo.getValue();
                perspective.setApplicationPerspective(applicationPerspective);
                perspective.setIconOverride(applicationPerspective.getIcon().equals(iconComboBox.getValue()) ? null : IconUtils.encodeNoStyle((Icon)((Icon)iconComboBox.getValue())));
                perspective.setTitleKeyOverride(applicationPerspective.getTitleKey().equals(titleKeyCombo.getValue()) ? null : (String)titleKeyCombo.getValue());
                perspective.setDescriptionKeyOverride(applicationPerspective.getDescriptionKey().equals(descriptionKeyCombo.getValue()) ? null : (String)descriptionKeyCombo.getValue());
                perspective.setToolbarPerspectiveMenu((Boolean)toolbarPerspectiveMenuCheckBox.getValue());
                perspective.save();
                if (managedApplicationPerspective == null) {
                    perspectiveModelBuilder.addRecord((Object)perspective);
                }
                formWindow.close();
            }
        });
        formWindow.show();
    }

    private void changePerspectiveOrder(EntityListModelBuilder<ManagedApplicationPerspective> perspectiveModelBuilder, Table<ManagedApplicationPerspective> perspectivesList, boolean moveUp) {
        ManagedApplicationPerspective selectedPerspective = (ManagedApplicationPerspective)perspectivesList.getSelectedRecord();
        if (selectedPerspective != null) {
            List perspectives = perspectiveModelBuilder.getRecords();
            int position = 0;
            int changeValue = moveUp ? -5 : 15;
            for (ManagedApplicationPerspective perspective : perspectives) {
                if (perspective.equals(selectedPerspective)) {
                    perspective.setListingPosition(position + changeValue);
                    continue;
                }
                perspective.setListingPosition(position += 10);
            }
            perspectiveModelBuilder.setRecords(perspectives.stream().sorted(Comparator.comparingInt(ManagedApplicationPerspective::getListingPosition)).collect(Collectors.toList()));
        }
    }
}

