/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.translations;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.translations.TranslationMode;
import org.teamapps.application.server.controlcenter.translations.TranslationUtils;
import org.teamapps.application.server.controlcenter.translations.TranslationWorkState;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.icons.composite.CompositeIcon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationTopic;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.model.controlcenter.TranslationVerificationState;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.field.MultiLineTextField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class MachineTranslationsPerspective
extends AbstractManagedApplicationPerspective {
    private final PerspectiveSessionData perspectiveSessionData;
    private final UserSessionData userSessionData;
    private final TwoWayBindableValue<LocalizationKey> selectedKey = TwoWayBindableValue.create();
    private String currentLanguage;
    private String currentTemplate1;
    private String currentTemplate2;
    private boolean language1Visible;
    private boolean language2Visible;
    private boolean machineTranslationVisible;

    public MachineTranslationsPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.createUi();
    }

    private void createUi() {
        View localizationKeyView = View.createView((String)"center", (Icon)ApplicationIcons.EARTH_LINK, (String)this.getLocalized("machineTranslation.title"), null);
        View translationView = View.createView((String)"right", (Icon)ApplicationIcons.EARTH_LINK, (String)this.getLocalized("machineTranslation.title"), null);
        localizationKeyView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        translationView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        ToolbarButtonGroup buttonGroup = localizationKeyView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton overViewButtonOn = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.SPELL_CHECK, (Icon)ApplicationIcons.CHECKBOX), (String)this.getLocalized("translations.overView"), (String)this.getLocalized("translations.showOverView")));
        ToolbarButton overViewButtonOff = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.SPELL_CHECK, (Icon)ApplicationIcons.DELETE), (String)this.getLocalized("translations.overView"), (String)this.getLocalized("translations.hideOverView")));
        overViewButtonOn.setVisible(false);
        buttonGroup = translationView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton previousButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.NAVIGATE_LEFT, (String)this.getLocalized("org.teamapps.dictionary.previous")));
        ToolbarButton nextButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.NAVIGATE_RIGHT, (String)this.getLocalized("org.teamapps.dictionary.next")));
        ComboBox languageCombo = Language.createComboBox((ApplicationLocalizationProvider)this.getApplicationInstanceData());
        EntityModelBuilder keyModelBuilder = new EntityModelBuilder(() -> this.isAppFilter() ? LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)this.getMainApplication().getId())) : LocalizationKey.filter(), this.getApplicationInstanceData());
        keyModelBuilder.updateModels();
        keyModelBuilder.attachSearchField(localizationKeyView);
        keyModelBuilder.attachViewCountHandler(localizationKeyView, () -> this.getLocalized("translations.overView"));
        keyModelBuilder.onSelectedRecordChanged.addListener(key -> this.selectedKey.set(key));
        Table keyTable = keyModelBuilder.createTable();
        keyTable.setDisplayAsList(true);
        keyTable.setStripedRows(false);
        keyTable.setCssStyle("background-color", "white");
        keyTable.setCssStyle("border-top", "1px solid " + Color.MATERIAL_GREY_400.toHtmlColorString());
        keyTable.setRowHeight(28);
        keyTable.setPropertyProvider((key, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Map<String, LocalizationValue> valueMap = TranslationUtils.getValueMap(key);
            map.put("key", key);
            map.put("language", valueMap.get(this.currentLanguage));
            map.put("status", valueMap.get(this.currentLanguage));
            map.put("template1", valueMap.get(this.currentTemplate1));
            map.put("template2", valueMap.get(this.currentTemplate2));
            return map;
        });
        TemplateField<LocalizationValue> template1Column = this.createLocalizationValueTemplateField(true, false);
        TemplateField<LocalizationValue> template2Column = this.createLocalizationValueTemplateField(true, false);
        TemplateField<LocalizationValue> languageColumn = this.createLocalizationValueTemplateField(false, false);
        TemplateField<LocalizationValue> stateColumn = this.createLocalizationValueTemplateField(true, true);
        keyTable.addColumn(new TableColumn("template1", this.getLocalized("translations.template1"), template1Column));
        keyTable.addColumn(new TableColumn("template2", this.getLocalized("translations.template2"), template2Column));
        keyTable.addColumn(new TableColumn("language", this.getLocalized("translations.language"), languageColumn));
        keyTable.addColumn(new TableColumn("status", this.getLocalized("translations.status"), stateColumn));
        Function<String, String> languageByTableFieldNameFunction = field -> switch (field) {
            case "template1" -> this.currentTemplate1;
            case "template2" -> this.currentTemplate2;
            case "language" -> this.currentLanguage;
            default -> null;
        };
        keyModelBuilder.setCustomFieldSorter(fieldName -> {
            String language = (String)languageByTableFieldNameFunction.apply((String)fieldName);
            if (language != null) {
                return (k1, k2) -> TranslationUtils.getDisplayValueNonNull(k1, language).compareToIgnoreCase(TranslationUtils.getDisplayValueNonNull(k2, language));
            }
            return null;
        });
        localizationKeyView.setComponent((Component)keyTable);
        TemplateField<LocalizationValue> template1HeaderField = this.createLocalizationValueHeaderField(true);
        TemplateField<LocalizationValue> template2HeaderField = this.createLocalizationValueHeaderField(true);
        TemplateField<LocalizationValue> machineTranslationHeaderField = this.createLocalizationValueHeaderField(true);
        TemplateField<LocalizationValue> translationHeaderField = this.createLocalizationValueHeaderField(true);
        DisplayField template1ValueField = new DisplayField(true, false);
        DisplayField template2ValueField = new DisplayField(true, false);
        DisplayField machineTranslationValueField = new DisplayField(true, false);
        MultiLineTextField translationField = new MultiLineTextField();
        translationField.setCssStyle("height", "100px");
        MultiLineTextField proofReadNotesField = new MultiLineTextField();
        proofReadNotesField.setCssStyle("height", "100px");
        template1ValueField.setCssStyle(".field-border", "border-color", "#ec9a1a");
        template1ValueField.setCssStyle(".field-border-glow", "box-shadow", "0 0 3px 0 #ec9a1a");
        ResponsiveForm form = new ResponsiveForm(120, 120, 0);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(500);
        formLayout.addSection(null, this.getLocalized("translations.template1")).setCollapsible(false).setDrawHeaderLine(false).setHideWhenNoVisibleFields(true);
        formLayout.addComponent(0, 0, template1HeaderField);
        formLayout.addComponent(0, 1, (Component)template1ValueField);
        formLayout.addSection(null, this.getLocalized("translations.template2")).setCollapsible(false).setDrawHeaderLine(true).setHideWhenNoVisibleFields(true);
        formLayout.addComponent(0, 0, template2HeaderField);
        formLayout.addComponent(0, 1, (Component)template2ValueField);
        formLayout.addSection(null, this.getLocalized("translations.automaticTranslation")).setCollapsible(false).setDrawHeaderLine(true).setHideWhenNoVisibleFields(true);
        formLayout.addComponent(0, 0, machineTranslationHeaderField);
        formLayout.addComponent(0, 1, (Component)machineTranslationValueField);
        formLayout.addSection(null, this.getLocalized("translations.translation")).setCollapsible(false).setDrawHeaderLine(true).setHideWhenNoVisibleFields(true);
        formLayout.addComponent(0, 0, translationHeaderField);
        formLayout.addComponent(0, 1, (Component)translationField);
        formLayout.addSection(null, this.getLocalized("translations.mode.proofread")).setCollapsible(false).setDrawHeaderLine(true).setHideWhenNoVisibleFields(true);
        formLayout.addLabelAndField(null, this.getLocalized("translations.errorNotes"), (AbstractField)proofReadNotesField);
        formLayout.addSection(null, this.getLocalized("translations.administration")).setCollapsible(false).setDrawHeaderLine(true).setHideWhenNoVisibleFields(true);
        translationView.setComponent((Component)form);
    }

    private TemplateField<LocalizationValue> createLocalizationValueHeaderField(boolean skipState) {
        TemplateField templateField = new TemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        templateField.setPropertyProvider((value, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (value == null) {
                return map;
            }
            Language language = Language.getLanguageByIsoCode((String)value.getLanguage());
            map.put("icon", language.getIcon());
            Object title = language.getLanguageLocalized((ApplicationLocalizationProvider)this.getApplicationInstanceData());
            if (!skipState) {
                title = (String)title + " (" + this.getLocalizationStateText((LocalizationValue)value) + ")";
            }
            map.put("caption", title);
            return map;
        });
        return templateField;
    }

    private TemplateField<LocalizationValue> createLocalizationValueTemplateField(boolean withStateIcon, boolean withStateText) {
        TemplateField templateField = new TemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        templateField.setPropertyProvider((value, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (value == null) {
                return map;
            }
            if (withStateIcon) {
                map.put("icon", this.getLocalizationStateIcon((LocalizationValue)value));
            }
            if (withStateText) {
                map.put("caption", this.getLocalizationStateText((LocalizationValue)value));
            } else {
                map.put("caption", value.getCurrentDisplayValue());
            }
            return map;
        });
        return templateField;
    }

    private Icon getLocalizationStateIcon(LocalizationValue value) {
        if (value == null) {
            return null;
        }
        return switch (value.getTranslationVerificationState()) {
            case TranslationVerificationState.VERIFICATION_REQUESTED -> ApplicationIcons.CHECKS;
            case TranslationVerificationState.OK -> ApplicationIcons.OK;
            case TranslationVerificationState.CORRECTIONS_REQUIRED -> ApplicationIcons.SIGN_WARNING;
            default -> {
                switch (value.getTranslationState()) {
                    case TRANSLATION_REQUESTED: {
                        yield ApplicationIcons.BRIEFCASE;
                    }
                    case UNCLEAR: {
                        yield ApplicationIcons.QUESTION;
                    }
                    case NOT_NECESSARY: {
                        yield ApplicationIcons.OK;
                    }
                }
                yield ApplicationIcons.FOLDER;
            }
        };
    }

    private String getLocalizationStateText(LocalizationValue value) {
        if (value == null) {
            return null;
        }
        return switch (value.getTranslationVerificationState()) {
            case TranslationVerificationState.VERIFICATION_REQUESTED -> this.getLocalized(TranslationWorkState.VERIFICATION_REQUIRED.getTranslationKey());
            case TranslationVerificationState.OK -> this.getLocalized(TranslationWorkState.VERIFIED.getTranslationKey());
            case TranslationVerificationState.CORRECTIONS_REQUIRED -> this.getLocalized(TranslationWorkState.CORRECTIONS_REQUIRED.getTranslationKey());
            default -> {
                switch (value.getTranslationState()) {
                    case TRANSLATION_REQUESTED: {
                        yield this.getLocalized(TranslationWorkState.TRANSLATION_REQUIRED.getTranslationKey());
                    }
                    case UNCLEAR: {
                        yield this.getLocalized(TranslationWorkState.UNCLEAR.getTranslationKey());
                    }
                    case NOT_NECESSARY: {
                        yield this.getLocalized(TranslationWorkState.TRANSLATION_NOT_NECESSARY.getTranslationKey());
                    }
                }
                yield "?";
            }
        };
    }

    private ComboBox<TranslationWorkState> createWorkStateComboBox() {
        PropertyExtractor propertyExtractor = (workState, propertyName) -> switch (propertyName) {
            case "icon" -> workState.getIcon();
            case "caption" -> this.getLocalized(workState.getTranslationKey());
            default -> null;
        };
        ComboBox comboBox = ComboBoxUtils.createRecordComboBox(Arrays.asList(TranslationWorkState.values()), (PropertyProvider)propertyExtractor, (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        return comboBox;
    }

    private ComboBox<LocalizationTopic> createTopicComboBox() {
        PropertyProvider<Application> applicationPropertyProvider = PropertyProviders.createApplicationPropertyProvider(this.userSessionData);
        PropertyProvider propertyProvider = (localizationTopic, propertyName) -> {
            HashMap map = new HashMap();
            if (localizationTopic == null) {
                return map;
            }
            if (localizationTopic.getApplication() != null) {
                Map values = applicationPropertyProvider.getValues((Object)localizationTopic.getApplication(), Collections.emptyList());
                map.put("icon", values.get("icon"));
                map.put("caption", values.get("caption"));
            } else {
                map.put("icon", localizationTopic.getIcon() != null ? IconUtils.decodeIcon((String)localizationTopic.getIcon()) : ApplicationIcons.TAGS);
                map.put("caption", localizationTopic.getTitle());
            }
            return map;
        };
        ComboBox comboBox = ComboBoxUtils.createRecordComboBox(this.isAppFilter() ? LocalizationTopic.filter().application(NumericFilter.equalsFilter((Number)this.getMainApplication().getId())).execute() : LocalizationTopic.getAll(), (PropertyProvider)propertyProvider, (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        comboBox.setShowClearButton(true);
        return comboBox;
    }

    private ComboBox<TranslationMode> createTranslationModeComboBox() {
        PropertyExtractor propertyExtractor = (mode, propertyName) -> switch (propertyName) {
            case "icon" -> mode.getIcon();
            case "caption" -> this.getLocalized(mode.getTranslationKey());
            default -> null;
        };
        ComboBox comboBox = ComboBoxUtils.createRecordComboBox(Arrays.asList(TranslationMode.values()), (PropertyProvider)propertyExtractor, (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        return comboBox;
    }

    private List<TranslationMode> getAvailableModes() {
        return Arrays.asList(TranslationMode.values());
    }
}

