/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.perspective.AbstractPerspectiveBuilder;
import org.teamapps.application.api.application.perspective.ApplicationPerspective;
import org.teamapps.application.api.application.perspective.PerspectiveMenuPanel;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.roles.UserRoleAssignmentPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.users.UsersPerspectiveBuilder;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.passwordhash.SecurePasswordHash;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.system.utils.ValueConverterUtils;
import org.teamapps.application.server.ui.address.AddressForm;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Address;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserAccountStatus;
import org.teamapps.model.controlcenter.UserContainer;
import org.teamapps.model.controlcenter.UserRoleAssignment;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.dialogue.FormDialogue;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.PasswordField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.field.upload.PictureChooser;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.resource.ByteArrayResource;
import org.teamapps.ux.resource.Resource;

public class UsersPerspective
extends AbstractManagedApplicationPerspective {
    private final TwoWayBindableValue<User> selectedUser = TwoWayBindableValue.create();
    private final PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
    private final UserSessionData userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();

    public UsersPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        UsersPerspectiveBuilder usersPerspectiveBuilder = new UsersPerspectiveBuilder();
        PerspectiveMenuPanel menuPanel = PerspectiveMenuPanel.createMenuPanel((ApplicationInstanceData)this.getApplicationInstanceData(), (AbstractPerspectiveBuilder[])new AbstractPerspectiveBuilder[]{usersPerspectiveBuilder, new UserRoleAssignmentPerspectiveBuilder()});
        menuPanel.addInstantiatedPerspective((AbstractPerspectiveBuilder)usersPerspectiveBuilder, (ApplicationPerspective)this);
        this.setPerspectiveMenuPanel(menuPanel.getComponent());
        View masterView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.USERS_CROWD, (String)this.getLocalized("users.users"), null));
        View detailView = this.getPerspective().addView(View.createView((String)"right", (Icon)ApplicationIcons.USER, (String)this.getLocalized("users.user"), null));
        detailView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        EntityModelBuilder userModelBuilder = new EntityModelBuilder(() -> User.filter(), this.getApplicationInstanceData());
        userModelBuilder.attachViewCountHandler(masterView, () -> this.getLocalized("users.users"));
        userModelBuilder.attachSearchField(masterView);
        userModelBuilder.onSelectedRecordChanged.addListener(arg_0 -> this.selectedUser.set(arg_0));
        Table table = userModelBuilder.createTable();
        table.setDisplayAsList(true);
        table.setRowHeight(32);
        table.setStripedRows(false);
        userModelBuilder.updateModels();
        TemplateField userTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()));
        TemplateField accountStatusTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, this.createAccountStatusPropertyProvider());
        InstantDateTimeField lastLogin = new InstantDateTimeField();
        TagComboBox languagesTableField = Language.createTagComboBox((ApplicationLocalizationProvider)this.getApplicationInstanceData());
        TextField rolesTableField = new TextField();
        table.addColumn(new TableColumn("lastName", this.getLocalized("users.user"), (AbstractField)userTableField).setDefaultWidth(250));
        table.addColumn(new TableColumn("userAccountStatus", this.getLocalized("users.accountStatus"), (AbstractField)accountStatusTableField).setDefaultWidth(120));
        table.addColumn(new TableColumn("lastLogin", this.getLocalized("users.lastLogin"), (AbstractField)lastLogin).setDefaultWidth(200));
        table.addColumn(new TableColumn("languages", this.getLocalized("users.languages"), (AbstractField)languagesTableField).setDefaultWidth(350));
        table.addColumn(new TableColumn("roleAssignments", this.getLocalized("users.roles"), (AbstractField)rolesTableField).setDefaultWidth(300));
        table.setPropertyExtractor((user, propertyName) -> switch (propertyName) {
            case "lastName" -> user;
            case "userAccountStatus" -> user.getUserAccountStatus();
            case "lastLogin" -> user.getLastLogin();
            case "languages" -> this.getLanguages(user.getLanguages());
            case "roleAssignments" -> this.getRolesString(user.getRoleAssignments(), 5);
            default -> null;
        });
        masterView.setComponent((Component)table);
        ToolbarButtonGroup buttonGroup = detailView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton addButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ADD, (String)this.getLocalized("org.teamapps.dictionary.add"), (String)this.getLocalized("org.teamapps.dictionary.addRecord")));
        buttonGroup = detailView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton saveButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.FLOPPY_DISK, (String)this.getLocalized("org.teamapps.dictionary.saveChanges")));
        buttonGroup = detailView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton updatePasswordButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.KEYS, (String)this.getLocalized("org.teamapps.dictionary.resetPassword")));
        PictureChooser pictureChooser = new PictureChooser();
        pictureChooser.setImageDisplaySize(120, 120);
        pictureChooser.setTargetImageSize(240, 240);
        pictureChooser.setMaxFileSize(5000000L);
        TextField firstNameField = new TextField();
        TextField lastNameField = new TextField();
        TagComboBox languagesField = Language.createTagComboBox((ApplicationLocalizationProvider)this.getApplicationInstanceData());
        languagesField.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        languagesField.setShowClearButton(true);
        TextField emailField = new TextField();
        TextField mobileField = new TextField();
        TextField loginField = new TextField();
        PasswordField passwordField = new PasswordField();
        ComboBox<UserAccountStatus> accountStatusComboBox = this.createAccountStatusComboBox();
        TagComboBox<UserRoleAssignment> userRoleAssignmentTagCombo = this.createUserRoleAssignmentTagCombo();
        ComboBox<OrganizationUnit> orgUnitComboBox = OrganizationUtils.createOrganizationComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, OrganizationUnit.getAll(), this.getApplicationInstanceData());
        ResponsiveForm form = new ResponsiveForm(120, 120, 0);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("users.profilePicture"), (AbstractField)pictureChooser);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.firstName"), (AbstractField)firstNameField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.lastName"), (AbstractField)lastNameField);
        formLayout.addLabelAndField(null, this.getLocalized("users.languages"), (AbstractField)languagesField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.eMail"), (AbstractField)emailField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.mobileNumber"), (AbstractField)mobileField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.userName"), (AbstractField)loginField);
        formLayout.addLabelAndField(null, this.getLocalized("users.accountStatus"), accountStatusComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("users.roles"), userRoleAssignmentTagCombo);
        formLayout.addLabelAndField(null, this.getLocalized("users.organizationUnit"), orgUnitComboBox);
        AddressForm addressForm = new AddressForm(this.getApplicationInstanceData());
        addressForm.createAddressSection(formLayout);
        addressForm.addFields(formLayout);
        detailView.setComponent((Component)form);
        addButton.onClick.addListener(() -> this.selectedUser.set((Object)User.create().setAddress(Address.create()).setUserAccountStatus(UserAccountStatus.ACTIVE)));
        updatePasswordButton.onClick.addListener(() -> {
            User user = (User)this.selectedUser.get();
            if (user != null) {
                this.showUpdatePasswordDialogue(user);
            }
        });
        saveButton.onClick.addListener(() -> {
            User user = (User)this.selectedUser.get();
            OrganizationUnit organizationUnit = (OrganizationUnit)orgUnitComboBox.getValue();
            if (organizationUnit != null && organizationUnit.getType().getAllowUserContainer()) {
                if (organizationUnit.getUserContainer() == null) {
                    UserContainer.create().setOrganizationUnit(organizationUnit).save();
                }
            } else {
                UiUtils.showNotification((Icon)ApplicationIcons.ERROR, (String)this.getLocalized("users.wrongOrMissingOrgUnit"));
                return;
            }
            if (!addressForm.validateAddress()) {
                UiUtils.showSaveNotification((boolean)false, (ApplicationInstanceData)this.getApplicationInstanceData());
                return;
            }
            if (organizationUnit != null && organizationUnit.getUserContainer() != null && user != null && firstNameField.getValue() != null && lastNameField.getValue() != null) {
                byte[] picture = this.readUserPicture(pictureChooser);
                user.setFirstName((String)firstNameField.getValue()).setLastName((String)lastNameField.getValue()).setLanguages(this.getCompressedLanguages((List)languagesField.getValue())).setEmail((String)emailField.getValue()).setMobile((String)mobileField.getValue()).setLogin((String)loginField.getValue()).setUserAccountStatus((UserAccountStatus)((Object)((Object)accountStatusComboBox.getValue()))).setAddress(addressForm.getAddress()).setContainer(organizationUnit.getUserContainer());
                if (picture != null && picture.length != user.getProfilePictureLength()) {
                    user.setProfilePicture(picture);
                }
                user.save();
                UiUtils.showSaveNotification((boolean)true, (ApplicationInstanceData)this.getApplicationInstanceData());
                userModelBuilder.updateModels();
            } else {
                UiUtils.showSaveNotification((boolean)false, (ApplicationInstanceData)this.getApplicationInstanceData());
            }
        });
        this.selectedUser.onChanged().addListener(user -> {
            pictureChooser.setValue((Object)(user.getProfilePicture() != null ? new ByteArrayResource(user.getProfilePicture(), "image.jpg") : null));
            firstNameField.setValue((Object)user.getFirstName());
            lastNameField.setValue((Object)user.getLastName());
            languagesField.setValue(this.getLanguages(user.getLanguages()));
            emailField.setValue((Object)user.getEmail());
            mobileField.setValue((Object)user.getMobile());
            loginField.setValue((Object)user.getLogin());
            passwordField.setValue((Object)user.getPassword());
            accountStatusComboBox.setValue((Object)user.getUserAccountStatus());
            userRoleAssignmentTagCombo.setValue(user.getRoleAssignments());
            orgUnitComboBox.setValue(user.getContainer() != null ? user.getContainer().getOrganizationUnit() : null);
            addressForm.setAddress(user.getAddress());
        });
        this.selectedUser.set((Object)User.create().setAddress(Address.create()).setUserAccountStatus(UserAccountStatus.ACTIVE));
    }

    private void showUpdatePasswordDialogue(User user) {
        FormDialogue formDialogue = FormDialogue.create((Icon)ApplicationIcons.KEYS, (String)this.getLocalized("org.teamapps.dictionary.resetPassword"), (String)this.getLocalized("org.teamapps.dictionary.resetPassword"));
        PasswordField passwordField = new PasswordField();
        formDialogue.addField(ApplicationIcons.KEYS, this.getLocalized("org.teamapps.dictionary.password"), (AbstractField)passwordField);
        formDialogue.addOkCancelButtons(this.getLocalized("org.teamapps.dictionary.oK"), this.getLocalized("org.teamapps.dictionary.cancel"));
        formDialogue.onOk.addListener(() -> {
            String value = (String)passwordField.getValue();
            if (value.length() > 8) {
                user.setPassword(SecurePasswordHash.createDefault().createSecureHash(value)).save();
                UiUtils.showSaveNotification((boolean)true, (ApplicationInstanceData)this.getApplicationInstanceData());
                formDialogue.close();
            } else {
                UiUtils.showSaveNotification((boolean)false, (ApplicationInstanceData)this.getApplicationInstanceData());
            }
        });
        formDialogue.setCloseable(true);
        formDialogue.setCloseOnEscape(true);
        formDialogue.setMaximizable(true);
        formDialogue.show();
    }

    private byte[] readUserPicture(PictureChooser pictureChooser) {
        if (pictureChooser.getValue() != null) {
            Resource value = (Resource)pictureChooser.getValue();
            try {
                return IOUtils.readFully((InputStream)value.getInputStream(), (int)((int)value.getLength()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getRolesString(List<UserRoleAssignment> assignments, int limit) {
        return assignments.stream().map(assignment -> this.getLocalized(assignment.getRole().getTitle())).limit(limit).collect(Collectors.joining(", "));
    }

    public List<Language> getLanguages(String compressedValue) {
        return ValueConverterUtils.decompressToStringList(compressedValue).stream().map(Language::getLanguageByIsoCode).collect(Collectors.toList());
    }

    public String getCompressedLanguages(List<Language> languages) {
        return ValueConverterUtils.compressStringList(languages.stream().map(Language::getIsoCode).collect(Collectors.toList()));
    }

    private ComboBox<UserAccountStatus> createAccountStatusComboBox() {
        return ComboBoxUtils.createRecordComboBox(Arrays.asList(UserAccountStatus.values()), this.createAccountStatusPropertyProvider(), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
    }

    private TagComboBox<UserRoleAssignment> createUserRoleAssignmentTagCombo() {
        TagComboBox tagComboBox = UiUtils.createTagComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, PropertyProviders.createUserRoleAssignmentPropertyProviderNoUserDisplay(this.userSessionData));
        tagComboBox.setEditingMode(FieldEditingMode.READONLY);
        return tagComboBox;
    }

    private PropertyProvider<UserAccountStatus> createAccountStatusPropertyProvider() {
        return (userAccountStatus, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", this.getAccountStatusIcon((UserAccountStatus)((Object)userAccountStatus)));
            map.put("caption", this.getLocalized("users.accountStatus." + userAccountStatus.name()));
            return map;
        };
    }

    private Icon getAccountStatusIcon(UserAccountStatus status) {
        return switch (status) {
            case UserAccountStatus.ACTIVE -> ApplicationIcons.OK;
            case UserAccountStatus.INACTIVE -> ApplicationIcons.ERROR;
            case UserAccountStatus.SUPER_ADMIN -> ApplicationIcons.PILOT;
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

