/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.rest;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.server.rest.Author;
import org.teamapps.application.server.rest.Channel;
import org.teamapps.application.server.rest.Message;
import org.teamapps.application.server.rest.UserData;
import org.teamapps.application.server.system.passwordhash.SecurePasswordHash;
import org.teamapps.model.controlcenter.ChatChannel;
import org.teamapps.model.controlcenter.ChatMessage;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserAccessToken;
import org.teamapps.model.controlcenter.UserAccountStatus;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.text.TextFilter;

public class ChatRestServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Gson gson = new Gson();

    public void init() throws ServletException {
        super.init();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || !pathInfo.contains("/")) {
            this.setError(response);
            return;
        }
        String id = request.getSession().getId();
        String userAgent = request.getHeader("User-Agent");
        String acceptLanguage = request.getHeader("Accept-Language");
        String remoteAddr = request.getRemoteAddr();
        String[] parts = pathInfo.split("/");
        if (parts.length < 3) {
            this.setError(response);
            return;
        }
        String method = parts[1];
        if (method.equals("login")) {
            this.handleLogin(parts[2], parts[3], userAgent, response);
            return;
        }
        String token = parts[2];
        User user = this.getUser(token);
        if (user == null) {
            this.setError(response);
            return;
        }
        switch (method) {
            case "channels": {
                this.handleChannelsRequest(user, response);
                break;
            }
            case "messages": {
                String channelId = parts[3];
                String lastMessageId = parts[4];
                this.handleMessagesRequest(user, channelId, lastMessageId, response);
                break;
            }
            case "avatar": {
                String avatarId = parts[3];
                this.handleAvatarRequest(user, avatarId, response);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    private void handleAvatarRequest(User user, String avatarId, HttpServletResponse response) throws IOException {
        if (avatarId.startsWith("user-")) {
            int id = this.parseId(avatarId);
            User requestedUser = User.getById(id);
            byte[] profilePicture = requestedUser.getProfilePicture();
            if (profilePicture != null) {
                response.setHeader("Content-Disposition", String.format("%s;filename=\"%2$s\"; filename*=UTF-8''%2$s", "attachment", "avatar.jpg"));
                response.setHeader("Content-Length", String.valueOf(profilePicture.length));
                ServletOutputStream output = response.getOutputStream();
                output.write(profilePicture);
                output.close();
            }
            ChatMessage.create().setChatChannel(ChatChannel.getById(3)).setAuthor(user).setMessage("Avatar request for:" + requestedUser.getFirstName() + " " + requestedUser.getLastName() + " with avatar:" + (String)(profilePicture != null ? "" + profilePicture.length : "0")).save();
        }
    }

    private void handleMessagesRequest(User user, String channelId, String lastMessageId, HttpServletResponse response) throws IOException {
        ChatChannel channel = ChatChannel.getById(this.parseId(channelId));
        if (!channel.isStored()) {
            this.setError(response);
            return;
        }
        int messageId = this.parseId(lastMessageId);
        ArrayList messages = new ArrayList();
        channel.getChatMessages().stream().filter(message -> message.getId() > messageId).forEach(message -> messages.add(new Message("message-" + message.getId(), this.createAuthor(message.getAuthor()), message.getMessage())));
        this.sendJson(messages, response);
        ChatMessage.create().setChatChannel(ChatChannel.getById(3)).setAuthor(user).setMessage("Message request for channel: " + channel.getTitle() + ", last message id:" + lastMessageId + " returned messages:" + messages.size()).save();
    }

    private Author createAuthor(User user) {
        return new Author("user-" + user.getId(), user.getFirstName() + " " + user.getLastName(), user.getProfilePictureLength() > 0 ? (long)user.getMetaModificationDateAsEpochSecond() : 0L);
    }

    private int parseId(String id) {
        String value = id.substring(id.indexOf(45) + 1);
        return Integer.parseInt(value);
    }

    private void handleChannelsRequest(User user, HttpServletResponse response) throws IOException {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (ChatChannel channel : ChatChannel.getAll()) {
            channels.add(new Channel("channel-" + channel.getId(), channel.getTitle(), System.currentTimeMillis(), (int)(Math.random() * 10.0)));
        }
        this.sendJson(channels, response);
        ChatMessage.create().setChatChannel(ChatChannel.getById(3)).setAuthor(user).setMessage("Channel request").save();
    }

    private void handleLogin(String userName, String password, String userAgent, HttpServletResponse response) throws IOException {
        User user = this.authenticate(userName, password);
        if (user == null) {
            this.setError(response);
            return;
        }
        String token = "TOK" + UUID.randomUUID().toString().replace("-", "");
        UserAccessToken.create().setUser(user).setSecureToken(token).setUserAgentOnCreation(userAgent).setValid(true).save();
        this.sendJson(new UserData(user.getId(), token, user.getFirstName(), user.getLastName()), response);
        ChatMessage.create().setChatChannel(ChatChannel.getById(3)).setAuthor(user).setMessage("User login").save();
    }

    private void setError(HttpServletResponse response) {
        response.setStatus(401);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    private void sendJson(Object obj, HttpServletResponse response) throws IOException {
        String json = this.gson.toJson(obj);
        PrintWriter out = response.getWriter();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        out.print(json);
        out.flush();
    }

    protected long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    private User getUser(String accessToken) {
        if (accessToken == null || !accessToken.startsWith("TOK")) {
            return null;
        }
        UserAccessToken userAccessToken = UserAccessToken.filter().secureToken(TextFilter.textEqualsFilter((String)accessToken)).executeExpectSingleton();
        if (userAccessToken != null && userAccessToken.isValid()) {
            return userAccessToken.getUser();
        }
        return null;
    }

    private String createToken(String username, String password, String userAgent) {
        User user = this.authenticate(userAgent, password);
        if (user == null) {
            return null;
        }
        String token = "TOK" + UUID.randomUUID().toString().replace("-", "");
        UserAccessToken.create().setUser(user).setSecureToken(token).setUserAgentOnCreation(userAgent).setValid(true).save();
        return token;
    }

    private User authenticate(String login, String password) {
        if (login == null || login.isBlank() || password == null || password.isBlank()) {
            return null;
        }
        User user = User.filter().login(TextFilter.textEqualsIgnoreCaseFilter((String)login)).userAccountStatus(EnumFilterType.NOT_EQUALS, UserAccountStatus.INACTIVE).executeExpectSingleton();
        if (user != null) {
            String hash = user.getPassword();
            if (SecurePasswordHash.createDefault().verifyPassword(password, hash)) {
                return user;
            }
        }
        return null;
    }
}

