/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap.installer;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationBuilder;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.api.application.perspective.PerspectiveBuilder;
import org.teamapps.application.server.system.bootstrap.ApplicationInfo;
import org.teamapps.application.server.system.bootstrap.ApplicationInfoDataElement;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationInstallationPhase;
import org.teamapps.application.server.system.utils.KeyCompare;
import org.teamapps.application.server.system.utils.ValueCompare;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPerspective;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.pojo.Entity;

public class PerspectiveDataInstallationPhase
implements ApplicationInstallationPhase {
    @Override
    public void checkApplication(ApplicationInfo applicationInfo) {
        try {
            if (!applicationInfo.getErrors().isEmpty()) {
                return;
            }
            BaseApplicationBuilder baseApplicationBuilder = applicationInfo.getBaseApplicationBuilder();
            if (!(baseApplicationBuilder instanceof ApplicationBuilder)) {
                applicationInfo.setPerspectiveData(new ApplicationInfoDataElement());
                return;
            }
            ApplicationBuilder applicationBuilder = (ApplicationBuilder)baseApplicationBuilder;
            List perspectives = applicationBuilder.getPerspectiveBuilders();
            if (perspectives == null || perspectives.isEmpty()) {
                applicationInfo.addError("Missing perspectives");
                return;
            }
            for (PerspectiveBuilder builder : perspectives) {
                if (builder.getName() != null && builder.getTitleKey() != null) continue;
                applicationInfo.addError("Missing perspective meta data for perspective: " + builder.getName());
                return;
            }
            ApplicationInfoDataElement dataInfo = new ApplicationInfoDataElement();
            Application application = applicationInfo.getApplication();
            List applicationPerspectives = application == null ? Collections.emptyList() : ApplicationPerspective.filter().application(NumericFilter.equalsFilter((Number)application.getId())).execute();
            dataInfo.setData(perspectives.stream().map(PerspectiveBuilder::getName).collect(Collectors.joining("\n")));
            KeyCompare<PerspectiveBuilder, ApplicationPerspective> keyCompare = new KeyCompare<PerspectiveBuilder, ApplicationPerspective>(perspectives, applicationPerspectives, PerspectiveBuilder::getName, ApplicationPerspective::getName);
            List<PerspectiveBuilder> newPerspectives = keyCompare.getNotInB();
            dataInfo.setDataAdded(newPerspectives.stream().map(PerspectiveBuilder::getName).collect(Collectors.toList()));
            List<ApplicationPerspective> removedPerspectives = keyCompare.getNotInA();
            dataInfo.setDataRemoved(removedPerspectives.stream().map(ApplicationPerspective::getName).collect(Collectors.toList()));
            applicationInfo.setPerspectiveData(dataInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            applicationInfo.addError("Error checking perspectives:" + e.getMessage());
        }
    }

    @Override
    public void installApplication(ApplicationInfo applicationInfo) {
        BaseApplicationBuilder baseApplicationBuilder = applicationInfo.getBaseApplicationBuilder();
        if (!(baseApplicationBuilder instanceof ApplicationBuilder)) {
            return;
        }
        ApplicationBuilder applicationBuilder = (ApplicationBuilder)baseApplicationBuilder;
        List perspectives = applicationBuilder.getPerspectiveBuilders();
        Application application = applicationInfo.getApplication();
        List<ApplicationPerspective> applicationPerspectives = ApplicationPerspective.filter().application(NumericFilter.equalsFilter((Number)application.getId())).execute();
        KeyCompare<PerspectiveBuilder, ApplicationPerspective> keyCompare = new KeyCompare<PerspectiveBuilder, ApplicationPerspective>(perspectives, applicationPerspectives, PerspectiveBuilder::getName, ApplicationPerspective::getName);
        List<PerspectiveBuilder> newPerspectives = keyCompare.getNotInB();
        newPerspectives.forEach(perspective -> ApplicationPerspective.create().setApplication(application).setName(perspective.getName()).setIcon(IconUtils.encodeNoStyle((Icon)perspective.getIcon())).setTitleKey(perspective.getTitleKey()).setDescriptionKey(perspective.getDescriptionKey()).setAutoProvision(perspective.autoProvisionPerspective()).setToolbarPerspectiveMenu(perspective.useToolbarPerspectiveMenu()).save());
        List<ApplicationPerspective> removedPerspectives = keyCompare.getNotInA();
        removedPerspectives.forEach(Entity::delete);
        List<PerspectiveBuilder> existingPerspectives = keyCompare.getInB();
        for (PerspectiveBuilder perspective2 : existingPerspectives) {
            ApplicationPerspective applicationPerspective = keyCompare.getB(perspective2);
            if (!ValueCompare.create(perspective2.getTitleKey(), applicationPerspective.getTitleKey()).check(perspective2.getDescriptionKey(), applicationPerspective.getDescriptionKey()).check(IconUtils.encodeNoStyle((Icon)perspective2.getIcon()), applicationPerspective.getIcon()).check(perspective2.autoProvisionPerspective(), applicationPerspective.getAutoProvision()).check(perspective2.useToolbarPerspectiveMenu(), applicationPerspective.getToolbarPerspectiveMenu()).isDifferent()) continue;
            applicationPerspective.setTitleKey(perspective2.getTitleKey()).setDescriptionKey(perspective2.getDescriptionKey()).setIcon(IconUtils.encodeNoStyle((Icon)perspective2.getIcon())).setAutoProvision(perspective2.autoProvisionPerspective()).setToolbarPerspectiveMenu(perspective2.useToolbarPerspectiveMenu()).save();
        }
    }

    @Override
    public void loadApplication(ApplicationInfo applicationInfo) {
    }
}

