/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.localization;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.localization.LocalizationData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.machinetranslation.TranslationService;
import org.teamapps.application.server.system.utils.KeyCompare;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationKeyType;
import org.teamapps.model.controlcenter.LocalizationTopic;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.model.controlcenter.MachineTranslationState;
import org.teamapps.model.controlcenter.TranslationState;
import org.teamapps.model.controlcenter.TranslationVerificationState;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.text.TextFilter;

public class LocalizationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static List<String> allowedSourceTranslationLanguages = Arrays.asList("bg", "cs", "da", "de", "el", "en", "es", "et", "fi", "fr", "hu", "it", "ja", "lt", "lv", "nl", "pl", "pt", "ro", "ru", "sk", "sl", "sv", "zh");

    public static void synchronizeLocalizationData(LocalizationData localizationData, Application application, LocalizationKeyType localizationKeyType, List<String> requiredLanguages) {
        Map localizationMapByKey = localizationData.createLocalizationMapByKey();
        Set machineTranslatedLanguages = localizationData.getMachineTranslatedLanguages();
        int appIdFilter = 0;
        if (application != null) {
            appIdFilter = application.getId();
        }
        List<LocalizationKey> localizationKeys = LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)appIdFilter)).execute();
        KeyCompare<String, LocalizationKey> keyCompare = new KeyCompare<String, LocalizationKey>(localizationMapByKey.keySet(), localizationKeys, s -> s, LocalizationKey::getKey);
        List<String> newKeys = keyCompare.getNotInB();
        LocalizationTopic topic = LocalizationUtil.getTopic(localizationKeyType, application);
        for (String key2 : newKeys) {
            LocalizationKey localizationKey = (LocalizationKey)LocalizationKey.create().setApplication(application).setLocalizationKeyType(localizationKeyType).setTopics(topic).setUsed(true).setKey(key2).save();
            Map map = (Map)localizationMapByKey.get(key2);
            for (Map.Entry entry : map.entrySet()) {
                String language2 = (String)entry.getKey();
                String value2 = (String)entry.getValue();
                if (machineTranslatedLanguages.contains(language2)) {
                    LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage(language2).setMachineTranslation(value2).setCurrentDisplayValue(value2).setMachineTranslationState(MachineTranslationState.OK).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setTranslationVerificationState(TranslationVerificationState.NOT_YET_TRANSLATED).save();
                    continue;
                }
                LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage(language2).setOriginal(value2).setCurrentDisplayValue(value2).setMachineTranslationState(MachineTranslationState.NOT_NECESSARY).setTranslationState(TranslationState.NOT_NECESSARY).setTranslationVerificationState(TranslationVerificationState.NOT_NECESSARY).save();
            }
        }
        List<LocalizationKey> removedKeys = keyCompare.getNotInA();
        removedKeys.forEach(key -> key.setUsed(false).save());
        List<String> existingKeys = keyCompare.getInB();
        for (String string : existingKeys) {
            Map translations = (Map)localizationMapByKey.get(string);
            LocalizationKey localizationKey = keyCompare.getB(string);
            KeyCompare<String, LocalizationValue> languageCompare = new KeyCompare<String, LocalizationValue>(translations.keySet(), localizationKey.getLocalizationValues(), s -> s, LocalizationValue::getLanguage);
            if (languageCompare.isDifferent()) {
                List<String> newLanguages = languageCompare.getNotInB();
                newLanguages.forEach(language -> {
                    String original = (String)translations.get(language);
                    LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage((String)language).setOriginal(original).setCurrentDisplayValue(original).setMachineTranslationState(MachineTranslationState.NOT_NECESSARY).setTranslationState(TranslationState.NOT_NECESSARY).setTranslationVerificationState(TranslationVerificationState.NOT_NECESSARY).save();
                });
                List<LocalizationValue> removedLanguages = languageCompare.getNotInA();
                for (LocalizationValue value3 : removedLanguages) {
                    value3.setOriginal(null);
                    if (value3.getAdminKeyOverride() == null && value3.getAdminLocalOverride() == null && value3.getMachineTranslation() == null && value3.getTranslation() == null) {
                        value3.setMachineTranslationState(MachineTranslationState.TRANSLATION_REQUESTED).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setTranslationVerificationState(TranslationVerificationState.NOT_YET_TRANSLATED);
                    }
                    value3.save();
                }
            }
            for (LocalizationValue localizationValue : languageCompare.getInA()) {
                String original = (String)translations.get(localizationValue.getLanguage());
                if (original == null || original.isBlank() || original.equals(localizationValue.getOriginal())) continue;
                localizationValue.setOriginal(original).save();
                localizationValue.getLocalizationKey().getLocalizationValues().stream().filter(value -> !value.equals(localizationValue)).filter(value -> value.getOriginal() == null).filter(value -> value.getAdminLocalOverride() == null).filter(value -> value.getAdminKeyOverride() == null).forEach(value -> value.setMachineTranslationState(MachineTranslationState.TRANSLATION_REQUESTED).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setTranslationVerificationState(TranslationVerificationState.NOT_YET_TRANSLATED).save());
            }
        }
        localizationKeys = LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)appIdFilter)).execute();
        for (LocalizationKey localizationKey : localizationKeys) {
            Map<String, LocalizationValue> valueByLanguage = localizationKey.getLocalizationValues().stream().collect(Collectors.toMap(LocalizationValue::getLanguage, v -> v));
            for (String language2 : requiredLanguages) {
                if (valueByLanguage.containsKey(language2)) continue;
                LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage(language2).setMachineTranslationState(MachineTranslationState.TRANSLATION_REQUESTED).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setTranslationVerificationState(TranslationVerificationState.NOT_YET_TRANSLATED).save();
            }
        }
    }

    public static void translateAllApplicationValues(TranslationService translationService, Application application) {
        if (translationService == null) {
            return;
        }
        List<LocalizationValue> translationRequests = LocalizationValue.filter().machineTranslationState(EnumFilterType.EQUALS, MachineTranslationState.TRANSLATION_REQUESTED).execute().stream().filter(value -> value.getLocalizationKey().getApplication().equals(application)).collect(Collectors.toList());
        ExecutorService executor = Executors.newFixedThreadPool(10);
        translationRequests.forEach(localizationValue -> executor.submit(() -> LocalizationUtil.translateLocalizationValue(localizationValue, translationService)));
        executor.shutdown();
    }

    public static void translateAllDictionaryValues(TranslationService translationService) {
        if (translationService == null) {
            return;
        }
        List<LocalizationValue> translationRequests = LocalizationValue.filter().machineTranslationState(EnumFilterType.EQUALS, MachineTranslationState.TRANSLATION_REQUESTED).execute().stream().filter(value -> value.getLocalizationKey().getLocalizationKeyType() == LocalizationKeyType.DICTIONARY_KEY).collect(Collectors.toList());
        ExecutorService executor = Executors.newFixedThreadPool(10);
        translationRequests.forEach(localizationValue -> executor.submit(() -> LocalizationUtil.translateLocalizationValue(localizationValue, translationService)));
        executor.shutdown();
    }

    public static void translateAllValues(TranslationService translationService) {
        if (translationService == null) {
            return;
        }
        List<LocalizationValue> translationRequests = LocalizationValue.filter().machineTranslationState(EnumFilterType.EQUALS, MachineTranslationState.TRANSLATION_REQUESTED).execute();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        translationRequests.forEach(localizationValue -> executor.submit(() -> LocalizationUtil.translateLocalizationValue(localizationValue, translationService)));
        executor.shutdown();
    }

    public static void translateLocalizationValue(LocalizationValue missingTranslationValue, TranslationService translationService) {
        String translation;
        LocalizationValue adminValue = missingTranslationValue.getLocalizationKey().getLocalizationValues().stream().filter(value -> value.getAdminKeyOverride() != null).filter(value -> allowedSourceTranslationLanguages.contains(value.getLanguage())).findFirst().orElse(null);
        if (adminValue != null && translationService.canTranslate(adminValue.getLanguage(), missingTranslationValue.getLanguage()) && (translation = translationService.translate(adminValue.getAdminKeyOverride(), adminValue.getLanguage(), missingTranslationValue.getLanguage())) != null) {
            translation = LocalizationUtil.firstUpperIfSourceUpper(adminValue.getAdminKeyOverride(), translation);
            missingTranslationValue.setMachineTranslation(translation).setMachineTranslationState(MachineTranslationState.OK).setCurrentDisplayValue(LocalizationUtil.getDisplayValue(missingTranslationValue)).save();
            return;
        }
        Map<String, LocalizationValue> localizationValueByLanguage = missingTranslationValue.getLocalizationKey().getLocalizationValues().stream().filter(value -> !value.equals(missingTranslationValue)).filter(value -> value.getOriginal() != null).collect(Collectors.toMap(LocalizationValue::getLanguage, v -> v));
        for (String language : allowedSourceTranslationLanguages) {
            String translation2;
            String translationSourceText;
            LocalizationValue sourceValue = localizationValueByLanguage.get(language);
            if (sourceValue == null || !translationService.canTranslate(language, missingTranslationValue.getLanguage()) || (translationSourceText = LocalizationUtil.getTranslationSourceText(sourceValue)) == null || translationSourceText.isBlank() || (translation2 = translationService.translate(translationSourceText, language, missingTranslationValue.getLanguage())) == null) continue;
            translation2 = LocalizationUtil.firstUpperIfSourceUpper(translationSourceText, translation2);
            System.out.println("Translate (" + language + "->" + missingTranslationValue.getLanguage() + "): " + translationSourceText + " -> " + translation2);
            missingTranslationValue.setMachineTranslation(translation2).setMachineTranslationState(MachineTranslationState.OK).setCurrentDisplayValue(LocalizationUtil.getDisplayValue(missingTranslationValue)).save();
            return;
        }
    }

    private static String getTranslationSourceText(LocalizationValue localizationValue) {
        String value = localizationValue.getAdminKeyOverride();
        if (value == null) {
            value = localizationValue.getAdminLocalOverride();
        }
        if (value == null) {
            value = localizationValue.getOriginal();
        }
        return value;
    }

    private static String getDisplayValue(LocalizationValue localizationValue) {
        String value = localizationValue.getAdminKeyOverride();
        if (value == null) {
            value = localizationValue.getAdminLocalOverride();
        }
        if (value == null) {
            value = localizationValue.getOriginal();
        }
        if (value == null) {
            value = localizationValue.getTranslation();
        }
        if (value == null) {
            value = localizationValue.getMachineTranslation();
        }
        return value;
    }

    private static String firstUpperIfSourceUpper(String source, String text) {
        if (source == null || text == null || source.isEmpty() || text.isEmpty()) {
            return text;
        }
        char c = source.substring(0, 1).charAt(0);
        if (Character.isUpperCase(c)) {
            return text.substring(0, 1).toUpperCase() + text.substring(1);
        }
        return text;
    }

    private static LocalizationTopic getTopic(LocalizationKeyType keyType, Application application) {
        return switch (keyType) {
            case LocalizationKeyType.APPLICATION_RESOURCE_KEY -> LocalizationUtil.getOrCreateTopic(application.getName(), application.getIcon(), application);
            case LocalizationKeyType.DICTIONARY_KEY -> LocalizationUtil.getOrCreateTopic("Dictionary", IconUtils.encodeNoStyle((Icon)ApplicationIcons.DICTIONARY), application);
            case LocalizationKeyType.SYSTEM_KEY -> LocalizationUtil.getOrCreateTopic("System", IconUtils.encodeNoStyle((Icon)ApplicationIcons.SYSTEM), application);
            case LocalizationKeyType.REPORTING_KEY -> LocalizationUtil.getOrCreateTopic("Reporting", IconUtils.encodeNoStyle((Icon)ApplicationIcons.FORM), application);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static LocalizationTopic getOrCreateTopic(String name, String icon, Application application) {
        LocalizationTopic topic = LocalizationTopic.filter().title(TextFilter.textEqualsFilter((String)name)).executeExpectSingleton();
        if (topic == null) {
            topic = (LocalizationTopic)LocalizationTopic.create().setTitle(name).setApplication(application).setIcon(icon).save();
        }
        return topic;
    }

    public static File createTranslationResourceFiles() throws IOException {
        Map<String, List<LocalizationValue>> valuesByDomain = LocalizationValue.getAll().stream().filter(value -> value.getCurrentDisplayValue() != null).collect(Collectors.groupingBy(value -> {
            if (value.getLocalizationKey().getApplication() != null) {
                return value.getLocalizationKey().getApplication().getName();
            }
            return value.getLocalizationKey().getLocalizationKeyType().name();
        }));
        File zipFile = File.createTempFile("temp", ".zip");
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        for (Map.Entry<String, List<LocalizationValue>> domainEntry : valuesByDomain.entrySet()) {
            String applicationOrType = domainEntry.getKey();
            zos.putNextEntry(new ZipEntry(applicationOrType + "/"));
            zos.closeEntry();
            Map<String, List<LocalizationValue>> valueMap = domainEntry.getValue().stream().collect(Collectors.groupingBy(LocalizationValue::getLanguage));
            for (Map.Entry<String, List<LocalizationValue>> entry : valueMap.entrySet()) {
                String language = entry.getKey();
                String fileName = applicationOrType;
                if (applicationOrType.equals("DICTIONARY_KEY")) {
                    fileName = "dictionary";
                }
                zos.putNextEntry(new ZipEntry(applicationOrType + "/" + fileName + "_" + language + ".properties"));
                List values = entry.getValue().stream().sorted(Comparator.comparing(o -> o.getLocalizationKey().getKey())).collect(Collectors.toList());
                StringBuilder sb = new StringBuilder();
                for (LocalizationValue value2 : values) {
                    sb.append(value2.getLocalizationKey().getKey()).append("=").append(value2.getCurrentDisplayValue()).append("\n");
                }
                zos.write(sb.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        zos.close();
        fos.close();
        return zipFile;
    }
}

