/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.localization;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.system.localization.DictionaryLocalizationProvider;
import org.teamapps.application.server.system.localization.SessionApplicationLocalizationProvider;
import org.teamapps.application.server.system.localization.SystemLocalizationProvider;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.session.SessionContext;

public class SessionLocalizationProvider
implements ApplicationLocalizationProvider {
    private final List<String> rankedLanguages;
    private final DictionaryLocalizationProvider dictionary;
    private final SystemLocalizationProvider systemDictionary;
    private Map<String, Map<String, LocalizationValue>> allKeysMap;
    private Map<Application, Map<String, Map<String, LocalizationValue>>> applicationLocalizationMap;

    public SessionLocalizationProvider(SystemRegistry registry, SessionContext context) {
        this(Arrays.asList(context.getLocale().getLanguage()), registry.getDictionary(), registry.getSystemDictionary());
    }

    public SessionLocalizationProvider(List<String> rankedLanguages, DictionaryLocalizationProvider dictionary, SystemLocalizationProvider systemDictionary) {
        this.rankedLanguages = new ArrayList<String>(rankedLanguages);
        this.dictionary = dictionary;
        this.systemDictionary = systemDictionary;
        if (!this.rankedLanguages.contains("en")) {
            this.rankedLanguages.add("en");
        }
        this.loadLocalizationData();
    }

    public SessionApplicationLocalizationProvider createApplicationLocalizationProvider(Application application) {
        return new SessionApplicationLocalizationProvider(application, this);
    }

    private void loadLocalizationData() {
        try {
            this.allKeysMap = new HashMap<String, Map<String, LocalizationValue>>();
            this.applicationLocalizationMap = new HashMap<Application, Map<String, Map<String, LocalizationValue>>>();
            LocalizationKey.filter().execute().stream().flatMap(key -> key.getLocalizationValues().stream()).forEach(value -> {
                this.allKeysMap.computeIfAbsent(value.getLocalizationKey().getKey(), k -> new HashMap()).put(value.getLanguage(), value);
                this.applicationLocalizationMap.computeIfAbsent(value.getLocalizationKey().getApplication(), k -> new HashMap()).computeIfAbsent(value.getLocalizationKey().getKey(), k -> new HashMap()).put(value.getLanguage(), value);
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public String getLocalized(Application application, String key) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        if (key.startsWith("org.teamapps.dictionary.")) {
            return this.dictionary.getLocalizationValue(key, this.rankedLanguages);
        }
        if (key.startsWith("org.teamapps.systemKey.")) {
            return this.systemDictionary.getLocalizationValue(key, this.rankedLanguages);
        }
        String result = this.getLocalizationValue(key, this.applicationLocalizationMap.get(application));
        if (result == null) {
            result = this.getLocalizationValue(key, this.allKeysMap);
        }
        return result != null ? result : key;
    }

    public String getLocalized(Application application, String key, Object ... parameters) {
        String localizationValue = this.getLocalized(application, key);
        if (parameters != null && parameters.length > 0) {
            try {
                return MessageFormat.format(localizationValue, parameters);
            }
            catch (Exception e) {
                e.printStackTrace();
                return localizationValue;
            }
        }
        return localizationValue;
    }

    public String getLocalized(String key, Object ... parameters) {
        return this.getLocalized(null, key, parameters);
    }

    public String getLocalized(TranslatableText translatableText) {
        if (translatableText == null) {
            return null;
        }
        Map translationMap = translatableText.getTranslationMap();
        for (String language : this.rankedLanguages) {
            String value = (String)translationMap.get(language);
            if (value == null) continue;
            return value;
        }
        return translatableText.getText();
    }

    private String getLocalizationValue(String key, Map<String, Map<String, LocalizationValue>> localizationMap) {
        if (localizationMap == null) {
            return null;
        }
        Map<String, LocalizationValue> languageValueMap = localizationMap.get(key);
        if (languageValueMap != null) {
            for (String language : this.rankedLanguages) {
                LocalizationValue value = languageValueMap.get(language);
                if (value == null || value.getCurrentDisplayValue() == null) continue;
                return value.getCurrentDisplayValue();
            }
        }
        return null;
    }
}

