/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.organization;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.model.controlcenter.GeoLocationType;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationFieldView;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserContainer;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.component.tree.TreeNodeInfoImpl;
import org.teamapps.ux.model.ComboBoxModel;
import org.teamapps.ux.model.ListTreeModel;

public class OrganizationUtils {
    public static Set<OrganizationUnitView> convertSet(Collection<OrganizationUnit> organizationUnits) {
        return organizationUnits.stream().map(unit -> OrganizationUnitView.getById(unit.getId())).collect(Collectors.toSet());
    }

    public static List<OrganizationUnitView> convertList(Collection<OrganizationUnit> organizationUnits) {
        return organizationUnits.stream().map(unit -> OrganizationUnitView.getById(unit.getId())).collect(Collectors.toList());
    }

    public static OrganizationUnitView convert(OrganizationUnit organizationUnit) {
        return organizationUnit != null ? OrganizationUnitView.getById(organizationUnit.getId()) : null;
    }

    public static OrganizationUnit convert(OrganizationUnitView OrganizationUnitView2) {
        return OrganizationUnitView2 != null && OrganizationUnitView2.getId() > 0 ? OrganizationUnit.getById(OrganizationUnitView2.getId()) : null;
    }

    public static OrganizationFieldView convert(OrganizationField organizationField) {
        return organizationField != null ? OrganizationFieldView.getById(organizationField.getId()) : null;
    }

    public static OrganizationField convert(OrganizationFieldView OrganizationFieldView2) {
        return OrganizationFieldView2 != null && OrganizationFieldView2.getId() > 0 ? OrganizationField.getById(OrganizationFieldView2.getId()) : null;
    }

    public static Set<OrganizationUnit> getAllUnits(OrganizationUnit unit, Collection<OrganizationUnitType> unitTypesFilter) {
        HashSet<OrganizationUnit> result = new HashSet<OrganizationUnit>();
        HashSet<OrganizationUnit> traversedNodes = new HashSet<OrganizationUnit>();
        HashSet<OrganizationUnitType> filter = unitTypesFilter != null && !unitTypesFilter.isEmpty() ? new HashSet<OrganizationUnitType>(unitTypesFilter) : null;
        OrganizationUtils.calculateAllUnits(unit, filter, traversedNodes, result);
        return result;
    }

    private static void calculateAllUnits(OrganizationUnit unit, Set<OrganizationUnitType> unitTypesFilter, Set<OrganizationUnit> traversedNodes, Set<OrganizationUnit> result) {
        if (unitTypesFilter == null || unitTypesFilter.contains(unit.getType())) {
            result.add(unit);
        }
        for (OrganizationUnit child : unit.getChildren()) {
            if (traversedNodes.contains(child)) continue;
            traversedNodes.add(child);
            OrganizationUtils.calculateAllUnits(child, unitTypesFilter, traversedNodes, result);
        }
    }

    public static Set<UserContainer> getAllUserContainers(OrganizationUnit unit, Collection<OrganizationUnitType> unitTypesFilter) {
        Set<OrganizationUnit> allUnits = OrganizationUtils.getAllUnits(unit, unitTypesFilter);
        HashSet<UserContainer> result = new HashSet<UserContainer>();
        for (OrganizationUnit organizationUnit : allUnits) {
            UserContainer userContainer = organizationUnit.getUserContainer();
            if (userContainer == null) continue;
            result.add(userContainer);
        }
        return result;
    }

    public static Set<User> getAllUsers(OrganizationUnit unit, Collection<OrganizationUnitType> unitTypesFilter) {
        Set<UserContainer> allUserContainers = OrganizationUtils.getAllUserContainers(unit, unitTypesFilter);
        HashSet<User> result = new HashSet<User>();
        for (UserContainer userContainer : allUserContainers) {
            List<User> users = userContainer.getUsers();
            result.addAll(users);
        }
        return result;
    }

    public static ComboBox<OrganizationField> createOrganizationFieldCombo(ApplicationInstanceData applicationInstanceData) {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setModel((ComboBoxModel)new ListTreeModel(OrganizationField.getAll()));
        comboBox.setPropertyProvider(PropertyProviders.createOrganizationFieldPropertyProvider(applicationInstanceData));
        return comboBox;
    }

    public static int getLevel(OrganizationUnit unit) {
        int level = 0;
        for (OrganizationUnit parent = unit.getParent(); parent != null; parent = parent.getParent()) {
            ++level;
        }
        return level;
    }

    public static OrganizationUnit getParentWithGeoType(OrganizationUnit unit, GeoLocationType type) {
        if (unit == null) {
            return null;
        }
        for (OrganizationUnit parent = unit.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType().getGeoLocationType() != type) continue;
            return parent;
        }
        return null;
    }

    public static ComboBox<UserContainer> createUserContainerComboBox(Template template, final Collection<OrganizationUnit> allowedUnits, ApplicationInstanceData applicationInstanceData) {
        ComboBox comboBox = new ComboBox(template);
        ComboBoxModel<UserContainer> model = new ComboBoxModel<UserContainer>(){

            public List<UserContainer> getRecords(String query) {
                return OrganizationUtils.queryUserContainer(query, allowedUnits);
            }

            public TreeNodeInfo getTreeNodeInfo(UserContainer unit) {
                return new TreeNodeInfoImpl(unit.getOrganizationUnit().getParent() != null ? unit.getOrganizationUnit().getParent().getUserContainer() : null);
            }
        };
        comboBox.setModel((ComboBoxModel)model);
        comboBox.setShowExpanders(true);
        PropertyProvider<UserContainer> propertyProvider = PropertyProviders.creatUserContainerPropertyProvider(applicationInstanceData);
        comboBox.setPropertyProvider(propertyProvider);
        Function<UserContainer, String> recordToStringFunction = unit -> {
            Map values = propertyProvider.getValues(unit, Collections.singleton("caption"));
            Object result = values.get("caption");
            return (String)result;
        };
        comboBox.setRecordToStringFunction(recordToStringFunction);
        return comboBox;
    }

    public static ComboBox<OrganizationUnit> createOrganizationComboBox(Template template, final Collection<OrganizationUnit> allowedUnits, ApplicationInstanceData applicationInstanceData) {
        ComboBox comboBox = new ComboBox(template);
        ComboBoxModel<OrganizationUnit> model = new ComboBoxModel<OrganizationUnit>(){

            public List<OrganizationUnit> getRecords(String query) {
                return OrganizationUtils.queryOrganizationUnits(query, allowedUnits);
            }

            public TreeNodeInfo getTreeNodeInfo(OrganizationUnit unit) {
                return new TreeNodeInfoImpl((Object)unit.getParent());
            }
        };
        comboBox.setModel((ComboBoxModel)model);
        comboBox.setShowExpanders(true);
        PropertyProvider<OrganizationUnit> propertyProvider = PropertyProviders.creatOrganizationUnitPropertyProvider(applicationInstanceData);
        comboBox.setPropertyProvider(propertyProvider);
        Function<OrganizationUnit, String> recordToStringFunction = unit -> {
            Map values = propertyProvider.getValues(unit, Collections.singleton("caption"));
            Object result = values.get("caption");
            return (String)result;
        };
        comboBox.setRecordToStringFunction(recordToStringFunction);
        return comboBox;
    }

    public static List<OrganizationUnit> queryOrganizationUnits(String query, Collection<OrganizationUnit> allowedUnits) {
        return query == null || query.isBlank() ? allowedUnits.stream().limit(50L).collect(Collectors.toList()) : OrganizationUnit.filter().parseFullTextFilter(query, new String[0]).execute().stream().filter(allowedUnits::contains).limit(50L).collect(Collectors.toList());
    }

    public static List<UserContainer> queryUserContainer(String query, Collection<OrganizationUnit> allowedUnits) {
        return query == null || query.isBlank() ? allowedUnits.stream().filter(unit -> unit.getUserContainer() != null).map(OrganizationUnit::getUserContainer).limit(50L).collect(Collectors.toList()) : OrganizationUnit.filter().parseFullTextFilter(query, new String[0]).execute().stream().filter(allowedUnits::contains).filter(unit -> unit.getUserContainer() != null).limit(50L).map(OrganizationUnit::getUserContainer).collect(Collectors.toList());
    }

    public static TagComboBox<OrganizationUnitType> createOrganizationUnitTypeTagComboBox(int limit, ApplicationInstanceData applicationInstanceData) {
        TagComboBox tagComboBox = new TagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        tagComboBox.setModel(query -> query == null || query.isBlank() ? OrganizationUnitType.getAll().stream().limit(limit).collect(Collectors.toList()) : OrganizationUnitType.filter().parseFullTextFilter(query, new String[0]).execute().stream().limit(limit).collect(Collectors.toList()));
        PropertyProvider<OrganizationUnitType> propertyProvider = PropertyProviders.creatOrganizationUnitTypePropertyProvider(applicationInstanceData);
        tagComboBox.setPropertyProvider(propertyProvider);
        tagComboBox.setRecordToStringFunction(unitType -> (String)propertyProvider.getValues(unitType, Collections.emptyList()).get("caption"));
        tagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        tagComboBox.setDistinct(true);
        return tagComboBox;
    }
}

